/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.number;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberIncrementingInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(NumberIncrementingInterceptor.class);
    private Dn numberHolder;
    private Map<String, AtomicInteger> incMap = new HashMap<String, AtomicInteger>();

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        this.numberHolder = new Dn(this.schemaManager, "ou=autoIncDataHolder,ou=system");
        Partition systemPartition = directoryService.getSystemPartition();
        LookupOperationContext lookupContext = new LookupOperationContext(directoryService.getAdminSession(), this.numberHolder, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Entry entry = systemPartition.lookup(lookupContext);
        if (entry == null) {
            entry = new DefaultEntry(this.schemaManager);
            entry.setDn(this.numberHolder);
            entry.add("objectClass", "organizationalUnit");
            entry.add("objectClass", "extensibleObject");
            entry.add("ou", this.numberHolder.getRdn().getValue());
            entry.add("entryUUID", UUID.randomUUID().toString());
            entry.add("entryCSN", directoryService.getCSN().toString());
            AddOperationContext addContext = new AddOperationContext(directoryService.getAdminSession());
            addContext.setDn(this.numberHolder);
            addContext.setEntry(new ClonedServerEntry(entry));
            LOG.debug("Adding container entry to hold numeric attribute values");
            systemPartition.add(addContext);
        } else {
            for (Attribute at : entry) {
                MatchingRule mr = at.getAttributeType().getEquality();
                if (mr == null || !"2.5.13.14".equals(mr.getOid())) continue;
                int t = Integer.parseInt(at.getString());
                this.incMap.put(at.getId(), new AtomicInteger(t));
            }
        }
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        LOG.debug(">>> Entering into the number incrementing interceptor, addRequest");
        if (addContext.isReplEvent()) {
            this.next(addContext);
            return;
        }
        Entry entry = addContext.getEntry();
        ArrayList<Attribute> lst = new ArrayList<Attribute>();
        for (String oid : this.incMap.keySet()) {
            Attribute at = entry.get(oid);
            if (at == null) continue;
            lst.add(at);
        }
        if (lst.isEmpty()) {
            this.next(addContext);
            return;
        }
        for (Attribute at : lst) {
            int stored = this.incMap.get(at.getId()).get();
            at.clear();
            at.add(String.valueOf(stored + 1));
        }
        this.next(addContext);
        ModifyOperationContext bindModCtx = new ModifyOperationContext(this.directoryService.getAdminSession());
        bindModCtx.setDn(this.numberHolder);
        bindModCtx.setPushToEvtInterceptor(true);
        ArrayList<Modification> mods = new ArrayList<Modification>();
        for (Attribute at : lst) {
            AtomicInteger ai = this.incMap.get(at.getId());
            ai.set(ai.get() + 1);
            DefaultModification mod = new DefaultModification();
            mod.setOperation(ModificationOperation.REPLACE_ATTRIBUTE);
            mod.setAttribute(at);
            mods.add(mod);
        }
        bindModCtx.setModItems(mods);
        this.directoryService.getPartitionNexus().modify(bindModCtx);
        LOG.debug("Successfully updated numeric attribute in {}", (Object)this.numberHolder);
    }
}

