/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerefAliasSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(DerefAliasSyntaxChecker.class);

    public DerefAliasSyntaxChecker() {
        super("1.3.6.1.4.1.18060.0.4.1.0.11");
    }

    @Override
    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        strValue = Strings.trim(Strings.toLowerCaseAscii(strValue));
        return "never".equals(strValue) || "finding".equals(strValue) || "searching".equals(strValue) || "always".equals(strValue);
    }
}

