/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.DnsMessageModifier;
import org.apache.directory.server.dns.messages.MessageType;
import org.apache.directory.server.dns.messages.OpCode;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.dns.service.DnsContext;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DomainNameService {
    private static final Logger LOG = LoggerFactory.getLogger(DomainNameService.class);

    private DomainNameService() {
    }

    public static void execute(DnsContext dnsContext, DnsMessage request) throws Exception {
        if (LOG.isDebugEnabled()) {
            DomainNameService.monitorRequest(request);
        }
        DomainNameService.getResourceRecords(dnsContext, request);
        if (LOG.isDebugEnabled()) {
            DomainNameService.monitorContext(dnsContext);
        }
        DomainNameService.buildReply(dnsContext, request);
        if (LOG.isDebugEnabled()) {
            DomainNameService.monitorReply(dnsContext);
        }
    }

    private static void monitorRequest(DnsMessage request) throws Exception {
        try {
            LOG.debug(DomainNameService.monitorMessage(request, "request"));
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_153, new Object[0]), e);
        }
    }

    private static void getResourceRecords(DnsContext dnsContext, DnsMessage request) throws Exception {
        RecordStore store = dnsContext.getStore();
        List<QuestionRecord> questions = request.getQuestionRecords();
        Iterator<QuestionRecord> it = questions.iterator();
        while (it.hasNext()) {
            dnsContext.addResourceRecords(DomainNameService.getEntry(store, it.next()));
        }
    }

    private static Set<ResourceRecord> getEntry(RecordStore store, QuestionRecord question) throws DnsException {
        Set<ResourceRecord> records = null;
        records = store.getRecords(question);
        if (records == null || records.isEmpty()) {
            LOG.debug("The domain name referenced in the query does not exist.");
            throw new DnsException(ResponseCode.NAME_ERROR);
        }
        return records;
    }

    private static void monitorContext(DnsContext dnsContext) throws Exception {
        try {
            RecordStore store = dnsContext.getStore();
            List<ResourceRecord> records = dnsContext.getResourceRecords();
            StringBuffer sb = new StringBuffer();
            sb.append("Monitoring context:");
            sb.append("\n\tstore:                     " + store);
            sb.append("\n\trecords:                   " + records);
            LOG.debug(sb.toString());
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_154, new Object[0]), e);
        }
    }

    private static void buildReply(DnsContext dnsContext, DnsMessage request) throws Exception {
        List<ResourceRecord> records = dnsContext.getResourceRecords();
        DnsMessageModifier modifier = new DnsMessageModifier();
        modifier.setTransactionId(request.getTransactionId());
        modifier.setMessageType(MessageType.RESPONSE);
        modifier.setOpCode(OpCode.QUERY);
        modifier.setAuthoritativeAnswer(false);
        modifier.setTruncated(false);
        modifier.setRecursionDesired(request.isRecursionDesired());
        modifier.setRecursionAvailable(false);
        modifier.setReserved(false);
        modifier.setAcceptNonAuthenticatedData(false);
        modifier.setResponseCode(ResponseCode.NO_ERROR);
        modifier.setQuestionRecords(request.getQuestionRecords());
        modifier.setAnswerRecords(records);
        modifier.setAuthorityRecords(new ArrayList<ResourceRecord>());
        modifier.setAdditionalRecords(new ArrayList<ResourceRecord>());
        dnsContext.setReply(modifier.getDnsMessage());
    }

    private static void monitorReply(DnsContext dnsContext) throws Exception {
        try {
            DnsMessage reply = dnsContext.getReply();
            LOG.debug(DomainNameService.monitorMessage(reply, "reply"));
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_155, new Object[0]), e);
        }
    }

    private static String monitorMessage(DnsMessage message, String direction) {
        MessageType messageType = message.getMessageType();
        OpCode opCode = message.getOpCode();
        ResponseCode responseCode = message.getResponseCode();
        int transactionId = message.getTransactionId();
        StringBuffer sb = new StringBuffer();
        sb.append("Monitoring " + direction + ":");
        sb.append("\n\tmessageType                " + messageType);
        sb.append("\n\topCode                     " + opCode);
        sb.append("\n\tresponseCode               " + responseCode);
        sb.append("\n\ttransactionId              " + transactionId);
        sb.append("\n\tauthoritativeAnswer        " + message.isAuthoritativeAnswer());
        sb.append("\n\ttruncated                  " + message.isTruncated());
        sb.append("\n\trecursionDesired           " + message.isRecursionDesired());
        sb.append("\n\trecursionAvailable         " + message.isRecursionAvailable());
        sb.append("\n\treserved                   " + message.isReserved());
        sb.append("\n\tacceptNonAuthenticatedData " + message.isAcceptNonAuthenticatedData());
        List<QuestionRecord> questions = message.getQuestionRecords();
        sb.append("\n\tquestions:                 " + questions);
        return sb.toString();
    }
}

