/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.cursor.SingletonCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapAttributeInUseException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.api.ldap.model.filter.ApproximateNode;
import org.apache.directory.api.ldap.model.filter.BranchNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.ExtensibleNode;
import org.apache.directory.api.ldap.model.filter.GreaterEqNode;
import org.apache.directory.api.ldap.model.filter.LessEqNode;
import org.apache.directory.api.ldap.model.filter.ObjectClassNode;
import org.apache.directory.api.ldap.model.filter.SimpleNode;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.api.ldap.model.schema.registries.Schema;
import org.apache.directory.api.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.api.ldap.model.schema.syntaxCheckers.OctetStringSyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.entry.ServerEntryUtils;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursorImpl;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.partition.PartitionNexus;
import org.apache.directory.server.core.schema.SchemaSubentryManager;
import org.apache.directory.server.core.shared.SchemaService;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaInterceptor.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private PartitionNexus nexus;
    private TopFilter topFilter;
    private List<EntryFilter> filters = new ArrayList<EntryFilter>();
    private String subschemaSubentryDnNorm;
    private Dn subschemaSubentryDn;
    private Dn schemaModificationAttributesDn;
    private SchemaSubentryManager schemaSubEntryManager;
    private Dn schemaBaseDn;
    private Map<String, List<ObjectClass>> superiors;
    private Map<String, List<AttributeType>> allMay;
    private Map<String, List<AttributeType>> allMust;
    private Map<String, List<AttributeType>> allowed;

    public SchemaInterceptor() {
        super(InterceptorEnum.SCHEMA_INTERCEPTOR);
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Initializing SchemaInterceptor...");
        }
        super.init(directoryService);
        this.nexus = directoryService.getPartitionNexus();
        this.topFilter = new TopFilter();
        this.filters.add(this.topFilter);
        this.schemaBaseDn = this.dnFactory.create("ou=schema");
        Value<?> subschemaSubentry = this.nexus.getRootDseValue(directoryService.getAtProvider().getSubschemaSubentry());
        this.subschemaSubentryDn = this.dnFactory.create(subschemaSubentry.getString());
        this.subschemaSubentryDnNorm = this.subschemaSubentryDn.getNormName();
        this.schemaModificationAttributesDn = this.dnFactory.create("ou=schemaModifications,ou=schema");
        this.computeSuperiors();
        SchemaLoader loader = directoryService.getSchemaManager().getLoader();
        this.schemaSubEntryManager = new SchemaSubentryManager(this.schemaManager, loader, this.dnFactory);
        if (IS_DEBUG) {
            LOG.debug("SchemaInterceptor Initialized !");
        }
    }

    private void computeMustAttributes(ObjectClass objectClass, Set<String> atSeen) throws LdapException {
        List<ObjectClass> parents = this.superiors.get(objectClass.getOid());
        ArrayList<AttributeType> mustList = new ArrayList<AttributeType>();
        ArrayList<AttributeType> allowedList = new ArrayList<AttributeType>();
        HashSet<String> mustSeen = new HashSet<String>();
        this.allMust.put(objectClass.getOid(), mustList);
        this.allowed.put(objectClass.getOid(), allowedList);
        for (ObjectClass parent : parents) {
            List<AttributeType> mustParent = parent.getMustAttributeTypes();
            if (mustParent == null || mustParent.size() == 0) continue;
            for (AttributeType attributeType : mustParent) {
                String oid = attributeType.getOid();
                if (mustSeen.contains(oid)) continue;
                mustSeen.add(oid);
                mustList.add(attributeType);
                allowedList.add(attributeType);
                atSeen.add(attributeType.getOid());
            }
        }
    }

    private void computeMayAttributes(ObjectClass objectClass, Set<String> atSeen) throws LdapException {
        List<ObjectClass> parents = this.superiors.get(objectClass.getOid());
        ArrayList<AttributeType> mayList = new ArrayList<AttributeType>();
        HashSet<String> maySeen = new HashSet<String>();
        List<AttributeType> allowedList = this.allowed.get(objectClass.getOid());
        this.allMay.put(objectClass.getOid(), mayList);
        for (ObjectClass parent : parents) {
            List<AttributeType> mustParent = parent.getMustAttributeTypes();
            if (mustParent == null || mustParent.size() == 0) continue;
            for (AttributeType attributeType : mustParent) {
                String oid = attributeType.getOid();
                if (maySeen.contains(oid)) continue;
                maySeen.add(oid);
                mayList.add(attributeType);
                if (atSeen.contains(oid)) continue;
                allowedList.add(attributeType);
            }
        }
    }

    private void computeOCSuperiors(ObjectClass objectClass, List<ObjectClass> superiors, Set<String> ocSeen) throws LdapException {
        List<ObjectClass> parents = objectClass.getSuperiors();
        if (parents != null && parents.size() != 0) {
            for (ObjectClass parent : parents) {
                if ("top".equals(parent.getName())) continue;
                this.computeOCSuperiors(parent, superiors, ocSeen);
                String oid = parent.getOid();
                if (ocSeen.contains(oid)) continue;
                superiors.add(parent);
                ocSeen.add(oid);
            }
        }
    }

    private void computeSuperior(ObjectClass objectClass) throws LdapException {
        ArrayList<ObjectClass> ocSuperiors = new ArrayList<ObjectClass>();
        this.superiors.put(objectClass.getOid(), ocSuperiors);
        this.computeOCSuperiors(objectClass, ocSuperiors, new HashSet<String>());
        HashSet<String> atSeen = new HashSet<String>();
        this.computeMustAttributes(objectClass, atSeen);
        this.computeMayAttributes(objectClass, atSeen);
        this.superiors.put(objectClass.getName(), ocSuperiors);
    }

    private void computeSuperiors() throws LdapException {
        Iterator objectClasses = this.schemaManager.getObjectClassRegistry().iterator();
        this.superiors = new ConcurrentHashMap<String, List<ObjectClass>>();
        this.allMust = new ConcurrentHashMap<String, List<AttributeType>>();
        this.allMay = new ConcurrentHashMap<String, List<AttributeType>>();
        this.allowed = new ConcurrentHashMap<String, List<AttributeType>>();
        while (objectClasses.hasNext()) {
            ObjectClass objectClass = (ObjectClass)objectClasses.next();
            this.computeSuperior(objectClass);
        }
    }

    private Value<?> convert(AttributeType attributeType, Value<?> value) throws LdapException {
        if (attributeType.getSyntax().isHumanReadable()) {
            if (value instanceof BinaryValue) {
                try {
                    return new StringValue(attributeType, new String(((BinaryValue)value).getBytes(), "UTF-8"));
                }
                catch (UnsupportedEncodingException uee) {
                    String message = I18n.err(I18n.ERR_47, new Object[0]);
                    LOG.error(message);
                    throw new LdapException(message);
                }
            }
        } else if (value instanceof StringValue) {
            return new BinaryValue(attributeType, ((StringValue)value).getBytes());
        }
        return null;
    }

    private void checkFilter(ExprNode filter) throws LdapException {
        block8: {
            block6: {
                block11: {
                    block10: {
                        block9: {
                            block7: {
                                if (filter == null) {
                                    String message = I18n.err(I18n.ERR_49, new Object[0]);
                                    LOG.error(message);
                                    throw new LdapException(message);
                                }
                                if (filter instanceof ObjectClassNode) {
                                    return;
                                }
                                if (!filter.isLeaf()) break block6;
                                if (!(filter instanceof EqualityNode)) break block7;
                                EqualityNode node = (EqualityNode)filter;
                                Value value = node.getValue();
                                Value<?> newValue = this.convert(node.getAttributeType(), value);
                                if (newValue != null) {
                                    node.setValue(newValue);
                                }
                                break block8;
                            }
                            if (!(filter instanceof GreaterEqNode)) break block9;
                            GreaterEqNode node = (GreaterEqNode)filter;
                            Value value = node.getValue();
                            Value<?> newValue = this.convert(node.getAttributeType(), value);
                            if (newValue != null) {
                                node.setValue(newValue);
                            }
                            break block8;
                        }
                        if (!(filter instanceof LessEqNode)) break block10;
                        LessEqNode node = (LessEqNode)filter;
                        Value value = node.getValue();
                        Value<?> newValue = this.convert(node.getAttributeType(), value);
                        if (newValue != null) {
                            node.setValue(newValue);
                        }
                        break block8;
                    }
                    if (!(filter instanceof ExtensibleNode)) break block11;
                    ExtensibleNode node = (ExtensibleNode)filter;
                    break block8;
                }
                if (!(filter instanceof ApproximateNode)) break block8;
                ApproximateNode node = (ApproximateNode)filter;
                Value value = node.getValue();
                Value<?> newValue = this.convert(node.getAttributeType(), value);
                if (newValue == null) break block8;
                node.setValue(newValue);
                break block8;
            }
            for (ExprNode child : ((BranchNode)filter).getChildren()) {
                this.checkFilter(child);
            }
        }
    }

    private void getSuperiors(ObjectClass oc, Set<String> ocSeen, List<ObjectClass> result) throws LdapException {
        for (ObjectClass parent : oc.getSuperiors()) {
            if ("top".equals(parent.getName())) continue;
            if (!ocSeen.contains(parent.getOid())) {
                ocSeen.add(parent.getOid());
                result.add(parent);
            }
            this.getSuperiors(parent, ocSeen, result);
        }
    }

    private boolean getObjectClasses(Attribute objectClasses, List<ObjectClass> result) throws LdapException {
        HashSet<String> ocSeen = new HashSet<String>();
        boolean hasExtensibleObject = false;
        for (Value objectClass : objectClasses) {
            ObjectClass oc;
            String objectClassName = objectClass.getString();
            if ("top".equals(objectClassName)) continue;
            if ("extensibleObject".equalsIgnoreCase(objectClassName)) {
                hasExtensibleObject = true;
            }
            if (!ocSeen.contains((oc = this.schemaManager.lookupObjectClassRegistry(objectClassName)).getOid())) {
                ocSeen.add(oc.getOid());
                result.add(oc);
            }
            this.getSuperiors(oc, ocSeen, result);
        }
        return hasExtensibleObject;
    }

    private Set<String> getAllMust(Attribute objectClasses) throws LdapException {
        HashSet<String> must = new HashSet<String>();
        for (Value value : objectClasses) {
            String ocName = value.getString();
            ObjectClass oc = this.schemaManager.lookupObjectClassRegistry(ocName);
            List<AttributeType> types = oc.getMustAttributeTypes();
            if (types == null || types.size() <= 0) continue;
            for (AttributeType type : types) {
                must.add(type.getOid());
            }
        }
        return must;
    }

    private Set<String> getAllAllowed(Attribute objectClasses, Set<String> must) throws LdapException {
        HashSet<String> allowed = new HashSet<String>(must);
        allowed.add("2.5.4.0");
        for (Value objectClass : objectClasses) {
            String ocName = objectClass.getString();
            ObjectClass oc = this.schemaManager.lookupObjectClassRegistry(ocName);
            List<AttributeType> types = oc.getMayAttributeTypes();
            if (types == null || types.size() <= 0) continue;
            for (AttributeType type : types) {
                String oid = type.getOid();
                allowed.add(oid);
            }
        }
        return allowed;
    }

    private void alterObjectClasses(Attribute objectClassAttr) throws LdapException {
        HashSet<String> objectClasses = new HashSet<String>();
        HashSet<String> objectClassesUP = new HashSet<String>();
        objectClasses.add("top");
        objectClassesUP.add("top");
        for (Value ocValue : objectClassAttr) {
            List<ObjectClass> ocSuperiors;
            String ocName = ocValue.getString();
            if (ocName.equalsIgnoreCase("top")) continue;
            String ocLowerName = Strings.toLowerCaseAscii(ocName);
            ObjectClass objectClass = this.schemaManager.lookupObjectClassRegistry(ocLowerName);
            if (!objectClasses.contains(ocLowerName)) {
                objectClasses.add(ocLowerName);
                objectClassesUP.add(ocName);
            }
            if ((ocSuperiors = this.superiors.get(objectClass.getOid())) == null) continue;
            for (ObjectClass oc : ocSuperiors) {
                if (objectClasses.contains(Strings.toLowerCaseAscii(oc.getName()))) continue;
                objectClasses.add(oc.getName());
                objectClassesUP.add(oc.getName());
            }
        }
        objectClassAttr.clear();
        for (String attribute : objectClassesUP) {
            objectClassAttr.add(attribute);
        }
    }

    private Attribute createNewAttribute(Attribute attribute) throws LdapException {
        AttributeType attributeType = attribute.getAttributeType();
        DefaultAttribute newAttribute = new DefaultAttribute(attribute.getUpId(), attributeType);
        for (Value value : attribute) {
            newAttribute.add(value);
        }
        return newAttribute;
    }

    private void checkModifyEntry(ModifyOperationContext modifyContext) throws LdapException {
        Dn dn = modifyContext.getDn();
        Entry currentEntry = modifyContext.getEntry();
        List<Modification> mods = modifyContext.getModItems();
        Entry tempEntry = currentEntry.clone();
        block5: for (Modification mod : mods) {
            Attribute attribute = mod.getAttribute();
            AttributeType attributeType = attribute.getAttributeType();
            this.assertAttributeIsModifyable(modifyContext, attributeType);
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    Attribute currentAttribute = tempEntry.get(attributeType);
                    if (currentAttribute != null) {
                        for (Value value : attribute) {
                            if (currentAttribute.contains(value)) {
                                String msg = I18n.err(I18n.ERR_54, value);
                                LOG.error(msg);
                                throw new LdapAttributeInUseException(msg);
                            }
                            currentAttribute.add(value);
                        }
                        continue block5;
                    }
                    Attribute newAttribute = attribute.clone();
                    if (newAttribute.size() == 0 && !newAttribute.isValid(attributeType)) {
                        String msg = I18n.err(I18n.ERR_54, null);
                        LOG.error(msg);
                        throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg);
                    }
                    tempEntry.put(newAttribute);
                    break;
                }
                case REMOVE_ATTRIBUTE: {
                    if (!tempEntry.containsAttribute(attributeType)) {
                        String msg = I18n.err(I18n.ERR_55, attributeType);
                        LOG.error(msg);
                        throw new LdapNoSuchAttributeException(msg);
                    }
                    if (attribute.size() == 0) {
                        tempEntry.removeAttributes(attributeType);
                        break;
                    }
                    Attribute currentAttribute = tempEntry.get(attributeType);
                    for (Value value : attribute) {
                        if (currentAttribute.contains(value)) {
                            currentAttribute.remove(value);
                            continue;
                        }
                        String msg = I18n.err(I18n.ERR_56, attributeType);
                        LOG.error(msg);
                        throw new LdapNoSuchAttributeException(msg);
                    }
                    if (currentAttribute.size() != 0) continue block5;
                    tempEntry.removeAttributes(attributeType);
                    break;
                }
                case REPLACE_ATTRIBUTE: {
                    Attribute newAttribute;
                    if (!tempEntry.containsAttribute(attributeType)) {
                        if (attribute.size() == 0) break;
                        newAttribute = this.createNewAttribute(attribute);
                        tempEntry.put(newAttribute);
                        break;
                    }
                    if (attribute.size() == 0) {
                        tempEntry.removeAttributes(attributeType);
                        break;
                    }
                    tempEntry.removeAttributes(attributeType);
                    newAttribute = this.createNewAttribute(attribute);
                    tempEntry.put(newAttribute);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected modify operation " + (Object)((Object)mod.getOperation()));
                }
            }
        }
        this.check(dn, tempEntry);
    }

    private void assertAttributeIsModifyable(ModifyOperationContext modifyContext, AttributeType attributeType) throws LdapNoPermissionException {
        if (attributeType.isUserModifiable()) {
            return;
        }
        if (modifyContext.isReplEvent() && modifyContext.getSession().isAdministrator()) {
            return;
        }
        if (!(attributeType.equals(this.directoryService.getAtProvider().getModifiersName()) || attributeType.equals(this.directoryService.getAtProvider().getModifyTimestamp()) || attributeType.equals(this.directoryService.getAtProvider().getEntryCSN()) || PWD_POLICY_STATE_ATTRIBUTE_TYPES.contains(attributeType))) {
            String msg = I18n.err(I18n.ERR_52, attributeType);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
    }

    private void check(Dn dn, Entry entry) throws LdapException {
        for (Attribute attribute : entry.getAttributes()) {
            AttributeType attributeType = attribute.getAttributeType();
            if (this.schemaManager.getAttributeTypeRegistry().contains(attributeType.getName())) continue;
            throw new LdapInvalidAttributeTypeException(I18n.err(I18n.ERR_275, attributeType.getName()));
        }
        Attribute objectClassAttr = entry.get(this.directoryService.getAtProvider().getObjectClass());
        if (objectClassAttr == null) {
            objectClassAttr = new DefaultAttribute(this.directoryService.getAtProvider().getObjectClass());
        }
        ArrayList<ObjectClass> ocs = new ArrayList<ObjectClass>();
        this.alterObjectClasses(objectClassAttr);
        Set<String> must = this.getAllMust(objectClassAttr);
        Set<String> allowed = this.getAllAllowed(objectClassAttr, must);
        boolean hasExtensibleObject = this.getObjectClasses(objectClassAttr, ocs);
        this.assertObjectClasses(dn, ocs);
        this.assertRequiredAttributesPresent(dn, entry, must);
        this.assertNumberOfAttributeValuesValid(entry);
        if (!hasExtensibleObject) {
            this.assertAllAttributesAllowed(dn, entry, allowed);
        }
        this.assertHumanReadable(entry);
        this.assertSyntaxes(entry);
        this.assertRdn(dn, entry);
    }

    private void checkOcSuperior(Entry entry) throws LdapException {
        Attribute supOC = entry.get("m-supObjectClass");
        if (supOC != null) {
            ObjectClassTypeEnum ocType = ObjectClassTypeEnum.STRUCTURAL;
            if (entry.get("m-typeObjectClass") != null) {
                String type = entry.get("m-typeObjectClass").getString();
                ocType = ObjectClassTypeEnum.getClassType(type);
            }
            block7: for (Value sup : supOC) {
                try {
                    String supName = sup.getString();
                    ObjectClass superior = this.schemaManager.lookupObjectClassRegistry(supName);
                    switch (ocType) {
                        case ABSTRACT: {
                            if (superior.isAbstract()) continue block7;
                            String message = I18n.err(I18n.ERR_57, new Object[0]);
                            LOG.error(message);
                            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, message);
                        }
                        case AUXILIARY: {
                            if (superior.isAbstract() || superior.isAuxiliary()) continue block7;
                            String message = I18n.err(I18n.ERR_58, new Object[0]);
                            LOG.error(message);
                            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, message);
                        }
                        case STRUCTURAL: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected object class type " + (Object)((Object)ocType));
                        }
                    }
                }
                catch (LdapException ne) {
                    String message = I18n.err(I18n.ERR_59, new Object[0]);
                    LOG.error(message);
                    throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, message);
                }
            }
        }
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        Dn name = addContext.getDn();
        Entry entry = addContext.getEntry();
        this.check(name, entry);
        if (name.isDescendantOf(this.schemaBaseDn)) {
            String schemaName = this.getSchemaName(name);
            if (entry.contains(this.directoryService.getAtProvider().getObjectClass(), "metaSchema")) {
                this.next(addContext);
                if (this.schemaManager.isSchemaLoaded(schemaName)) {
                    this.computeSuperiors();
                }
            } else if (entry.contains(this.directoryService.getAtProvider().getObjectClass(), "metaObjectClass")) {
                this.checkOcSuperior(addContext.getEntry());
                this.next(addContext);
                Schema schema = this.schemaManager.getLoadedSchema(schemaName);
                if (schema != null && schema.isEnabled()) {
                    Attribute oidAT = entry.get("m-oid");
                    String ocOid = oidAT.getString();
                    ObjectClass addedOC = this.schemaManager.lookupObjectClassRegistry(ocOid);
                    this.computeSuperior(addedOC);
                }
            } else if (entry.contains(this.directoryService.getAtProvider().getObjectClass(), "metaAttributeType")) {
                this.next(addContext);
            } else {
                this.next(addContext);
            }
        } else {
            this.next(addContext);
        }
    }

    @Override
    public boolean compare(CompareOperationContext compareContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", (Object)compareContext);
        }
        if (!this.schemaManager.getAttributeTypeRegistry().contains(compareContext.getOid())) {
            throw new LdapInvalidAttributeTypeException(I18n.err(I18n.ERR_266, compareContext.getOid()));
        }
        boolean result = this.next(compareContext);
        return result;
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        Entry entry = this.next(lookupContext);
        ServerEntryUtils.filterContents(lookupContext.getSession().getDirectoryService().getSchemaManager(), lookupContext, entry);
        return entry;
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        Dn dn = modifyContext.getDn();
        if (dn.equals(this.subschemaSubentryDn)) {
            LOG.debug("Modification attempt on schema subentry {}: \n{}", (Object)dn, (Object)modifyContext);
            List<Modification> mods = modifyContext.getModItems();
            ArrayList<Modification> cleanMods = new ArrayList<Modification>();
            for (Modification mod : mods) {
                AttributeType at = ((DefaultModification)mod).getAttribute().getAttributeType();
                if (this.directoryService.getAtProvider().getModifiersName().equals(at) || this.directoryService.getAtProvider().getModifyTimestamp().equals(at) || this.directoryService.getAtProvider().getEntryCSN().equals(at)) continue;
                cleanMods.add(mod);
            }
            modifyContext.setModItems(cleanMods);
            this.schemaSubEntryManager.modifySchemaSubentry(modifyContext, modifyContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"));
            return;
        }
        this.checkModifyEntry(modifyContext);
        this.next(modifyContext);
    }

    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        Dn oldDn = renameContext.getDn();
        Rdn newRdn = renameContext.getNewRdn();
        boolean deleteOldRn = renameContext.getDeleteOldRdn();
        Entry entry = ((ClonedServerEntry)renameContext.getEntry()).getClonedEntry();
        if (deleteOldRn) {
            Rdn oldRdn = oldDn.getRdn();
            for (Ava atav : oldRdn) {
                AttributeType type = this.schemaManager.lookupAttributeTypeRegistry(atav.getType());
                entry.remove(type, atav.getValue());
            }
            for (Ava atav : oldRdn) {
                AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(atav.getType());
                if (attributeType.isUserModifiable()) continue;
                throw new LdapNoPermissionException("Cannot modify the attribute '" + atav.getType() + "'");
            }
        }
        for (Ava atav : newRdn) {
            AttributeType type = this.schemaManager.lookupAttributeTypeRegistry(atav.getType());
            entry.add(new DefaultAttribute(type, atav.getValue()));
        }
        entry.setDn(renameContext.getNewDn());
        this.check(renameContext.getNewDn(), entry);
        this.next(renameContext);
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        String baseNormForm;
        Dn base = searchContext.getDn();
        ExprNode filter = searchContext.getFilter();
        this.checkFilter(filter);
        String string = baseNormForm = base.isSchemaAware() ? base.getNormName() : base.getNormName();
        if (!this.subschemaSubentryDnNorm.equals(baseNormForm)) {
            EntryFilteringCursor cursor = this.next(searchContext);
            if (searchContext.getReturningAttributesString() != null) {
                cursor.addEntryFilter(this.topFilter);
                return cursor;
            }
            for (EntryFilter ef : this.filters) {
                cursor.addEntryFilter(ef);
            }
            return cursor;
        }
        if (searchContext.getScope() == SearchScope.OBJECT) {
            if (filter instanceof SimpleNode) {
                SimpleNode node = (SimpleNode)filter;
                String objectClass = node.getValue().getString();
                String objectClassOid = null;
                if (!this.schemaManager.getObjectClassRegistry().contains(objectClass)) {
                    return new EntryFilteringCursorImpl(new EmptyCursor<Entry>(), searchContext, this.schemaManager);
                }
                objectClassOid = this.schemaManager.lookupObjectClassRegistry(objectClass).getOid();
                AttributeType nodeAt = node.getAttributeType();
                if (nodeAt.equals(this.directoryService.getAtProvider().getObjectClass()) && (objectClassOid.equals("2.5.6.0") || objectClassOid.equals("2.5.20.1")) && node instanceof EqualityNode) {
                    Entry serverEntry = SchemaService.getSubschemaEntry(this.directoryService, searchContext);
                    serverEntry.setDn(base);
                    return new EntryFilteringCursorImpl(new SingletonCursor<Entry>(serverEntry), searchContext, this.schemaManager);
                }
                return new EntryFilteringCursorImpl(new EmptyCursor<Entry>(), searchContext, this.schemaManager);
            }
            if (filter instanceof ObjectClassNode) {
                Entry serverEntry = SchemaService.getSubschemaEntry(this.directoryService, searchContext);
                serverEntry.setDn(base);
                EntryFilteringCursorImpl cursor = new EntryFilteringCursorImpl(new SingletonCursor<Entry>(serverEntry), searchContext, this.schemaManager);
                return cursor;
            }
        }
        return new EntryFilteringCursorImpl(new EmptyCursor<Entry>(), searchContext, this.schemaManager);
    }

    private String getSchemaName(Dn dn) throws LdapException {
        int size = dn.size();
        if (size < 2) {
            throw new LdapException(I18n.err(I18n.ERR_276, new Object[0]));
        }
        Rdn rdn = dn.getRdn(size - 2);
        return rdn.getNormValue();
    }

    private void assertAllAttributesAllowed(Dn dn, Entry entry, Set<String> allowed) throws LdapException {
        Attribute objectClass = entry.get(this.directoryService.getAtProvider().getObjectClass());
        if (objectClass.contains("extensibleObject")) {
            return;
        }
        for (Attribute attribute : entry) {
            String attrOid = attribute.getAttributeType().getOid();
            AttributeType attributeType = attribute.getAttributeType();
            if (attributeType.isCollective() || attributeType.getUsage() != UsageEnum.USER_APPLICATIONS || allowed.contains(attrOid)) continue;
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, I18n.err(I18n.ERR_277, attribute.getUpId(), dn.getName()));
        }
    }

    private void assertNumberOfAttributeValuesValid(Entry entry) throws LdapInvalidAttributeValueException {
        for (Attribute attribute : entry) {
            this.assertNumberOfAttributeValuesValid(attribute);
        }
    }

    private void assertNumberOfAttributeValuesValid(Attribute attribute) throws LdapInvalidAttributeValueException {
        if (attribute.size() > 1 && attribute.getAttributeType().isSingleValued()) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.CONSTRAINT_VIOLATION, I18n.err(I18n.ERR_278, attribute.getUpId()));
        }
    }

    private void assertRequiredAttributesPresent(Dn dn, Entry entry, Set<String> must) throws LdapException {
        for (Object attribute : entry) {
            must.remove(attribute.getAttributeType().getOid());
        }
        if (must.size() != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (String oid : must) {
                String name = this.schemaManager.getAttributeType(oid).getName();
                sb.append(name).append('(').append(oid).append("), ");
            }
            int end = sb.length();
            sb.replace(end - 2, end, "");
            sb.append(']');
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, I18n.err(I18n.ERR_279, sb, dn.getName()));
        }
    }

    private void assertObjectClasses(Dn dn, List<ObjectClass> ocs) throws LdapException {
        HashSet<ObjectClass> structuralObjectClasses = new HashSet<ObjectClass>();
        for (ObjectClass objectClass : ocs) {
            if (!objectClass.isStructural()) continue;
            structuralObjectClasses.add(objectClass);
        }
        if (structuralObjectClasses.isEmpty()) {
            String message = I18n.err(I18n.ERR_60, dn);
            LOG.error(message);
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, message);
        }
        HashSet<ObjectClass> remaining = new HashSet<ObjectClass>(structuralObjectClasses.size());
        remaining.addAll(structuralObjectClasses);
        for (ObjectClass oc : structuralObjectClasses) {
            if (oc.getSuperiors() == null) continue;
            for (ObjectClass superClass : oc.getSuperiors()) {
                if (!superClass.isStructural()) continue;
                remaining.remove(superClass);
            }
        }
        if (remaining.size() > 1) {
            String string = I18n.err(I18n.ERR_61, dn, remaining);
            LOG.error(string);
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, string);
        }
    }

    private void assertSyntaxes(Entry entry) throws LdapException {
        for (Attribute attribute : entry) {
            AttributeType attributeType = attribute.getAttributeType();
            SyntaxChecker syntaxChecker = attributeType.getSyntax().getSyntaxChecker();
            if (syntaxChecker instanceof OctetStringSyntaxChecker) continue;
            for (Value value : attribute) {
                if (value.isSchemaAware() || syntaxChecker.isValidSyntax(value.getValue())) continue;
                String message = I18n.err(I18n.ERR_280, value.getString(), attribute.getUpId());
                LOG.info(message);
                throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
            }
        }
    }

    private void assertRdn(Dn dn, Entry entry) throws LdapException {
        for (Ava atav : dn.getRdn()) {
            Attribute attribute = entry.get(atav.getNormType());
            if (attribute != null && attribute.contains(atav.getValue())) continue;
            String message = I18n.err(I18n.ERR_62, dn, atav.getType());
            LOG.error(message);
            throw new LdapSchemaViolationException(ResultCodeEnum.NOT_ALLOWED_ON_RDN, message);
        }
    }

    private boolean checkHumanReadable(Attribute attribute) throws LdapException {
        boolean isModified = false;
        for (Value value : attribute) {
            if (value instanceof StringValue) continue;
            if (value instanceof BinaryValue) {
                try {
                    String valStr = new String(value.getBytes(), "UTF-8");
                    attribute.remove(value);
                    attribute.add(valStr);
                    isModified = true;
                    continue;
                }
                catch (UnsupportedEncodingException uee) {
                    throw new LdapException(I18n.err(I18n.ERR_281, new Object[0]));
                }
            }
            throw new LdapException(I18n.err(I18n.ERR_282, new Object[0]));
        }
        return isModified;
    }

    private boolean checkNotHumanReadable(Attribute attribute) throws LdapException {
        boolean isModified = false;
        for (Value value : attribute) {
            if (value instanceof BinaryValue) continue;
            if (value instanceof StringValue) {
                try {
                    byte[] valBytes = value.getString().getBytes("UTF-8");
                    attribute.remove(value);
                    attribute.add(new byte[][]{valBytes});
                    isModified = true;
                    continue;
                }
                catch (UnsupportedEncodingException uee) {
                    String message = I18n.err(I18n.ERR_63, new Object[0]);
                    LOG.error(message);
                    throw new LdapException(message);
                }
            }
            String message = I18n.err(I18n.ERR_64, new Object[0]);
            LOG.error(message);
            throw new LdapException(message);
        }
        return isModified;
    }

    private void assertHumanReadable(Entry entry) throws LdapException {
        boolean isModified = false;
        Entry clonedEntry = null;
        for (Attribute attribute : entry) {
            AttributeType attributeType = attribute.getAttributeType();
            isModified = attributeType.getSyntax().isHumanReadable() ? this.checkHumanReadable(attribute) : this.checkNotHumanReadable(attribute);
            if (!isModified) continue;
            if (clonedEntry == null) {
                clonedEntry = entry.clone();
            }
            clonedEntry.put(attribute);
            isModified = false;
        }
        if (clonedEntry != null) {
            entry = clonedEntry;
        }
    }

    private class TopFilter
    implements EntryFilter {
        private TopFilter() {
        }

        @Override
        public boolean accept(SearchOperationContext operationContext, Entry entry) throws LdapException {
            ServerEntryUtils.filterContents(SchemaInterceptor.this.schemaManager, operationContext, entry);
            return true;
        }

        @Override
        public String toString(String tabs) {
            return tabs + "TopFilter";
        }
    }
}

