/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.schema.loader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.registries.AbstractSchemaLoader;
import org.apache.directory.api.ldap.model.schema.registries.Schema;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifSchemaLoader
extends AbstractSchemaLoader {
    private static final String LDIF_EXT = "ldif";
    private static final String OU_SCHEMA_LDIF = "ou=schema.ldif";
    private static final Logger LOG = LoggerFactory.getLogger(LdifSchemaLoader.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private final File baseDirectory;
    private final FilenameFilter ldifFilter = new FilenameFilter(){

        @Override
        public boolean accept(File file, String name) {
            return name.endsWith(LdifSchemaLoader.LDIF_EXT);
        }
    };

    public LdifSchemaLoader(File baseDirectory) throws Exception {
        this.baseDirectory = baseDirectory;
        if (!baseDirectory.exists()) {
            String msg = "Provided baseDirectory '" + baseDirectory.getAbsolutePath() + "' does not exist.";
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        File schemaLdif = new File(baseDirectory, OU_SCHEMA_LDIF);
        if (!schemaLdif.exists()) {
            String msg = I18n.err(I18n.ERR_10004, schemaLdif.getAbsolutePath());
            LOG.error(msg);
            throw new FileNotFoundException(msg);
        }
        if (IS_DEBUG) {
            LOG.debug("Using '{}' as the base schema load directory.", (Object)baseDirectory);
        }
        this.initializeSchemas();
    }

    private void initializeSchemas() throws Exception {
        File schemaDirectory;
        String[] ldifFiles;
        if (IS_DEBUG) {
            LOG.debug("Initializing schema");
        }
        if ((ldifFiles = (schemaDirectory = new File(this.baseDirectory, "ou=schema")).list(this.ldifFilter)) != null) {
            for (String ldifFile : ldifFiles) {
                File file = new File(schemaDirectory, ldifFile);
                try {
                    LdifReader reader = new LdifReader(file);
                    LdifEntry entry = reader.next();
                    reader.close();
                    Schema schema = this.getSchema(entry.getEntry());
                    if (schema == null) continue;
                    this.schemaMap.put(schema.getSchemaName(), schema);
                    if (!IS_DEBUG) continue;
                    LOG.debug("Schema Initialized ... \n{}", (Object)schema);
                }
                catch (Exception e) {
                    LOG.error(I18n.err(I18n.ERR_10003, ldifFile), e);
                    throw e;
                }
            }
        }
    }

    private File getSchemaDirectory(Schema schema) {
        return new File(new File(this.baseDirectory, "ou=schema"), "cn=" + Strings.lowerCase(schema.getSchemaName()));
    }

    @Override
    public List<Entry> loadComparators(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> comparatorList = new ArrayList<Entry>();
        if (schemas == null) {
            return comparatorList;
        }
        for (Schema schema : schemas) {
            File comparatorsDirectory = new File(this.getSchemaDirectory(schema), "ou=comparators");
            if (!comparatorsDirectory.exists()) {
                return comparatorList;
            }
            File[] comparators = comparatorsDirectory.listFiles(this.ldifFilter);
            if (comparators == null) continue;
            for (File ldifFile : comparators) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                comparatorList.add(entry.getEntry());
            }
        }
        return comparatorList;
    }

    @Override
    public List<Entry> loadSyntaxCheckers(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> syntaxCheckerList = new ArrayList<Entry>();
        if (schemas == null) {
            return syntaxCheckerList;
        }
        for (Schema schema : schemas) {
            File syntaxCheckersDirectory = new File(this.getSchemaDirectory(schema), "ou=syntaxcheckers");
            if (!syntaxCheckersDirectory.exists()) {
                return syntaxCheckerList;
            }
            File[] syntaxCheckerFiles = syntaxCheckersDirectory.listFiles(this.ldifFilter);
            if (syntaxCheckerFiles == null) continue;
            for (File ldifFile : syntaxCheckerFiles) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                syntaxCheckerList.add(entry.getEntry());
            }
        }
        return syntaxCheckerList;
    }

    @Override
    public List<Entry> loadNormalizers(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> normalizerList = new ArrayList<Entry>();
        if (schemas == null) {
            return normalizerList;
        }
        for (Schema schema : schemas) {
            File normalizersDirectory = new File(this.getSchemaDirectory(schema), "ou=normalizers");
            if (!normalizersDirectory.exists()) {
                return normalizerList;
            }
            File[] normalizerFiles = normalizersDirectory.listFiles(this.ldifFilter);
            if (normalizerFiles == null) continue;
            for (File ldifFile : normalizerFiles) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                normalizerList.add(entry.getEntry());
            }
        }
        return normalizerList;
    }

    @Override
    public List<Entry> loadMatchingRules(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> matchingRuleList = new ArrayList<Entry>();
        if (schemas == null) {
            return matchingRuleList;
        }
        for (Schema schema : schemas) {
            File matchingRulesDirectory = new File(this.getSchemaDirectory(schema), "ou=matchingrules");
            if (!matchingRulesDirectory.exists()) {
                return matchingRuleList;
            }
            File[] matchingRuleFiles = matchingRulesDirectory.listFiles(this.ldifFilter);
            if (matchingRuleFiles == null) continue;
            for (File ldifFile : matchingRuleFiles) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                matchingRuleList.add(entry.getEntry());
            }
        }
        return matchingRuleList;
    }

    @Override
    public List<Entry> loadSyntaxes(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> syntaxList = new ArrayList<Entry>();
        if (schemas == null) {
            return syntaxList;
        }
        for (Schema schema : schemas) {
            File syntaxesDirectory = new File(this.getSchemaDirectory(schema), "ou=syntaxes");
            if (!syntaxesDirectory.exists()) {
                return syntaxList;
            }
            File[] syntaxFiles = syntaxesDirectory.listFiles(this.ldifFilter);
            if (syntaxFiles == null) continue;
            for (File ldifFile : syntaxFiles) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                syntaxList.add(entry.getEntry());
            }
        }
        return syntaxList;
    }

    @Override
    public List<Entry> loadAttributeTypes(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> attributeTypeList = new ArrayList<Entry>();
        if (schemas == null) {
            return attributeTypeList;
        }
        for (Schema schema : schemas) {
            File attributeTypesDirectory = new File(this.getSchemaDirectory(schema), "ou=attributetypes");
            if (!attributeTypesDirectory.exists()) {
                return attributeTypeList;
            }
            File[] attributeTypeFiles = attributeTypesDirectory.listFiles(this.ldifFilter);
            if (attributeTypeFiles == null) continue;
            for (File ldifFile : attributeTypeFiles) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                attributeTypeList.add(entry.getEntry());
            }
        }
        return attributeTypeList;
    }

    @Override
    public List<Entry> loadMatchingRuleUses(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> matchingRuleUseList = new ArrayList<Entry>();
        if (schemas == null) {
            return matchingRuleUseList;
        }
        for (Schema schema : schemas) {
            File matchingRuleUsesDirectory = new File(this.getSchemaDirectory(schema), "ou=matchingruleuse");
            if (!matchingRuleUsesDirectory.exists()) {
                return matchingRuleUseList;
            }
            File[] matchingRuleUseFiles = matchingRuleUsesDirectory.listFiles(this.ldifFilter);
            if (matchingRuleUseFiles == null) continue;
            for (File ldifFile : matchingRuleUseFiles) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                matchingRuleUseList.add(entry.getEntry());
            }
        }
        return matchingRuleUseList;
    }

    @Override
    public List<Entry> loadNameForms(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> nameFormList = new ArrayList<Entry>();
        if (schemas == null) {
            return nameFormList;
        }
        for (Schema schema : schemas) {
            File nameFormsDirectory = new File(this.getSchemaDirectory(schema), "ou=nameforms");
            if (!nameFormsDirectory.exists()) {
                return nameFormList;
            }
            File[] nameFormFiles = nameFormsDirectory.listFiles(this.ldifFilter);
            if (nameFormFiles == null) continue;
            for (File ldifFile : nameFormFiles) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                nameFormList.add(entry.getEntry());
            }
        }
        return nameFormList;
    }

    @Override
    public List<Entry> loadDitContentRules(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> ditContentRuleList = new ArrayList<Entry>();
        if (schemas == null) {
            return ditContentRuleList;
        }
        for (Schema schema : schemas) {
            File ditContentRulesDirectory = new File(this.getSchemaDirectory(schema), "ou=ditcontentrules");
            if (!ditContentRulesDirectory.exists()) {
                return ditContentRuleList;
            }
            File[] ditContentRuleFiles = ditContentRulesDirectory.listFiles(this.ldifFilter);
            if (ditContentRuleFiles == null) continue;
            for (File ldifFile : ditContentRuleFiles) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                ditContentRuleList.add(entry.getEntry());
            }
        }
        return ditContentRuleList;
    }

    @Override
    public List<Entry> loadDitStructureRules(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> ditStructureRuleList = new ArrayList<Entry>();
        if (schemas == null) {
            return ditStructureRuleList;
        }
        for (Schema schema : schemas) {
            File ditStructureRulesDirectory = new File(this.getSchemaDirectory(schema), "ou=ditstructurerules");
            if (!ditStructureRulesDirectory.exists()) {
                return ditStructureRuleList;
            }
            File[] ditStructureRuleFiles = ditStructureRulesDirectory.listFiles(this.ldifFilter);
            if (ditStructureRuleFiles == null) continue;
            for (File ldifFile : ditStructureRuleFiles) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                ditStructureRuleList.add(entry.getEntry());
            }
        }
        return ditStructureRuleList;
    }

    @Override
    public List<Entry> loadObjectClasses(Schema ... schemas) throws LdapException, IOException {
        ArrayList<Entry> objectClassList = new ArrayList<Entry>();
        if (schemas == null) {
            return objectClassList;
        }
        for (Schema schema : schemas) {
            File objectClassesDirectory = new File(this.getSchemaDirectory(schema), "ou=objectclasses");
            if (!objectClassesDirectory.exists()) {
                return objectClassList;
            }
            File[] objectClassFiles = objectClassesDirectory.listFiles(this.ldifFilter);
            if (objectClassFiles == null) continue;
            for (File ldifFile : objectClassFiles) {
                LdifReader reader = new LdifReader(ldifFile);
                LdifEntry entry = reader.next();
                reader.close();
                objectClassList.add(entry.getEntry());
            }
        }
        return objectClassList;
    }
}

