/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared.transport;

import java.net.InetSocketAddress;
import java.util.List;
import org.apache.directory.server.protocol.shared.transport.AbstractTransport;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpTransport
extends AbstractTransport {
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private List<String> enabledProtocols;
    private List<String> cipherSuite;
    private static final Logger LOG = LoggerFactory.getLogger(TcpTransport.class);

    public TcpTransport() {
    }

    public TcpTransport(int tcpPort) {
        super(null, tcpPort, 3, 50);
        this.acceptor = this.createAcceptor(null, tcpPort, 3, 50);
        LOG.debug("TCP Transport created : <*:{},>", (Object)tcpPort);
    }

    public TcpTransport(int tcpPort, int nbThreads) {
        super(null, tcpPort, nbThreads, 50);
        this.acceptor = this.createAcceptor(null, tcpPort, nbThreads, 50);
        LOG.debug("TCP Transport created : <*:{},>", (Object)tcpPort);
    }

    public TcpTransport(String address, int tcpPort) {
        super(address, tcpPort, 3, 50);
        this.acceptor = this.createAcceptor(address, tcpPort, 3, 50);
        LOG.debug("TCP Transport created : <{}:{}>", (Object)address, (Object)tcpPort);
    }

    public TcpTransport(int tcpPort, int nbThreads, int backLog) {
        super("localhost", tcpPort, nbThreads, backLog);
        this.acceptor = this.createAcceptor(null, tcpPort, nbThreads, backLog);
        LOG.debug("TCP Transport created : <*:{},>", (Object)tcpPort);
    }

    public TcpTransport(String address, int tcpPort, int nbThreads, int backLog) {
        super(address, tcpPort, nbThreads, backLog);
        this.acceptor = this.createAcceptor(address, tcpPort, nbThreads, backLog);
        LOG.debug("TCP Transport created : <{}:{},>", (Object)address, (Object)tcpPort);
    }

    @Override
    public void init() {
        this.acceptor = this.createAcceptor(this.getAddress(), this.getPort(), this.getNbThreads(), this.getBackLog());
    }

    private IoAcceptor createAcceptor(String address, int port, int nbThreads, int backLog) {
        NioSocketAcceptor acceptor = new NioSocketAcceptor(nbThreads);
        acceptor.setReuseAddress(true);
        acceptor.setBacklog(backLog);
        InetSocketAddress socketAddress = null;
        socketAddress = address == null ? new InetSocketAddress(port) : new InetSocketAddress(address, port);
        acceptor.setDefaultLocalAddress(socketAddress);
        return acceptor;
    }

    @Override
    public SocketAcceptor getAcceptor() {
        if (this.acceptor != null && this.acceptor.isDisposed()) {
            this.acceptor = this.createAcceptor(this.getAddress(), this.getPort(), this.getNbThreads(), this.getBackLog());
        }
        return this.acceptor == null ? null : (SocketAcceptor)this.acceptor;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public List<String> getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(List<String> enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public List<String> getCipherSuite() {
        return this.cipherSuite;
    }

    public void setEnabledCiphers(List<String> cipherSuite) {
        this.cipherSuite = cipherSuite;
    }

    @Override
    public String toString() {
        return "TcpTransport" + super.toString();
    }
}

