/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyErrorEnum;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyDecorator;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.password.PasswordUtil;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.util.DateUtils;
import org.apache.directory.api.util.StringConstants;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.authn.ppolicy.CheckQualityEnum;
import org.apache.directory.server.core.api.authn.ppolicy.PasswordPolicyConfiguration;
import org.apache.directory.server.core.api.authn.ppolicy.PasswordPolicyException;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.GetRootDseOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.authn.AnonymousAuthenticator;
import org.apache.directory.server.core.authn.Authenticator;
import org.apache.directory.server.core.authn.PasswordHistory;
import org.apache.directory.server.core.authn.SimpleAuthenticator;
import org.apache.directory.server.core.authn.StrongAuthenticator;
import org.apache.directory.server.core.authn.ppolicy.PpolicyConfigContainer;
import org.apache.directory.server.core.shared.DefaultCoreSession;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationInterceptor.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private Set<Authenticator> authenticators = new HashSet<Authenticator>();
    private final Map<AuthenticationLevel, Collection<Authenticator>> authenticatorsMapByType = new HashMap<AuthenticationLevel, Collection<Authenticator>>();
    private CoreSession adminSession;
    private Set<String> pwdResetSet = new HashSet<String>();
    private AttributeType AT_PWD_RESET;
    private AttributeType AT_PWD_CHANGED_TIME;
    private AttributeType AT_PWD_HISTORY;
    private AttributeType AT_PWD_FAILURE_TIME;
    private AttributeType AT_PWD_ACCOUNT_LOCKED_TIME;
    private AttributeType AT_PWD_LAST_SUCCESS;
    private AttributeType AT_PWD_GRACE_USE_TIME;
    private AttributeType AT_CREATE_TIMESTAMP;
    private PpolicyConfigContainer pwdPolicyContainer;
    private AttributeType pwdPolicySubentryAT;

    public AuthenticationInterceptor() {
        super(InterceptorEnum.AUTHENTICATION_INTERCEPTOR);
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        this.adminSession = directoryService.getAdminSession();
        this.pwdPolicySubentryAT = this.schemaManager.lookupAttributeTypeRegistry("pwdPolicySubentry");
        if (this.authenticators == null || this.authenticators.size() == 0) {
            this.setDefaultAuthenticators();
        }
        for (Authenticator authenticator : this.authenticators) {
            this.register(authenticator, directoryService);
        }
        this.loadPwdPolicyStateAttributeTypes();
    }

    private void setDefaultAuthenticators() {
        if (this.authenticators == null) {
            this.authenticators = new HashSet<Authenticator>();
        }
        this.authenticators.clear();
        this.authenticators.add(new AnonymousAuthenticator(Dn.ROOT_DSE));
        this.authenticators.add(new SimpleAuthenticator(Dn.ROOT_DSE));
        this.authenticators.add(new StrongAuthenticator(Dn.ROOT_DSE));
    }

    public Set<Authenticator> getAuthenticators() {
        return this.authenticators;
    }

    public void setAuthenticators(Set<Authenticator> authenticators) {
        if (authenticators == null) {
            this.authenticators.clear();
        } else {
            this.authenticators = authenticators;
        }
    }

    public void setAuthenticators(Authenticator[] authenticators) {
        if (authenticators == null) {
            throw new IllegalArgumentException("The given authenticators set is null");
        }
        this.authenticators.clear();
        this.authenticatorsMapByType.clear();
        for (Authenticator authenticator : authenticators) {
            try {
                this.register(authenticator, this.directoryService);
            }
            catch (LdapException le) {
                LOG.error("Cannot register authenticator {}", (Object)authenticator);
            }
        }
    }

    @Override
    public void destroy() {
        this.authenticatorsMapByType.clear();
        HashSet<Authenticator> copy = new HashSet<Authenticator>(this.authenticators);
        this.authenticators = new HashSet<Authenticator>();
        for (Authenticator authenticator : copy) {
            authenticator.destroy();
        }
    }

    private void register(Authenticator authenticator, DirectoryService directoryService) throws LdapException {
        authenticator.init(directoryService);
        this.authenticators.add(authenticator);
        Collection<Authenticator> authenticatorList = this.getAuthenticators(authenticator.getAuthenticatorType());
        if (authenticatorList == null) {
            authenticatorList = new ArrayList<Authenticator>();
            this.authenticatorsMapByType.put(authenticator.getAuthenticatorType(), authenticatorList);
        }
        if (!authenticatorList.contains(authenticator)) {
            authenticatorList.add(authenticator);
        }
    }

    private Collection<Authenticator> getAuthenticators(AuthenticationLevel type) {
        Collection<Authenticator> result = this.authenticatorsMapByType.get((Object)type);
        if (result != null && result.size() > 0) {
            return result;
        }
        return null;
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        Attribute userPasswordAttribute;
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", (Object)addContext);
        }
        this.checkAuthenticated(addContext);
        Entry entry = addContext.getEntry();
        if (!this.directoryService.isPwdPolicyEnabled() || addContext.isReplEvent()) {
            this.next(addContext);
            return;
        }
        PasswordPolicyConfiguration policyConfig = this.getPwdPolicy(entry);
        boolean isPPolicyReqCtrlPresent = addContext.hasRequestControl("1.3.6.1.4.1.42.2.27.8.5.1");
        this.checkPwdReset(addContext);
        String passwordAttribute = "userPassword";
        if (isPPolicyReqCtrlPresent) {
            passwordAttribute = policyConfig.getPwdAttribute();
        }
        if ((userPasswordAttribute = entry.get(passwordAttribute)) != null) {
            BinaryValue userPassword = (BinaryValue)userPasswordAttribute.get();
            try {
                this.check(addContext, entry, userPassword.getValue(), policyConfig);
            }
            catch (PasswordPolicyException e) {
                if (isPPolicyReqCtrlPresent) {
                    PasswordPolicyDecorator responseControl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
                    responseControl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.get(e.getErrorCode()));
                    addContext.addResponseControl(responseControl);
                }
                throw new LdapOperationException(ResultCodeEnum.CONSTRAINT_VIOLATION, e.getMessage(), e);
            }
            String pwdChangedTime = DateUtils.getGeneralizedTime();
            if (!(policyConfig.getPwdMinAge() <= 0 && policyConfig.getPwdMaxAge() <= 0 || addContext.getSession().isAnAdministrator() && entry.get(this.AT_PWD_CHANGED_TIME) != null)) {
                DefaultAttribute pwdChangedTimeAt = new DefaultAttribute(this.AT_PWD_CHANGED_TIME);
                pwdChangedTimeAt.add(pwdChangedTime);
                entry.add(pwdChangedTimeAt);
            }
            if (policyConfig.isPwdMustChange() && addContext.getSession().isAnAdministrator()) {
                DefaultAttribute pwdResetAt = new DefaultAttribute(this.AT_PWD_RESET);
                pwdResetAt.add("TRUE");
                entry.add(pwdResetAt);
            }
            if (policyConfig.getPwdInHistory() > 0) {
                DefaultAttribute pwdHistoryAt = new DefaultAttribute(this.AT_PWD_HISTORY);
                byte[] pwdHistoryVal = new PasswordHistory(pwdChangedTime, userPassword.getValue()).getHistoryValue();
                pwdHistoryAt.add(new byte[][]{pwdHistoryVal});
                entry.add(pwdHistoryAt);
            }
        }
        this.next(addContext);
    }

    private Authenticator selectAuthenticator(Dn bindDn, AuthenticationLevel level) throws LdapUnwillingToPerformException, LdapAuthenticationException {
        Iterator<Authenticator> i$;
        Authenticator selectedAuthenticator = null;
        Collection<Authenticator> authenticators = this.authenticatorsMapByType.get((Object)level);
        if (authenticators == null || authenticators.size() == 0) {
            throw new LdapAuthenticationException("Cannot Bind for Dn " + bindDn.getName() + ", no authenticator for the requested level " + (Object)((Object)level));
        }
        if (authenticators.size() == 1 && (i$ = authenticators.iterator()).hasNext()) {
            Authenticator authenticator = i$.next();
            if (authenticator.isValid(bindDn)) {
                return authenticator;
            }
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, "Cannot Bind for Dn " + bindDn.getName() + ", its not a descendant of the authenticator base DN '" + authenticator.getBaseDn() + "'");
        }
        Dn innerDn = Dn.ROOT_DSE;
        for (Authenticator authenticator : authenticators) {
            if (!authenticator.isValid(bindDn) || !innerDn.isAncestorOf(authenticator.getBaseDn())) continue;
            innerDn = authenticator.getBaseDn();
            selectedAuthenticator = authenticator;
        }
        return selectedAuthenticator;
    }

    @Override
    public void bind(BindOperationContext bindContext) throws LdapException {
        AuthenticationLevel level;
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", (Object)bindContext);
        }
        CoreSession session = bindContext.getSession();
        Dn bindDn = bindContext.getDn();
        if (session != null && session.getEffectivePrincipal() != null && !session.isAnonymous() && !session.isAdministrator()) {
            bindContext.setCredentials(null);
        }
        if ((level = bindContext.getAuthenticationLevel()) == AuthenticationLevel.UNAUTHENT) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, "Cannot Bind for Dn " + bindDn.getName());
        }
        PasswordPolicyException ppe = null;
        boolean isPPolicyReqCtrlPresent = bindContext.hasRequestControl("1.3.6.1.4.1.42.2.27.8.5.1");
        PasswordPolicyDecorator pwdRespCtrl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
        boolean authenticated = false;
        Authenticator authenticator = this.selectAuthenticator(bindDn, level);
        try {
            LdapPrincipal principal = authenticator.authenticate(bindContext);
            if (principal != null) {
                LdapPrincipal clonedPrincipal = (LdapPrincipal)principal.clone();
                bindContext.setCredentials(null);
                clonedPrincipal.setUserPassword(new byte[][]{StringConstants.EMPTY_BYTES});
                DefaultCoreSession newSession = new DefaultCoreSession(clonedPrincipal, this.directoryService);
                bindContext.setSession(newSession);
                authenticated = true;
            }
        }
        catch (PasswordPolicyException e) {
            ppe = e;
        }
        catch (LdapAuthenticationException e) {
            LOG.info("Authenticator {} failed to authenticate: {}", (Object)authenticator, (Object)bindContext);
        }
        catch (Exception e) {
            LOG.info("Unexpected failure for Authenticator {} : {}", (Object)authenticator, (Object)bindContext);
        }
        if (ppe != null) {
            if (isPPolicyReqCtrlPresent) {
                pwdRespCtrl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.get(ppe.getErrorCode()));
                bindContext.addResponseControl(pwdRespCtrl);
            }
            throw ppe;
        }
        Entry userEntry = bindContext.getEntry();
        PasswordPolicyConfiguration policyConfig = this.getPwdPolicy(userEntry);
        if (policyConfig != null) {
            LookupOperationContext lookupContext = new LookupOperationContext(this.adminSession, bindDn, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
            userEntry = this.directoryService.getPartitionNexus().lookup(lookupContext);
        }
        if (authenticated && userEntry == null && this.directoryService.isAllowAnonymousAccess()) {
            return;
        }
        if (!authenticated) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Cannot bind to the server ");
            }
            if (policyConfig != null && userEntry != null) {
                Attribute pwdFailTimeAt = userEntry.get(this.AT_PWD_FAILURE_TIME);
                if (pwdFailTimeAt == null) {
                    pwdFailTimeAt = new DefaultAttribute(this.AT_PWD_FAILURE_TIME);
                } else {
                    this.purgeFailureTimes(policyConfig, pwdFailTimeAt);
                }
                String failureTime = DateUtils.getGeneralizedTime();
                pwdFailTimeAt.add(failureTime);
                DefaultModification pwdFailTimeMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, pwdFailTimeAt);
                ArrayList<Modification> mods = new ArrayList<Modification>();
                mods.add(pwdFailTimeMod);
                int numFailures = pwdFailTimeAt.size();
                if (policyConfig.isPwdLockout() && numFailures >= policyConfig.getPwdMaxFailure()) {
                    if (!userEntry.getDn().equals(new Dn(this.schemaManager, "uid=admin,ou=system"))) {
                        DefaultAttribute pwdAccountLockedTimeAt = new DefaultAttribute(this.AT_PWD_ACCOUNT_LOCKED_TIME);
                        if (policyConfig.getPwdLockoutDuration() == 0) {
                            pwdAccountLockedTimeAt.add("000001010000Z");
                        } else {
                            pwdAccountLockedTimeAt.add(failureTime);
                        }
                        DefaultModification pwdAccountLockedMod = new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, pwdAccountLockedTimeAt);
                        mods.add(pwdAccountLockedMod);
                        pwdRespCtrl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.ACCOUNT_LOCKED);
                    }
                } else if (policyConfig.getPwdMinDelay() > 0) {
                    int maxDelay;
                    int numDelay = numFailures * policyConfig.getPwdMinDelay();
                    if (numDelay > (maxDelay = policyConfig.getPwdMaxDelay())) {
                        numDelay = maxDelay;
                    }
                    try {
                        Thread.sleep((long)numDelay * 1000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Interrupted while delaying to send the failed authentication response for the user {}", (Object)bindDn, (Object)e);
                    }
                }
                if (!mods.isEmpty()) {
                    String csnVal = this.directoryService.getCSN().toString();
                    DefaultModification csnMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, ENTRY_CSN_AT, csnVal);
                    mods.add(csnMod);
                    ModifyOperationContext bindModCtx = new ModifyOperationContext(this.adminSession);
                    bindModCtx.setDn(bindDn);
                    bindModCtx.setEntry(userEntry);
                    bindModCtx.setModItems(mods);
                    bindModCtx.setPushToEvtInterceptor(true);
                    this.directoryService.getPartitionNexus().modify(bindModCtx);
                }
            }
            String upDn = bindDn == null ? "" : bindDn.getName();
            throw new LdapAuthenticationException(I18n.err(I18n.ERR_229, upDn));
        }
        if (policyConfig != null) {
            boolean expired;
            Attribute pwdChangeTimeAttr;
            Attribute pwdAccLockedTimeAt;
            Attribute pwdFailTimeAt;
            ArrayList<Modification> mods = new ArrayList<Modification>();
            if (policyConfig.getPwdMaxIdle() > 0) {
                DefaultAttribute pwdLastSuccesTimeAt = new DefaultAttribute(this.AT_PWD_LAST_SUCCESS);
                pwdLastSuccesTimeAt.add(DateUtils.getGeneralizedTime());
                DefaultModification pwdLastSuccesTimeMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, pwdLastSuccesTimeAt);
                mods.add(pwdLastSuccesTimeMod);
            }
            if ((pwdFailTimeAt = userEntry.get(this.AT_PWD_FAILURE_TIME)) != null) {
                DefaultModification pwdFailTimeMod = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, pwdFailTimeAt);
                mods.add(pwdFailTimeMod);
            }
            if ((pwdAccLockedTimeAt = userEntry.get(this.AT_PWD_ACCOUNT_LOCKED_TIME)) != null) {
                DefaultModification pwdAccLockedTimeMod = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, pwdAccLockedTimeAt);
                mods.add(pwdAccLockedTimeMod);
            }
            if (policyConfig.getPwdMaxAge() > 0 && policyConfig.getPwdGraceAuthNLimit() > 0 && (pwdChangeTimeAttr = userEntry.get(this.AT_PWD_CHANGED_TIME)) != null && (expired = PasswordUtil.isPwdExpired(pwdChangeTimeAttr.getString(), policyConfig.getPwdMaxAge()))) {
                Attribute pwdGraceUseAttr = userEntry.get(this.AT_PWD_GRACE_USE_TIME);
                int numGraceAuth = 0;
                if (pwdGraceUseAttr != null) {
                    numGraceAuth = policyConfig.getPwdGraceAuthNLimit() - (pwdGraceUseAttr.size() + 1);
                } else {
                    pwdGraceUseAttr = new DefaultAttribute(this.AT_PWD_GRACE_USE_TIME);
                    numGraceAuth = policyConfig.getPwdGraceAuthNLimit() - 1;
                }
                pwdRespCtrl.getResponse().setGraceAuthNRemaining(numGraceAuth);
                pwdGraceUseAttr.add(DateUtils.getGeneralizedTime());
                DefaultModification pwdGraceUseMod = new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, pwdGraceUseAttr);
                mods.add(pwdGraceUseMod);
            }
            if (!mods.isEmpty()) {
                String csnVal = this.directoryService.getCSN().toString();
                DefaultModification csnMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, ENTRY_CSN_AT, csnVal);
                mods.add(csnMod);
                ModifyOperationContext bindModCtx = new ModifyOperationContext(this.adminSession);
                bindModCtx.setDn(bindDn);
                bindModCtx.setEntry(userEntry);
                bindModCtx.setModItems(mods);
                bindModCtx.setPushToEvtInterceptor(true);
                this.directoryService.getPartitionNexus().modify(bindModCtx);
            }
            if (isPPolicyReqCtrlPresent) {
                int expiryWarnTime = this.getPwdTimeBeforeExpiry(userEntry, policyConfig);
                if (expiryWarnTime > 0) {
                    pwdRespCtrl.getResponse().setTimeBeforeExpiration(expiryWarnTime);
                }
                if (this.isPwdMustReset(userEntry)) {
                    pwdRespCtrl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.CHANGE_AFTER_RESET);
                    this.pwdResetSet.add(bindDn.getNormName());
                }
                bindContext.addResponseControl(pwdRespCtrl);
            }
        }
    }

    @Override
    public boolean compare(CompareOperationContext compareContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", (Object)compareContext);
        }
        this.checkAuthenticated(compareContext);
        this.checkPwdReset(compareContext);
        boolean result = this.next(compareContext);
        return result;
    }

    @Override
    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", (Object)deleteContext);
        }
        this.checkAuthenticated(deleteContext);
        this.checkPwdReset(deleteContext);
        this.next(deleteContext);
        this.invalidateAuthenticatorCaches(deleteContext.getDn());
    }

    @Override
    public Entry getRootDse(GetRootDseOperationContext getRootDseContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", (Object)getRootDseContext);
        }
        this.checkAuthenticated(getRootDseContext);
        this.checkPwdReset(getRootDseContext);
        return this.next(getRootDseContext);
    }

    @Override
    public boolean hasEntry(HasEntryOperationContext hasEntryContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", (Object)hasEntryContext);
        }
        this.checkAuthenticated(hasEntryContext);
        this.checkPwdReset(hasEntryContext);
        return this.next(hasEntryContext);
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", (Object)lookupContext);
        }
        this.checkAuthenticated(lookupContext);
        this.checkPwdReset(lookupContext);
        return this.next(lookupContext);
    }

    private void invalidateAuthenticatorCaches(Dn principalDn) {
        for (AuthenticationLevel authMech : this.authenticatorsMapByType.keySet()) {
            Collection<Authenticator> authenticators = this.getAuthenticators(authMech);
            for (Authenticator authenticator : authenticators) {
                authenticator.invalidateCache(principalDn);
            }
        }
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", (Object)modifyContext);
        }
        this.checkAuthenticated(modifyContext);
        if (!this.directoryService.isPwdPolicyEnabled() || modifyContext.isReplEvent()) {
            this.next(modifyContext);
            List<Modification> modifications = modifyContext.getModItems();
            for (Modification modification : modifications) {
                if (!USER_PASSWORD_AT.equals(modification.getAttribute().getAttributeType())) continue;
                this.invalidateAuthenticatorCaches(modifyContext.getDn());
                break;
            }
            return;
        }
        PasswordPolicyConfiguration policyConfig = this.getPwdPolicy(modifyContext.getEntry());
        boolean isPPolicyReqCtrlPresent = modifyContext.hasRequestControl("1.3.6.1.4.1.42.2.27.8.5.1");
        Dn userDn = modifyContext.getSession().getAuthenticatedPrincipal().getDn();
        PwdModDetailsHolder pwdModDetails = null;
        pwdModDetails = this.getPwdModDetails(modifyContext, policyConfig);
        if (pwdModDetails.isPwdModPresent()) {
            Attribute pwdGraceUseTimeAt;
            Attribute pwdFailureTimeAt;
            if (this.pwdResetSet.contains(userDn.getNormName()) && !pwdModDetails.isDelete() && pwdModDetails.isOtherModExists()) {
                if (isPPolicyReqCtrlPresent) {
                    PasswordPolicyDecorator responseControl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
                    responseControl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.CHANGE_AFTER_RESET);
                    modifyContext.addResponseControl(responseControl);
                }
                throw new LdapNoPermissionException("Password should be reset before making any changes to this entry");
            }
            if (policyConfig.isPwdSafeModify() && !pwdModDetails.isDelete() && pwdModDetails.isAddOrReplace() && !pwdModDetails.isDelete()) {
                String msg = "trying to update password attribute without the supplying the old password";
                LOG.debug(msg);
                if (isPPolicyReqCtrlPresent) {
                    PasswordPolicyDecorator responseControl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
                    responseControl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.MUST_SUPPLY_OLD_PASSWORD);
                    modifyContext.addResponseControl(responseControl);
                }
                throw new LdapNoPermissionException(msg);
            }
            if (!policyConfig.isPwdAllowUserChange() && !modifyContext.getSession().isAnAdministrator()) {
                if (isPPolicyReqCtrlPresent) {
                    PasswordPolicyDecorator responseControl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
                    responseControl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.PASSWORD_MOD_NOT_ALLOWED);
                    modifyContext.addResponseControl(responseControl);
                }
                throw new LdapNoPermissionException();
            }
            Entry entry = modifyContext.getEntry();
            boolean removeFromPwdResetSet = false;
            ArrayList<Modification> mods = new ArrayList<Modification>();
            if (pwdModDetails.isAddOrReplace()) {
                if (this.isPwdTooYoung(modifyContext, entry, policyConfig)) {
                    if (isPPolicyReqCtrlPresent) {
                        PasswordPolicyDecorator responseControl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
                        responseControl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.PASSWORD_TOO_YOUNG);
                        modifyContext.addResponseControl(responseControl);
                    }
                    throw new LdapOperationException(ResultCodeEnum.CONSTRAINT_VIOLATION, "password is too young to update");
                }
                byte[] newPassword = pwdModDetails.getNewPwd();
                try {
                    this.check(modifyContext, entry, newPassword, policyConfig);
                }
                catch (PasswordPolicyException e) {
                    if (isPPolicyReqCtrlPresent) {
                        PasswordPolicyDecorator responseControl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
                        responseControl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.get(e.getErrorCode()));
                        modifyContext.addResponseControl(responseControl);
                    }
                    throw new LdapOperationException(ResultCodeEnum.CONSTRAINT_VIOLATION, e.getMessage(), e);
                }
                int histSize = policyConfig.getPwdInHistory();
                DefaultModification pwdRemHistMod = null;
                DefaultModification pwdAddHistMod = null;
                String pwdChangedTime = DateUtils.getGeneralizedTime();
                if (histSize > 0) {
                    Attribute pwdHistoryAt = entry.get(this.AT_PWD_HISTORY);
                    if (pwdHistoryAt == null) {
                        pwdHistoryAt = new DefaultAttribute(this.AT_PWD_HISTORY);
                    }
                    ArrayList<PasswordHistory> pwdHistLst = new ArrayList<PasswordHistory>();
                    for (Value value : pwdHistoryAt) {
                        PasswordHistory pwdh = new PasswordHistory(Strings.utf8ToString(value.getBytes()));
                        boolean matched = Arrays.equals(newPassword, pwdh.getPassword());
                        if (matched) {
                            if (isPPolicyReqCtrlPresent) {
                                PasswordPolicyDecorator responseControl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
                                responseControl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.PASSWORD_IN_HISTORY);
                                modifyContext.addResponseControl(responseControl);
                            }
                            throw new LdapOperationException(ResultCodeEnum.CONSTRAINT_VIOLATION, "invalid reuse of password present in password history");
                        }
                        pwdHistLst.add(pwdh);
                    }
                    if (pwdHistLst.size() >= histSize) {
                        Collections.sort(pwdHistLst);
                        PasswordHistory remPwdHist = (PasswordHistory)pwdHistLst.toArray()[histSize - 1];
                        DefaultAttribute tempAt = new DefaultAttribute(this.AT_PWD_HISTORY);
                        tempAt.add(new byte[][]{remPwdHist.getHistoryValue()});
                        pwdRemHistMod = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, tempAt);
                    }
                    PasswordHistory newPwdHist = new PasswordHistory(pwdChangedTime, newPassword);
                    pwdHistoryAt.add(new byte[][]{newPwdHist.getHistoryValue()});
                    pwdAddHistMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, pwdHistoryAt);
                }
                this.next(modifyContext);
                this.invalidateAuthenticatorCaches(modifyContext.getDn());
                LookupOperationContext lookupContext = new LookupOperationContext(this.adminSession, modifyContext.getDn(), SchemaConstants.ALL_ATTRIBUTES_ARRAY);
                entry = this.directoryService.getPartitionNexus().lookup(lookupContext);
                if (policyConfig.getPwdMinAge() > 0 || policyConfig.getPwdMaxAge() > 0) {
                    DefaultAttribute pwdChangedTimeAt = new DefaultAttribute(this.AT_PWD_CHANGED_TIME);
                    pwdChangedTimeAt.add(pwdChangedTime);
                    DefaultModification pwdChangedTimeMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, pwdChangedTimeAt);
                    mods.add(pwdChangedTimeMod);
                }
                if (pwdAddHistMod != null) {
                    mods.add(pwdAddHistMod);
                }
                if (pwdRemHistMod != null) {
                    mods.add(pwdRemHistMod);
                }
                if (policyConfig.isPwdMustChange()) {
                    DefaultAttribute pwdMustChangeAt = new DefaultAttribute(this.AT_PWD_RESET);
                    DefaultModification pwdMustChangeMod = null;
                    if (modifyContext.getSession().isAnAdministrator()) {
                        pwdMustChangeAt.add("TRUE");
                        pwdMustChangeMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, pwdMustChangeAt);
                    } else {
                        pwdMustChangeMod = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, pwdMustChangeAt);
                        removeFromPwdResetSet = true;
                    }
                    mods.add(pwdMustChangeMod);
                }
            }
            if ((pwdFailureTimeAt = entry.get(this.AT_PWD_FAILURE_TIME)) != null) {
                mods.add(new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, pwdFailureTimeAt));
            }
            if ((pwdGraceUseTimeAt = entry.get(this.AT_PWD_GRACE_USE_TIME)) != null) {
                mods.add(new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, pwdGraceUseTimeAt));
            }
            if (pwdModDetails.isDelete()) {
                Attribute pwdAccountLockedTimeAt;
                Attribute pwdMustChangeAt;
                Attribute pwdChangedTimeAt;
                Attribute pwdHistory = entry.get(this.AT_PWD_HISTORY);
                if (pwdHistory != null) {
                    mods.add(new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, pwdHistory));
                }
                if ((pwdChangedTimeAt = entry.get(this.AT_PWD_CHANGED_TIME)) != null) {
                    mods.add(new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, pwdChangedTimeAt));
                }
                if ((pwdMustChangeAt = entry.get(this.AT_PWD_RESET)) != null) {
                    mods.add(new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, pwdMustChangeAt));
                }
                if ((pwdAccountLockedTimeAt = entry.get(this.AT_PWD_ACCOUNT_LOCKED_TIME)) != null) {
                    mods.add(new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, pwdAccountLockedTimeAt));
                }
            }
            String csnVal = this.directoryService.getCSN().toString();
            DefaultModification csnMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, ENTRY_CSN_AT, csnVal);
            mods.add(csnMod);
            ModifyOperationContext internalModifyCtx = new ModifyOperationContext(this.adminSession);
            internalModifyCtx.setPushToEvtInterceptor(true);
            internalModifyCtx.setDn(modifyContext.getDn());
            internalModifyCtx.setEntry(entry);
            internalModifyCtx.setModItems(mods);
            this.directoryService.getPartitionNexus().modify(internalModifyCtx);
            if (removeFromPwdResetSet || pwdModDetails.isDelete()) {
                this.pwdResetSet.remove(userDn.getNormName());
            }
        } else {
            this.next(modifyContext);
        }
    }

    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", (Object)moveContext);
        }
        this.checkAuthenticated(moveContext);
        this.checkPwdReset(moveContext);
        this.next(moveContext);
        this.invalidateAuthenticatorCaches(moveContext.getDn());
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", (Object)moveAndRenameContext);
        }
        this.checkAuthenticated(moveAndRenameContext);
        this.checkPwdReset(moveAndRenameContext);
        this.next(moveAndRenameContext);
        this.invalidateAuthenticatorCaches(moveAndRenameContext.getDn());
    }

    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", (Object)renameContext);
        }
        this.checkAuthenticated(renameContext);
        this.checkPwdReset(renameContext);
        this.next(renameContext);
        this.invalidateAuthenticatorCaches(renameContext.getDn());
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        if (IS_DEBUG) {
            LOG.debug("Operation Context: {}", (Object)searchContext);
        }
        this.checkAuthenticated(searchContext);
        this.checkPwdReset(searchContext);
        return this.next(searchContext);
    }

    @Override
    public void unbind(UnbindOperationContext unbindContext) throws LdapException {
        this.next(unbindContext);
        if (!this.directoryService.isPwdPolicyEnabled()) {
            this.pwdResetSet.remove(unbindContext.getDn().getNormName());
        }
    }

    private void checkAuthenticated(OperationContext operation) throws LdapException {
        if (operation.getSession().isAnonymous() && !this.directoryService.isAllowAnonymousAccess() && !operation.getDn().isEmpty()) {
            String msg = I18n.err(I18n.ERR_5, operation.getName());
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
    }

    public void loadPwdPolicyStateAttributeTypes() throws LdapException {
        this.AT_PWD_RESET = this.schemaManager.lookupAttributeTypeRegistry("pwdReset");
        PWD_POLICY_STATE_ATTRIBUTE_TYPES.add(this.AT_PWD_RESET);
        this.AT_PWD_CHANGED_TIME = this.schemaManager.lookupAttributeTypeRegistry("pwdChangedTime");
        PWD_POLICY_STATE_ATTRIBUTE_TYPES.add(this.AT_PWD_CHANGED_TIME);
        this.AT_PWD_HISTORY = this.schemaManager.lookupAttributeTypeRegistry("pwdHistory");
        PWD_POLICY_STATE_ATTRIBUTE_TYPES.add(this.AT_PWD_HISTORY);
        this.AT_PWD_FAILURE_TIME = this.schemaManager.lookupAttributeTypeRegistry("pwdFailureTime");
        PWD_POLICY_STATE_ATTRIBUTE_TYPES.add(this.AT_PWD_FAILURE_TIME);
        this.AT_PWD_ACCOUNT_LOCKED_TIME = this.schemaManager.lookupAttributeTypeRegistry("pwdAccountLockedTime");
        PWD_POLICY_STATE_ATTRIBUTE_TYPES.add(this.AT_PWD_ACCOUNT_LOCKED_TIME);
        this.AT_PWD_LAST_SUCCESS = this.schemaManager.lookupAttributeTypeRegistry("pwdLastSuccess");
        PWD_POLICY_STATE_ATTRIBUTE_TYPES.add(this.AT_PWD_LAST_SUCCESS);
        this.AT_PWD_GRACE_USE_TIME = this.schemaManager.lookupAttributeTypeRegistry("pwdGraceUseTime");
        PWD_POLICY_STATE_ATTRIBUTE_TYPES.add(this.AT_PWD_GRACE_USE_TIME);
        PWD_POLICY_STATE_ATTRIBUTE_TYPES.add(this.schemaManager.lookupAttributeTypeRegistry("pwdPolicySubentry"));
    }

    private void check(OperationContext operationContext, Entry entry, byte[] password, PasswordPolicyConfiguration policyConfig) throws LdapException {
        if (operationContext.getSession().isAnAdministrator()) {
            return;
        }
        CheckQualityEnum qualityVal = policyConfig.getPwdCheckQuality();
        if (qualityVal == CheckQualityEnum.NO_CHECK) {
            return;
        }
        LdapSecurityConstants secConst = PasswordUtil.findAlgorithm(password);
        if (secConst != null) {
            if (qualityVal == CheckQualityEnum.CHECK_ACCEPT) {
                return;
            }
            throw new PasswordPolicyException("cannot verify the quality of the non-cleartext passwords", PasswordPolicyErrorEnum.INSUFFICIENT_PASSWORD_QUALITY.getValue());
        }
        String strPassword = Strings.utf8ToString(password);
        this.validatePasswordLength(strPassword, policyConfig);
        policyConfig.getPwdValidator().validate(strPassword, entry);
    }

    private void validatePasswordLength(String password, PasswordPolicyConfiguration policyConfig) throws PasswordPolicyException {
        int maxLen = policyConfig.getPwdMaxLength();
        int minLen = policyConfig.getPwdMinLength();
        int pwdLen = password.length();
        if (maxLen > 0 && pwdLen > maxLen) {
            throw new PasswordPolicyException("Password should not have more than " + maxLen + " characters", PasswordPolicyErrorEnum.INSUFFICIENT_PASSWORD_QUALITY.getValue());
        }
        if (minLen > 0 && pwdLen < minLen) {
            throw new PasswordPolicyException("Password should have a minimum of " + minLen + " characters", PasswordPolicyErrorEnum.PASSWORD_TOO_SHORT.getValue());
        }
    }

    private AttributeType getCreateTimestampAttributeType() throws LdapException {
        if (this.AT_CREATE_TIMESTAMP == null) {
            this.AT_CREATE_TIMESTAMP = this.schemaManager.lookupAttributeTypeRegistry("createTimestamp");
        }
        return this.AT_CREATE_TIMESTAMP;
    }

    private int getPwdTimeBeforeExpiry(Entry userEntry, PasswordPolicyConfiguration policyConfig) throws LdapException {
        if (policyConfig.getPwdMaxAge() == 0) {
            return 0;
        }
        int warningAge = policyConfig.getPwdExpireWarning();
        if (warningAge <= 0) {
            return 0;
        }
        Attribute pwdChangedTimeAt = userEntry.get(this.AT_PWD_CHANGED_TIME);
        if (pwdChangedTimeAt == null) {
            pwdChangedTimeAt = userEntry.get(this.getCreateTimestampAttributeType());
        }
        long changedTime = DateUtils.getDate(pwdChangedTimeAt.getString()).getTime();
        long currentTime = DateUtils.getDate(DateUtils.getGeneralizedTime()).getTime();
        long pwdAge = (currentTime - changedTime) / 1000L;
        if (pwdAge > (long)policyConfig.getPwdMaxAge()) {
            return 0;
        }
        warningAge = policyConfig.getPwdMaxAge() - warningAge;
        if (pwdAge >= (long)warningAge) {
            long timeBeforeExpiration = (long)policyConfig.getPwdMaxAge() - pwdAge;
            if (timeBeforeExpiration > Integer.MAX_VALUE) {
                timeBeforeExpiration = Integer.MAX_VALUE;
            }
            return (int)timeBeforeExpiration;
        }
        return 0;
    }

    private boolean isPwdTooYoung(OperationContext operationContext, Entry userEntry, PasswordPolicyConfiguration policyConfig) throws LdapException {
        if (operationContext.getSession().isAnAdministrator()) {
            return false;
        }
        if (policyConfig.getPwdMinAge() == 0) {
            return false;
        }
        if (policyConfig.isPwdMustChange() && this.pwdResetSet.contains(userEntry.getDn().getNormName())) {
            return false;
        }
        Attribute pwdChangedTimeAt = userEntry.get(this.AT_PWD_CHANGED_TIME);
        if (pwdChangedTimeAt != null) {
            long currentTime;
            long changedTime = DateUtils.getDate(pwdChangedTimeAt.getString()).getTime();
            if ((changedTime += (long)policyConfig.getPwdMinAge() * 1000L) > (currentTime = DateUtils.getDate(DateUtils.getGeneralizedTime()).getTime())) {
                return true;
            }
        }
        return false;
    }

    private boolean isPwdMustReset(Entry userEntry) throws LdapException {
        boolean mustChange = false;
        Attribute pwdResetAt = userEntry.get(this.AT_PWD_RESET);
        if (pwdResetAt != null) {
            mustChange = Boolean.parseBoolean(pwdResetAt.getString());
        }
        return mustChange;
    }

    private PwdModDetailsHolder getPwdModDetails(ModifyOperationContext modifyContext, PasswordPolicyConfiguration policyConfig) throws LdapException {
        PwdModDetailsHolder pwdModDetails = new PwdModDetailsHolder();
        List<Modification> mods = modifyContext.getModItems();
        for (Modification m : mods) {
            Attribute at = m.getAttribute();
            if (at.getUpId().equalsIgnoreCase(policyConfig.getPwdAttribute())) {
                pwdModDetails.setPwdModPresent(true);
                ModificationOperation op = m.getOperation();
                if (op == ModificationOperation.REMOVE_ATTRIBUTE) {
                    pwdModDetails.setDelete(true);
                    continue;
                }
                if (op != ModificationOperation.REPLACE_ATTRIBUTE && op != ModificationOperation.ADD_ATTRIBUTE) continue;
                pwdModDetails.setAddOrReplace(true);
                pwdModDetails.setNewPwd(at.getBytes());
                continue;
            }
            pwdModDetails.setOtherModExists(true);
        }
        return pwdModDetails;
    }

    private void checkPwdReset(OperationContext opContext) throws LdapException {
        CoreSession session;
        Dn userDn;
        if (!this.directoryService.isPwdPolicyEnabled() && this.pwdResetSet.contains((userDn = (session = opContext.getSession()).getAuthenticatedPrincipal().getDn()).getNormName())) {
            boolean isPPolicyReqCtrlPresent = opContext.hasRequestControl("1.3.6.1.4.1.42.2.27.8.5.1");
            if (isPPolicyReqCtrlPresent) {
                PasswordPolicyDecorator pwdRespCtrl = new PasswordPolicyDecorator(this.directoryService.getLdapCodecService(), true);
                pwdRespCtrl.getResponse().setPasswordPolicyError(PasswordPolicyErrorEnum.CHANGE_AFTER_RESET);
                opContext.addResponseControl(pwdRespCtrl);
            }
            throw new LdapNoPermissionException("password needs to be reset before performing this operation");
        }
    }

    public PasswordPolicyConfiguration getPwdPolicy(Entry userEntry) throws LdapException {
        Attribute pwdPolicySubentry;
        if (this.pwdPolicyContainer == null) {
            return null;
        }
        if (userEntry == null) {
            return this.pwdPolicyContainer.getDefaultPolicy();
        }
        if (this.pwdPolicyContainer.hasCustomConfigs() && (pwdPolicySubentry = userEntry.get(this.pwdPolicySubentryAT)) != null) {
            Dn configDn = this.dnFactory.create(pwdPolicySubentry.getString());
            PasswordPolicyConfiguration custom = this.pwdPolicyContainer.getPolicyConfig(configDn);
            if (custom != null) {
                return custom;
            }
            LOG.warn("The custom password policy for the user entry {} is not found, returning default policy configuration", (Object)userEntry.getDn());
        }
        return this.pwdPolicyContainer.getDefaultPolicy();
    }

    public void setPwdPolicies(PpolicyConfigContainer policyContainer) {
        this.pwdPolicyContainer = policyContainer;
    }

    public boolean isPwdPolicyEnabled() {
        return this.pwdPolicyContainer != null && (this.pwdPolicyContainer.getDefaultPolicy() != null || this.pwdPolicyContainer.hasCustomConfigs());
    }

    public PpolicyConfigContainer getPwdPolicyContainer() {
        return this.pwdPolicyContainer;
    }

    public void setPwdPolicyContainer(PpolicyConfigContainer pwdPolicyContainer) {
        this.pwdPolicyContainer = pwdPolicyContainer;
    }

    private void purgeFailureTimes(PasswordPolicyConfiguration config, Attribute pwdFailTimeAt) {
        long interval = config.getPwdFailureCountInterval();
        if (interval == 0L) {
            return;
        }
        interval *= 1000L;
        long currentTime = DateUtils.getDate(DateUtils.getGeneralizedTime()).getTime();
        Iterator itr = pwdFailTimeAt.iterator();
        while (itr.hasNext()) {
            Value value = (Value)itr.next();
            String failureTime = value.getString();
            long time = DateUtils.getDate(failureTime).getTime();
            if (currentTime < (time += interval)) continue;
            itr.remove();
        }
    }

    private static class PwdModDetailsHolder {
        private boolean pwdModPresent = false;
        private boolean isDelete = false;
        private boolean isAddOrReplace = false;
        private boolean otherModExists = false;
        private byte[] newPwd;

        private PwdModDetailsHolder() {
        }

        public boolean isPwdModPresent() {
            return this.pwdModPresent;
        }

        public void setPwdModPresent(boolean pwdModPresent) {
            this.pwdModPresent = pwdModPresent;
        }

        public boolean isDelete() {
            return this.isDelete;
        }

        public void setDelete(boolean isDelete) {
            this.isDelete = isDelete;
        }

        public boolean isAddOrReplace() {
            return this.isAddOrReplace;
        }

        public void setAddOrReplace(boolean isAddOrReplace) {
            this.isAddOrReplace = isAddOrReplace;
        }

        public boolean isOtherModExists() {
            return this.otherModExists;
        }

        public void setOtherModExists(boolean otherModExists) {
            this.otherModExists = otherModExists;
        }

        public byte[] getNewPwd() {
            return this.newPwd;
        }

        public void setNewPwd(byte[] newPwd) {
            this.newPwd = newPwd;
        }
    }
}

