/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindRequestImpl;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.StringConstants;
import org.apache.directory.api.util.Strings;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLdapConnection
extends IoHandlerAdapter
implements LdapConnection {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLdapConnection.class);
    protected SchemaManager schemaManager;
    protected AtomicInteger messageId = new AtomicInteger(0);
    protected LdapApiService codec;

    protected AbstractLdapConnection() {
        this(LdapApiServiceFactory.getSingleton());
    }

    protected AbstractLdapConnection(LdapApiService codec) {
        this.codec = codec;
    }

    @Override
    public void bind(Dn name) throws LdapException {
        byte[] credBytes = StringConstants.EMPTY_BYTES;
        BindRequestImpl bindRequest = new BindRequestImpl();
        bindRequest.setDn(name);
        bindRequest.setCredentials(credBytes);
        BindResponse bindResponse = this.bind(bindRequest);
        ResultCodeEnum.processResponse(bindResponse);
    }

    @Override
    public void bind(String name) throws LdapException {
        LOG.debug("Bind request : {}", (Object)name);
        this.bind(new Dn(this.schemaManager, name), null);
    }

    @Override
    public void bind(String name, String credentials) throws LdapException {
        this.bind(new Dn(this.schemaManager, name), credentials);
    }

    @Override
    public void bind(Dn name, String credentials) throws LdapException {
        byte[] credBytes = credentials == null ? StringConstants.EMPTY_BYTES : Strings.getBytesUtf8(credentials);
        BindRequestImpl bindRequest = new BindRequestImpl();
        bindRequest.setDn(name);
        bindRequest.setCredentials(credBytes);
        BindResponse bindResponse = this.bind(bindRequest);
        ResultCodeEnum.processResponse(bindResponse);
    }

    protected BindRequest createBindRequest(String name, byte[] credentials, String saslMechanism, Control ... controls) throws LdapException {
        BindRequestImpl bindRequest = new BindRequestImpl();
        bindRequest.setVersion3(true);
        bindRequest.setName(name);
        if (Strings.isEmpty(saslMechanism)) {
            bindRequest.setSimple(true);
            bindRequest.setCredentials(credentials);
        } else {
            bindRequest.setSimple(false);
            bindRequest.setCredentials(credentials);
            bindRequest.setSaslMechanism(saslMechanism);
        }
        if (controls != null && controls.length != 0) {
            bindRequest.addAllControls(controls);
        }
        return bindRequest;
    }
}

