/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.io;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.directory.server.dhcp.messages.DhcpMessage;
import org.apache.directory.server.dhcp.messages.HardwareAddress;
import org.apache.directory.server.dhcp.options.DhcpOption;
import org.apache.directory.server.dhcp.options.OptionsField;
import org.apache.directory.server.dhcp.options.dhcp.DhcpMessageType;
import org.apache.directory.server.i18n.I18n;

public class DhcpMessageEncoder {
    private static final byte[] VENDOR_MAGIC_COOKIE = new byte[]{99, -126, 83, 99};

    public void encode(ByteBuffer byteBuffer, DhcpMessage message) {
        byteBuffer.put(message.getOp());
        HardwareAddress hardwareAddress = message.getHardwareAddress();
        byteBuffer.put((byte)(null != hardwareAddress ? hardwareAddress.getType() : (short)0));
        byteBuffer.put((byte)(null != hardwareAddress ? hardwareAddress.getLength() : (short)0));
        byteBuffer.put((byte)message.getHopCount());
        byteBuffer.putInt(message.getTransactionId());
        byteBuffer.putShort((short)message.getSeconds());
        byteBuffer.putShort(message.getFlags());
        this.writeAddress(byteBuffer, message.getCurrentClientAddress());
        this.writeAddress(byteBuffer, message.getAssignedClientAddress());
        this.writeAddress(byteBuffer, message.getNextServerAddress());
        this.writeAddress(byteBuffer, message.getRelayAgentAddress());
        this.writeBytes(byteBuffer, null != hardwareAddress ? hardwareAddress.getAddress() : new byte[]{}, 16);
        this.writeString(byteBuffer, message.getServerHostname(), 64);
        this.writeString(byteBuffer, message.getBootFileName(), 128);
        OptionsField options = message.getOptions();
        if (null != message.getMessageType()) {
            options.add(new DhcpMessageType(message.getMessageType()));
        }
        this.encodeOptions(options, byteBuffer);
    }

    private void writeString(ByteBuffer byteBuffer, String string, int len) {
        if (null == string) {
            string = "";
        }
        try {
            byte[] sbytes = string.getBytes("ASCII");
            this.writeBytes(byteBuffer, sbytes, len);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(I18n.err(I18n.ERR_635, new Object[0]), e);
        }
    }

    private void writeAddress(ByteBuffer byteBuffer, InetAddress currentClientAddress) {
        if (null == currentClientAddress) {
            byte[] emptyAddress = new byte[]{0, 0, 0, 0};
            byteBuffer.put(emptyAddress);
        } else {
            byte[] addressBytes = currentClientAddress.getAddress();
            byteBuffer.put(addressBytes);
        }
    }

    private void writeBytes(ByteBuffer byteBuffer, byte[] bytes, int len) {
        if (null == bytes) {
            bytes = new byte[]{};
        }
        byteBuffer.put(bytes, 0, Math.min(len, bytes.length));
        int remain = len - bytes.length;
        while (remain-- > 0) {
            byteBuffer.put((byte)0);
        }
    }

    public void encodeOptions(OptionsField options, ByteBuffer message) {
        message.put(VENDOR_MAGIC_COOKIE);
        Iterator i = options.iterator();
        while (i.hasNext()) {
            DhcpOption option = (DhcpOption)i.next();
            option.writeTo(message);
        }
        message.put((byte)-1);
    }
}

