/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.schema;

import java.text.ParseException;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.DitContentRule;
import org.apache.directory.api.ldap.model.schema.DitStructureRule;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.NameForm;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.parsers.AttributeTypeDescriptionSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.DitContentRuleDescriptionSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.DitStructureRuleDescriptionSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.LdapComparatorDescription;
import org.apache.directory.api.ldap.model.schema.parsers.LdapComparatorDescriptionSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.LdapSyntaxDescriptionSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.MatchingRuleDescriptionSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.MatchingRuleUseDescriptionSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.NameFormDescriptionSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.NormalizerDescription;
import org.apache.directory.api.ldap.model.schema.parsers.NormalizerDescriptionSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.ObjectClassDescriptionSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.SyntaxCheckerDescription;
import org.apache.directory.api.ldap.model.schema.parsers.SyntaxCheckerDescriptionSchemaParser;
import org.apache.directory.server.i18n.I18n;

public class DescriptionParsers {
    private static final LdapComparatorDescription[] EMPTY_COMPARATORS = new LdapComparatorDescription[0];
    private static final NormalizerDescription[] EMPTY_NORMALIZERS = new NormalizerDescription[0];
    private static final SyntaxCheckerDescription[] EMPTY_SYNTAX_CHECKERS = new SyntaxCheckerDescription[0];
    private static final LdapSyntax[] EMPTY_SYNTAXES = new LdapSyntax[0];
    private static final MatchingRule[] EMPTY_MATCHING_RULES = new MatchingRule[0];
    private static final AttributeType[] EMPTY_ATTRIBUTE_TYPES = new AttributeType[0];
    private static final ObjectClass[] EMPTY_OBJECT_CLASSES = new ObjectClass[0];
    private static final MatchingRuleUse[] EMPTY_MATCHING_RULE_USES = new MatchingRuleUse[0];
    private static final DitStructureRule[] EMPTY_DIT_STRUCTURE_RULES = new DitStructureRule[0];
    private static final DitContentRule[] EMPTY_DIT_CONTENT_RULES = new DitContentRule[0];
    private static final NameForm[] EMPTY_NAME_FORMS = new NameForm[0];
    private final LdapComparatorDescriptionSchemaParser comparatorParser = new LdapComparatorDescriptionSchemaParser();
    private final NormalizerDescriptionSchemaParser normalizerParser = new NormalizerDescriptionSchemaParser();
    private final SyntaxCheckerDescriptionSchemaParser syntaxCheckerParser = new SyntaxCheckerDescriptionSchemaParser();
    private final LdapSyntaxDescriptionSchemaParser syntaxParser = new LdapSyntaxDescriptionSchemaParser();
    private final MatchingRuleDescriptionSchemaParser matchingRuleParser = new MatchingRuleDescriptionSchemaParser();
    private final AttributeTypeDescriptionSchemaParser attributeTypeParser = new AttributeTypeDescriptionSchemaParser();
    private final ObjectClassDescriptionSchemaParser objectClassParser = new ObjectClassDescriptionSchemaParser();
    private final MatchingRuleUseDescriptionSchemaParser matchingRuleUseParser = new MatchingRuleUseDescriptionSchemaParser();
    private final DitStructureRuleDescriptionSchemaParser ditStructureRuleParser = new DitStructureRuleDescriptionSchemaParser();
    private final DitContentRuleDescriptionSchemaParser ditContentRuleParser = new DitContentRuleDescriptionSchemaParser();
    private final NameFormDescriptionSchemaParser nameFormParser = new NameFormDescriptionSchemaParser();
    private final SchemaManager schemaManager;

    public DescriptionParsers(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public SyntaxCheckerDescription[] parseSyntaxCheckers(Attribute attr) throws LdapInvalidAttributeValueException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_SYNTAX_CHECKERS;
        }
        SyntaxCheckerDescription[] syntaxCheckerDescriptions = new SyntaxCheckerDescription[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            try {
                syntaxCheckerDescriptions[pos++] = this.syntaxCheckerParser.parseSyntaxCheckerDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_405, value));
                iave.initCause(e);
                throw iave;
            }
        }
        return syntaxCheckerDescriptions;
    }

    public NormalizerDescription[] parseNormalizers(Attribute attr) throws LdapInvalidAttributeValueException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_NORMALIZERS;
        }
        NormalizerDescription[] normalizerDescriptions = new NormalizerDescription[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            try {
                normalizerDescriptions[pos++] = this.normalizerParser.parseNormalizerDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_406, value.getString()));
                iave.initCause(e);
                throw iave;
            }
        }
        return normalizerDescriptions;
    }

    public LdapComparatorDescription[] parseComparators(Attribute attr) throws LdapInvalidAttributeValueException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_COMPARATORS;
        }
        LdapComparatorDescription[] comparatorDescriptions = new LdapComparatorDescription[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            try {
                comparatorDescriptions[pos++] = this.comparatorParser.parseComparatorDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_407, value.getString()));
                iave.initCause(e);
                throw iave;
            }
        }
        return comparatorDescriptions;
    }

    public AttributeType[] parseAttributeTypes(Attribute attr) throws LdapException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_ATTRIBUTE_TYPES;
        }
        AttributeType[] attributeTypes = new AttributeType[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            AttributeType attributeType = null;
            try {
                attributeType = this.attributeTypeParser.parseAttributeTypeDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_408, value.getString()));
                iave.initCause(e);
                throw iave;
            }
            if (attributeType.getSuperiorOid() != null && !this.schemaManager.getAttributeTypeRegistry().contains(attributeType.getSuperiorOid())) {
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_409, attributeType.getSuperiorOid()));
            }
            if (attributeType.getSyntaxOid() != null && !this.schemaManager.getLdapSyntaxRegistry().contains(attributeType.getSyntaxOid())) {
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_410, attributeType.getSyntaxOid()));
            }
            if (attributeType.getEqualityOid() != null && !this.schemaManager.getMatchingRuleRegistry().contains(attributeType.getEqualityOid())) {
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_411, attributeType.getEqualityOid()));
            }
            if (attributeType.getOrderingOid() != null && !this.schemaManager.getMatchingRuleRegistry().contains(attributeType.getOrderingOid())) {
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_412, attributeType.getOrderingOid()));
            }
            if (attributeType.getSubstringOid() != null && !this.schemaManager.getMatchingRuleRegistry().contains(attributeType.getSubstringOid())) {
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_413, attributeType.getSubstringOid()));
            }
            attributeTypes[pos++] = attributeType;
        }
        return attributeTypes;
    }

    public ObjectClass[] parseObjectClasses(Attribute attr) throws LdapException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_OBJECT_CLASSES;
        }
        ObjectClass[] objectClasses = new ObjectClass[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            MutableObjectClass objectClass = null;
            try {
                objectClass = this.objectClassParser.parseObjectClassDescription(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_417, value.getString()));
                iave.initCause(e);
                throw iave;
            }
            if (objectClass.getSuperiorOids() != null && objectClass.getSuperiorOids().size() > 0) {
                for (String superiorOid : objectClass.getSuperiorOids()) {
                    if (superiorOid.equals("2.5.6.0") || superiorOid.equalsIgnoreCase("top") || this.schemaManager.getObjectClassRegistry().contains(superiorOid)) continue;
                    throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_418, superiorOid));
                }
            }
            if (objectClass.getMayAttributeTypeOids() != null && objectClass.getMayAttributeTypeOids().size() > 0) {
                for (String mayAttrOid : objectClass.getMayAttributeTypeOids()) {
                    if (this.schemaManager.getAttributeTypeRegistry().contains(mayAttrOid)) continue;
                    throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_419, mayAttrOid));
                }
            }
            if (objectClass.getMustAttributeTypeOids() != null && objectClass.getMustAttributeTypeOids().size() > 0) {
                for (String mustAttrOid : objectClass.getMustAttributeTypeOids()) {
                    if (this.schemaManager.getAttributeTypeRegistry().contains(mustAttrOid)) continue;
                    throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_420, mustAttrOid));
                }
            }
            objectClasses[pos++] = objectClass;
        }
        return objectClasses;
    }

    public MatchingRuleUse[] parseMatchingRuleUses(Attribute attr) throws LdapException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_MATCHING_RULE_USES;
        }
        MatchingRuleUse[] matchingRuleUses = new MatchingRuleUse[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            MatchingRuleUse matchingRuleUse = null;
            try {
                matchingRuleUse = this.matchingRuleUseParser.parseMatchingRuleUseDescription(value.getString());
                matchingRuleUse.setSpecification(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_421, value.getString()));
                iave.initCause(e);
                throw iave;
            }
            matchingRuleUses[pos++] = matchingRuleUse;
        }
        return matchingRuleUses;
    }

    public LdapSyntax[] parseLdapSyntaxes(Attribute attr) throws LdapException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_SYNTAXES;
        }
        LdapSyntax[] syntaxes = new LdapSyntax[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            LdapSyntax ldapSyntax = null;
            try {
                ldapSyntax = this.syntaxParser.parseLdapSyntaxDescription(value.getString());
                ldapSyntax.setSpecification(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_422, value.getString()));
                iave.initCause(e);
                throw iave;
            }
            if (!this.schemaManager.getSyntaxCheckerRegistry().contains(ldapSyntax.getOid())) {
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_423, new Object[0]));
            }
            ldapSyntax.isHumanReadable();
            syntaxes[pos++] = ldapSyntax;
        }
        return syntaxes;
    }

    public MatchingRule[] parseMatchingRules(Attribute attr) throws LdapException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_MATCHING_RULES;
        }
        MatchingRule[] matchingRules = new MatchingRule[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            MatchingRule matchingRule = null;
            try {
                matchingRule = this.matchingRuleParser.parseMatchingRuleDescription(value.getString());
                matchingRule.setSpecification(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_424, value.getString()));
                iave.initCause(e);
                throw iave;
            }
            if (!this.schemaManager.getLdapSyntaxRegistry().contains(matchingRule.getSyntaxOid())) {
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_425, matchingRule.getSyntaxOid()));
            }
            matchingRules[pos++] = matchingRule;
        }
        return matchingRules;
    }

    public DitStructureRule[] parseDitStructureRules(Attribute attr) throws LdapException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_DIT_STRUCTURE_RULES;
        }
        DitStructureRule[] ditStructureRules = new DitStructureRule[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            DitStructureRule ditStructureRule = null;
            try {
                ditStructureRule = this.ditStructureRuleParser.parseDITStructureRuleDescription(value.getString());
                ditStructureRule.setSpecification(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_426, value.getString()));
                iave.initCause(e);
                throw iave;
            }
            ditStructureRules[pos++] = ditStructureRule;
        }
        return ditStructureRules;
    }

    public DitContentRule[] parseDitContentRules(Attribute attr) throws LdapException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_DIT_CONTENT_RULES;
        }
        DitContentRule[] ditContentRules = new DitContentRule[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            DitContentRule ditContentRule = null;
            try {
                ditContentRule = this.ditContentRuleParser.parseDITContentRuleDescription(value.getString());
                ditContentRule.setSpecification(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_427, value.getString()));
                iave.initCause(e);
                throw iave;
            }
            ditContentRules[pos++] = ditContentRule;
        }
        return ditContentRules;
    }

    public NameForm[] parseNameForms(Attribute attr) throws LdapException {
        if (attr == null || attr.size() == 0) {
            return EMPTY_NAME_FORMS;
        }
        NameForm[] nameForms = new NameForm[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            NameForm nameForm = null;
            try {
                nameForm = this.nameFormParser.parseNameFormDescription(value.getString());
                nameForm.setSpecification(value.getString());
            }
            catch (ParseException e) {
                LdapInvalidAttributeValueException iave = new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_428, value.getString()));
                iave.initCause(e);
                throw iave;
            }
            nameForms[pos++] = nameForm;
        }
        return nameForms;
    }
}

