/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.PersistedBTree;

class BTreeHeader<K, V>
implements Cloneable {
    private long revision = 0L;
    private Long nbElems = 0L;
    private long rootPageOffset;
    private long btreeHeaderOffset;
    private Page<K, V> rootPage;
    private AtomicInteger nbUsers = new AtomicInteger(0);
    private BTree<K, V> btree;

    public long getBTreeInfoOffset() {
        return ((PersistedBTree)this.btree).getBtreeInfoOffset();
    }

    public long getBTreeHeaderOffset() {
        return this.btreeHeaderOffset;
    }

    public BTreeHeader<K, V> clone() {
        try {
            BTreeHeader copy = (BTreeHeader)super.clone();
            return copy;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    BTreeHeader<K, V> copy() {
        Object copy = this.clone();
        ((BTreeHeader)copy).rootPage = null;
        ((BTreeHeader)copy).rootPageOffset = -1L;
        ((BTreeHeader)copy).btreeHeaderOffset = -1L;
        return copy;
    }

    void setBTreeHeaderOffset(long btreeHeaderOffset) {
        this.btreeHeaderOffset = btreeHeaderOffset;
    }

    public long getRootPageOffset() {
        return this.rootPageOffset;
    }

    void setRootPageOffset(long rootPageOffset) {
        this.rootPageOffset = rootPageOffset;
    }

    public long getRevision() {
        return this.revision;
    }

    void setRevision(long revision) {
        this.revision = revision;
    }

    public long getNbElems() {
        return this.nbElems;
    }

    void setNbElems(long nbElems) {
        this.nbElems = nbElems;
    }

    void incrementNbElems() {
        Long l = this.nbElems;
        Long l2 = this.nbElems = Long.valueOf(this.nbElems + 1L);
    }

    void decrementNbElems() {
        Long l = this.nbElems;
        Long l2 = this.nbElems = Long.valueOf(this.nbElems - 1L);
    }

    Page<K, V> getRootPage() {
        return this.rootPage;
    }

    void setRootPage(Page<K, V> rootPage) {
        this.rootPage = rootPage;
        this.rootPageOffset = ((AbstractPage)rootPage).getOffset();
    }

    int getNbUsers() {
        return this.nbUsers.get();
    }

    void incrementNbUsers() {
        this.nbUsers.incrementAndGet();
    }

    void decrementNbUsers() {
        this.nbUsers.decrementAndGet();
    }

    BTree<K, V> getBtree() {
        return this.btree;
    }

    void setBtree(BTree<K, V> btree) {
        this.btree = btree;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("B-treeHeader ");
        sb.append(", offset[0x").append(Long.toHexString(this.btreeHeaderOffset)).append("]");
        sb.append(", name[").append(this.btree.getName()).append("]");
        sb.append(", revision[").append(this.revision).append("]");
        sb.append(", btreeInfoOffset[0x").append(Long.toHexString(((PersistedBTree)this.btree).getBtreeInfoOffset())).append("]");
        sb.append(", rootPageOffset[0x").append(Long.toHexString(this.rootPageOffset)).append("]");
        sb.append(", nbElems[").append(this.nbElems).append("]");
        sb.append(", nbUsers[").append(this.nbUsers.get()).append("]");
        return sb.toString();
    }
}

