/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.extended;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.api.ldap.extras.extended.PwdModifyRequest;
import org.apache.directory.api.ldap.extras.extended.PwdModifyResponse;
import org.apache.directory.api.ldap.extras.extended.PwdModifyResponseImpl;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.password.PasswordUtil;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PwdModifyHandler
implements ExtendedOperationHandler<PwdModifyRequest, PwdModifyResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(PwdModifyHandler.class);
    public static final Set<String> EXTENSION_OIDS;

    @Override
    public String getOid() {
        return "1.3.6.1.4.1.4203.1.11.1";
    }

    private void modifyUserPassword(CoreSession userSession, IoSession ioPipe, Dn userDn, byte[] oldPassword, byte[] newPassword, PwdModifyRequest req) {
        try {
            Entry userEntry = userSession.lookup(userDn, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
            if (userEntry == null) {
                LOG.error("Cannot find an entry for DN " + userDn);
                ioPipe.write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.NO_SUCH_OBJECT, "Cannot find an entry for DN " + userDn));
                return;
            }
            Attribute at = userEntry.get("userPassword");
            if (oldPassword != null && at != null) {
                for (Value v : at) {
                    boolean equal = PasswordUtil.compareCredentials(oldPassword, v.getBytes());
                    if (!equal) continue;
                    oldPassword = v.getBytes();
                }
            }
        }
        catch (LdapException le) {
            LOG.error("Cannot find an entry for DN " + userDn + ", exception : " + le.getMessage());
            ioPipe.write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.NO_SUCH_OBJECT, "Cannot find an entry for DN " + userDn));
            return;
        }
        ModifyRequestImpl modifyRequest = new ModifyRequestImpl();
        modifyRequest.setName(userDn);
        Control ppolicyControl = req.getControl("1.3.6.1.4.1.42.2.27.8.5.1");
        if (ppolicyControl != null) {
            modifyRequest.addControl(ppolicyControl);
        }
        DefaultModification modification = null;
        if (oldPassword != null) {
            modification = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, "userPassword", (byte[][])new byte[][]{oldPassword});
            modifyRequest.addModification(modification);
        }
        if (newPassword == null) {
            LOG.error("Cannot create a new password for user " + userDn + ", exception : " + userDn);
            ioPipe.write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.UNWILLING_TO_PERFORM, "Cannot generate a new password for user " + userDn));
            return;
        }
        modification = oldPassword == null ? new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "userPassword", (byte[][])new byte[][]{newPassword}) : new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, "userPassword", (byte[][])new byte[][]{newPassword});
        modifyRequest.addModification(modification);
        ResultCodeEnum errorCode = null;
        String errorMessage = null;
        try {
            userSession.modify(modifyRequest);
            LOG.debug("Password modified for user " + userDn);
            PwdModifyResponseImpl pmrl = new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.SUCCESS);
            ppolicyControl = ((ModifyResponse)modifyRequest.getResultResponse()).getControl("1.3.6.1.4.1.42.2.27.8.5.1");
            if (ppolicyControl != null) {
                pmrl.addControl(ppolicyControl);
            }
            ioPipe.write(pmrl);
            return;
        }
        catch (LdapOperationException loe) {
            errorCode = loe.getResultCode();
            errorMessage = loe.getMessage();
        }
        catch (LdapException le) {
            errorCode = ResultCodeEnum.OTHER;
            errorMessage = le.getMessage();
        }
        LOG.error("Cannot modify the password for user " + userDn + ", exception : " + errorMessage);
        PwdModifyResponseImpl errorPmrl = new PwdModifyResponseImpl(req.getMessageId(), errorCode, "Cannot modify the password for user " + userDn + ", exception : " + errorMessage);
        ppolicyControl = ((ModifyResponse)modifyRequest.getResultResponse()).getControl("1.3.6.1.4.1.42.2.27.8.5.1");
        if (ppolicyControl != null) {
            errorPmrl.addControl(ppolicyControl);
        }
        ioPipe.write(errorPmrl);
    }

    @Override
    public void handleExtendedOperation(LdapSession requestor, PwdModifyRequest req) throws Exception {
        LOG.debug("Password modification requested");
        DirectoryService service = requestor.getLdapServer().getDirectoryService();
        CoreSession adminSession = service.getAdminSession();
        String userIdentity = Strings.utf8ToString(req.getUserIdentity());
        Dn userDn = null;
        if (!Strings.isEmpty(userIdentity)) {
            try {
                userDn = service.getDnFactory().create(userIdentity);
            }
            catch (LdapInvalidDnException lide) {
                LOG.error("The user DN is invalid : " + userDn);
                requestor.getIoSession().write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.INVALID_DN_SYNTAX, "The user DN is invalid : " + userDn));
                return;
            }
        }
        byte[] oldPassword = req.getOldPassword();
        byte[] newPassword = req.getNewPassword();
        if (requestor.isAuthenticated()) {
            Dn principalDn = requestor.getCoreSession().getEffectivePrincipal().getDn();
            LOG.debug("User {} trying to modify password of user {}", (Object)principalDn, (Object)userDn);
            if (userDn != null && !userDn.equals(principalDn)) {
                if (!requestor.getCoreSession().isAdministrator()) {
                    LOG.error("Non-admin user cannot access another user's password to modify it");
                    requestor.getIoSession().write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS, "Non-admin user cannot access another user's password to modify it"));
                } else {
                    this.modifyUserPassword(requestor.getCoreSession(), requestor.getIoSession(), userDn, oldPassword, newPassword, req);
                }
            } else {
                this.modifyUserPassword(requestor.getCoreSession(), requestor.getIoSession(), principalDn, oldPassword, newPassword, req);
            }
        } else {
            BindOperationContext bindContext = new BindOperationContext(adminSession);
            bindContext.setDn(userDn);
            bindContext.setCredentials(oldPassword);
            try {
                service.getOperationManager().bind(bindContext);
            }
            catch (LdapException le) {
                requestor.getIoSession().write(new PwdModifyResponseImpl(req.getMessageId(), ResultCodeEnum.INVALID_CREDENTIALS));
                return;
            }
            this.modifyUserPassword(requestor.getCoreSession(), requestor.getIoSession(), userDn, oldPassword, newPassword, req);
        }
    }

    public static PwdModifyResponse getPwdModifyResponse() {
        return new PwdModifyResponseImpl();
    }

    @Override
    public Set<String> getExtensionOids() {
        return EXTENSION_OIDS;
    }

    @Override
    public void setLdapServer(LdapServer ldapServer) {
    }

    static {
        HashSet<String> set = new HashSet<String>(2);
        set.add("1.3.6.1.4.1.4203.1.11.1");
        set.add("1.3.6.1.4.1.4203.1.11.1");
        EXTENSION_OIDS = Collections.unmodifiableSet(set);
    }
}

