/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.shared;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedEntryCursor
extends AbstractCursor<Entry>
implements EntryFilteringCursor {
    private static final Logger LOG = LoggerFactory.getLogger(SortedEntryCursor.class);
    private TupleCursor<Entry, String> wrapped;
    private Tuple<Entry, String> tuple;
    private RecordManager recMan;
    private File dataFile;

    public SortedEntryCursor(BTree<Entry, String> btree, RecordManager recMan, File dataFile) throws IOException {
        this.recMan = recMan;
        this.dataFile = dataFile;
        this.wrapped = btree.browse();
    }

    @Override
    public boolean available() {
        return this.tuple != null;
    }

    @Override
    public void before(Entry element) throws LdapException, CursorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void after(Entry element) throws LdapException, CursorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
        try {
            this.tuple = null;
            this.wrapped.beforeFirst();
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        try {
            this.tuple = null;
            this.wrapped.afterLast();
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        try {
            this.wrapped.beforeFirst();
            return this.next();
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        try {
            this.wrapped.afterLast();
            return this.previous();
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        try {
            this.tuple = this.wrapped.prev();
            return true;
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.tuple = null;
            return false;
        }
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        try {
            this.tuple = this.wrapped.next();
            return true;
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.tuple = null;
            return false;
        }
    }

    @Override
    public Entry get() throws CursorException {
        if (this.tuple == null) {
            throw new InvalidCursorPositionException();
        }
        return this.tuple.getKey();
    }

    @Override
    public void close() {
        this.wrapped.close();
        this.deleteFile();
        super.close();
    }

    @Override
    public void close(Exception cause) {
        this.wrapped.close();
        this.deleteFile();
        super.close(cause);
    }

    @Override
    public boolean addEntryFilter(EntryFilter filter) {
        return false;
    }

    @Override
    public List<EntryFilter> getEntryFilters() {
        return null;
    }

    @Override
    public SearchOperationContext getOperationContext() {
        return null;
    }

    private void deleteFile() {
        if (this.recMan == null) {
            return;
        }
        try {
            this.recMan.close();
            this.dataFile.delete();
        }
        catch (IOException e) {
            LOG.warn("Failed to delete the sorted entry data file {}", (Object)this.dataFile, (Object)e);
        }
    }
}

