/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.directory.mavibot.btree.AbstractBTree;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeFactory;
import org.apache.directory.mavibot.btree.KeyHolder;
import org.apache.directory.mavibot.btree.NameRevision;
import org.apache.directory.mavibot.btree.NameRevisionSerializer;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.PageHolder;
import org.apache.directory.mavibot.btree.PageIO;
import org.apache.directory.mavibot.btree.PersistedBTree;
import org.apache.directory.mavibot.btree.PersistedBTreeConfiguration;
import org.apache.directory.mavibot.btree.PersistedKeyHolder;
import org.apache.directory.mavibot.btree.PersistedLeaf;
import org.apache.directory.mavibot.btree.PersistedNode;
import org.apache.directory.mavibot.btree.PersistedPageHolder;
import org.apache.directory.mavibot.btree.PersistedValueHolder;
import org.apache.directory.mavibot.btree.RevisionName;
import org.apache.directory.mavibot.btree.RevisionNameSerializer;
import org.apache.directory.mavibot.btree.ValueHolder;
import org.apache.directory.mavibot.btree.exception.BTreeAlreadyManagedException;
import org.apache.directory.mavibot.btree.exception.BTreeCreationException;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;
import org.apache.directory.mavibot.btree.exception.FreePageException;
import org.apache.directory.mavibot.btree.exception.InvalidBTreeException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;
import org.apache.directory.mavibot.btree.exception.RecordManagerException;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;
import org.apache.directory.mavibot.btree.serializer.IntSerializer;
import org.apache.directory.mavibot.btree.serializer.LongArraySerializer;
import org.apache.directory.mavibot.btree.serializer.LongSerializer;
import org.apache.directory.mavibot.btree.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordManager {
    protected static final Logger LOG = LoggerFactory.getLogger(RecordManager.class);
    protected static final Logger LOG_CHECK = LoggerFactory.getLogger("RM_CHECK");
    private File file;
    private FileChannel fileChannel;
    private int nbBtree;
    private long firstFreePage;
    List<PageIO> freePages = new ArrayList<PageIO>();
    public AtomicLong nbFreedPages = new AtomicLong(0L);
    public AtomicLong nbCreatedPages = new AtomicLong(0L);
    public AtomicLong nbReusedPages = new AtomicLong(0L);
    public AtomicLong nbUpdateRMHeader = new AtomicLong(0L);
    public AtomicLong nbUpdateBTreeHeader = new AtomicLong(0L);
    public AtomicLong nbUpdatePageIOs = new AtomicLong(0L);
    private long endOfFileOffset;
    private BTree<RevisionName, long[]> copiedPageBTree;
    private BTree<RevisionName, Long> revisionBTree;
    private static final long NO_PAGE = -1L;
    private static final int PAGE_SIZE = 4;
    private static final int LINK_SIZE = 8;
    private static final int BYTE_SIZE = 1;
    private static final int INT_SIZE = 4;
    private static final int LONG_SIZE = 8;
    private static final int DEFAULT_PAGE_SIZE = 512;
    private static int HEADER_SIZE = 512;
    private static ByteBuffer HEADER_BUFFER;
    private static byte[] HEADER_BYTES;
    private static byte[] LONG_LENGTH;
    private int pageSize = 512;
    private Map<String, BTree<Object, Object>> managedBTrees;
    private long lastAddedBTreeOffset = -1L;
    private static final String DEFAULT_FILE_NAME = "mavibot.db";
    private static final LongSerializer OFFSET_SERIALIZER;
    private static final String REVISION_BTREE_NAME = "_revisionBTree_";
    private static final String COPIED_PAGE_BTREE_NAME = "_copiedPageBTree_";
    private boolean keepRevisions;
    public static final boolean INTERNAL_BTREE = true;
    public static final boolean NORMAL_BTREE = false;
    private Map<Page<?, ?>, BTree<?, ?>> pendingPages = new LinkedHashMap();
    private BTree<NameRevision, Long> btreeOfBtrees;
    private static final String BOB_ONE_NAME = "_BTREE_OF_BTREES_";
    private long bobCurrentRevision;
    private long bobOldRevision;
    private static final byte[] HEX_CHAR;

    public RecordManager(String fileName) {
        this(fileName, 512);
    }

    public RecordManager(String fileName, int pageSize) {
        this.managedBTrees = new LinkedHashMap<String, BTree<Object, Object>>();
        HEADER_BUFFER = ByteBuffer.allocate(pageSize);
        HEADER_BYTES = new byte[pageSize];
        HEADER_SIZE = pageSize;
        File tmpFile = new File(fileName);
        if (tmpFile.isDirectory()) {
            tmpFile = new File(tmpFile, DEFAULT_FILE_NAME);
        }
        boolean isNewFile = this.createFile(tmpFile);
        try {
            RandomAccessFile randomFile = new RandomAccessFile(this.file, "rw");
            this.fileChannel = randomFile.getChannel();
            this.endOfFileOffset = this.fileChannel.size();
            if (isNewFile) {
                this.pageSize = pageSize;
                this.initRecordManager();
            } else {
                this.loadRecordManager();
            }
        }
        catch (Exception e) {
            LOG.error("Error while initializing the RecordManager : {}", (Object)e.getMessage());
            LOG.error("", e);
            throw new RecordManagerException(e);
        }
    }

    private boolean createFile(File mavibotFile) {
        try {
            boolean creation = mavibotFile.createNewFile();
            this.file = mavibotFile;
            if (mavibotFile.length() == 0L) {
                return true;
            }
            return creation;
        }
        catch (IOException ioe) {
            LOG.error("Cannot create the file {}", (Object)mavibotFile.getName());
            return false;
        }
    }

    private void initRecordManager() throws IOException {
        this.nbBtree = 0;
        this.firstFreePage = -1L;
        this.bobCurrentRevision = 0L;
        this.bobOldRevision = 0L;
        this.updateRecordManagerHeader();
        this.endOfFileOffset = this.fileChannel.size();
        this.btreeOfBtrees = BTreeFactory.createPersistedBTree(BOB_ONE_NAME, new NameRevisionSerializer(), new LongSerializer());
        this.copiedPageBTree = BTreeFactory.createPersistedBTree(COPIED_PAGE_BTREE_NAME, new RevisionNameSerializer(), new LongArraySerializer());
        this.revisionBTree = BTreeFactory.createPersistedBTree(REVISION_BTREE_NAME, new RevisionNameSerializer(), new LongSerializer());
        try {
            this.manage(this.copiedPageBTree);
            this.manage(this.revisionBTree);
        }
        catch (BTreeAlreadyManagedException bTreeAlreadyManagedException) {
            // empty catch block
        }
    }

    private void loadRecordManager() throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (this.fileChannel.size() != 0L) {
            ByteBuffer header = ByteBuffer.allocate(HEADER_SIZE);
            this.fileChannel.read(header);
            header.rewind();
            this.pageSize = header.getInt();
            this.nbBtree = header.getInt();
            this.firstFreePage = header.getLong();
            long bobRevision1 = header.getLong();
            long bobRevision2 = header.getLong();
            if (bobRevision1 < bobRevision2) {
                this.bobOldRevision = bobRevision1;
                this.bobCurrentRevision = bobRevision2;
            } else if (bobRevision1 > bobRevision2) {
                this.bobOldRevision = bobRevision2;
                this.bobCurrentRevision = bobRevision1;
            } else {
                this.bobOldRevision = bobRevision1;
                this.bobCurrentRevision = bobRevision2;
            }
            long btreeOffset = HEADER_SIZE;
            PageIO[] pageIos = this.readPageIOs(HEADER_SIZE, Long.MAX_VALUE);
            this.copiedPageBTree = BTreeFactory.createPersistedBTree();
            ((PersistedBTree)this.copiedPageBTree).setBtreeOffset(btreeOffset);
            this.loadBTree(pageIos, this.copiedPageBTree);
            long nextBtreeOffset = ((PersistedBTree)this.copiedPageBTree).getNextBTreeOffset();
            pageIos = this.readPageIOs(nextBtreeOffset, Long.MAX_VALUE);
            this.revisionBTree = BTreeFactory.createPersistedBTree();
            ((PersistedBTree)this.revisionBTree).setBtreeOffset(nextBtreeOffset);
            this.loadBTree(pageIos, this.revisionBTree);
            nextBtreeOffset = ((PersistedBTree)this.revisionBTree).getNextBTreeOffset();
            for (int i = 2; i < this.nbBtree; ++i) {
                BTree btree = BTreeFactory.createPersistedBTree();
                ((PersistedBTree)btree).setRecordManager(this);
                ((PersistedBTree)btree).setBtreeOffset(nextBtreeOffset);
                this.lastAddedBTreeOffset = nextBtreeOffset;
                pageIos = this.readPageIOs(nextBtreeOffset, Long.MAX_VALUE);
                this.loadBTree(pageIos, btree);
                nextBtreeOffset = ((PersistedBTree)btree).getNextBTreeOffset();
                this.managedBTrees.put(btree.getName(), btree);
            }
            this.endOfFileOffset = this.fileChannel.size();
        }
    }

    private PageIO[] readPageIOs(long position, long limit) throws IOException, EndOfFileExceededException {
        long dataRead;
        LOG.debug("Read PageIOs at position {}", (Object)position);
        if (limit <= 0L) {
            limit = Long.MAX_VALUE;
        }
        PageIO firstPage = this.fetchPage(position);
        firstPage.setSize();
        ArrayList<PageIO> listPages = new ArrayList<PageIO>();
        listPages.add(firstPage);
        long nextPage = firstPage.getNextPage();
        if (dataRead < limit && nextPage != -1L) {
            for (dataRead = (long)(this.pageSize - 8 - 4); dataRead < limit; dataRead += (long)(this.pageSize - 8)) {
                PageIO page = this.fetchPage(nextPage);
                listPages.add(page);
                nextPage = page.getNextPage();
                if (nextPage != -1L) continue;
                page.setNextPage(-1L);
                break;
            }
        }
        LOG.debug("Nb of PageIOs read : {}", (Object)listPages.size());
        return listPages.toArray(new PageIO[0]);
    }

    private <K, V> void loadBTree(PageIO[] pageIos, BTree<K, V> btree) throws EndOfFileExceededException, IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        long dataPos = 0L;
        long revision = this.readLong(pageIos, dataPos);
        BTreeFactory.setRevision(btree, revision);
        long nbElems = this.readLong(pageIos, dataPos += 8L);
        BTreeFactory.setNbElems(btree, nbElems);
        long rootPageOffset = this.readLong(pageIos, dataPos += 8L);
        BTreeFactory.setRootPageOffset(btree, rootPageOffset);
        long nextBTreeOffset = this.readLong(pageIos, dataPos += 8L);
        BTreeFactory.setNextBTreeOffset(btree, nextBTreeOffset);
        int btreePageSize = this.readInt(pageIos, dataPos += 8L);
        BTreeFactory.setPageSize(btree, btreePageSize);
        ByteBuffer btreeNameBytes = this.readBytes(pageIos, dataPos += 4L);
        String btreeName = Strings.utf8ToString(btreeNameBytes);
        BTreeFactory.setName(btree, btreeName);
        ByteBuffer keySerializerBytes = this.readBytes(pageIos, dataPos += (long)(4 + btreeNameBytes.limit()));
        dataPos += (long)(4 + keySerializerBytes.limit());
        String keySerializerFqcn = "";
        if (keySerializerBytes != null) {
            keySerializerFqcn = Strings.utf8ToString(keySerializerBytes);
        }
        BTreeFactory.setKeySerializer(btree, keySerializerFqcn);
        ByteBuffer valueSerializerBytes = this.readBytes(pageIos, dataPos);
        String valueSerializerFqcn = "";
        dataPos += (long)(4 + valueSerializerBytes.limit());
        if (valueSerializerBytes != null) {
            valueSerializerFqcn = Strings.utf8ToString(valueSerializerBytes);
        }
        BTreeFactory.setValueSerializer(btree, valueSerializerFqcn);
        int allowDuplicates = this.readInt(pageIos, dataPos);
        ((PersistedBTree)btree).setAllowDuplicates(allowDuplicates != 0);
        dataPos += 4L;
        btree.init();
        ((PersistedBTree)btree).setRecordManager(this);
        PageIO[] rootPageIos = this.readPageIOs(rootPageOffset, Long.MAX_VALUE);
        Page<K, V> btreeRoot = this.readPage(btree, rootPageIos);
        BTreeFactory.setRecordManager(btree, this);
        BTreeFactory.setRootPage(btree, btreeRoot);
    }

    private <K, V> Page<K, V> readNode(BTree<K, V> btree, long offset, long revision, int nbElems) throws IOException {
        Page<K, V> node = BTreeFactory.createNode(btree, revision, nbElems);
        PageIO[] pageIos = this.readPageIOs(offset, Long.MAX_VALUE);
        return node;
    }

    public <K, V> Page<K, V> deserialize(BTree<K, V> btree, long offset) throws EndOfFileExceededException, IOException {
        PageIO[] rootPageIos = this.readPageIOs(offset, Long.MAX_VALUE);
        Page<K, V> page = this.readPage(btree, rootPageIos);
        ((AbstractPage)page).setOffset(rootPageIos[0].getOffset());
        ((AbstractPage)page).setLastOffset(rootPageIos[rootPageIos.length - 1].getOffset());
        return page;
    }

    private <K, V> Page<K, V> readPage(BTree<K, V> btree, PageIO[] pageIos) throws IOException {
        long position = 0L;
        long revision = this.readLong(pageIos, position);
        int nbElems = this.readInt(pageIos, position += 8L);
        AbstractPage page = null;
        ByteBuffer byteBuffer = this.readBytes(pageIos, position += 4L);
        page = nbElems >= 0 ? this.readLeafKeysAndValues(btree, nbElems, revision, byteBuffer, pageIos) : this.readNodeKeysAndValues(btree, -nbElems, revision, byteBuffer, pageIos);
        return page;
    }

    private <K, V> PersistedLeaf<K, V> readLeafKeysAndValues(BTree<K, V> btree, int nbElems, long revision, ByteBuffer byteBuffer, PageIO[] pageIos) {
        PersistedLeaf leaf = (PersistedLeaf)BTreeFactory.createLeaf(btree, revision, nbElems);
        leaf.setOffset(pageIos[0].getOffset());
        leaf.setLastOffset(pageIos[pageIos.length - 1].getOffset());
        int[] keyLengths = new int[nbElems];
        int[] valueLengths = new int[nbElems];
        for (int i = 0; i < nbElems; ++i) {
            int nbValues = byteBuffer.getInt();
            PersistedValueHolder<V> valueHolder = null;
            if (nbValues < 0) {
                byte[] btreeOffsetBytes = new byte[8];
                byteBuffer.get(btreeOffsetBytes);
                valueHolder = new PersistedValueHolder<V>(btree, 1 - nbValues, btreeOffsetBytes);
            } else {
                valueLengths[i] = byteBuffer.getInt();
                byte[] arrayBytes = new byte[valueLengths[i]];
                byteBuffer.get(arrayBytes);
                valueHolder = new PersistedValueHolder<V>(btree, nbValues, arrayBytes);
            }
            BTreeFactory.setValue(btree, leaf, i, valueHolder);
            keyLengths[i] = byteBuffer.getInt();
            byte[] data = new byte[keyLengths[i]];
            byteBuffer.get(data);
            BTreeFactory.setKey(btree, leaf, i, data);
        }
        return leaf;
    }

    private <K, V> PersistedNode<K, V> readNodeKeysAndValues(BTree<K, V> btree, int nbElems, long revision, ByteBuffer byteBuffer, PageIO[] pageIos) throws IOException {
        PersistedNode node = (PersistedNode)BTreeFactory.createNode(btree, revision, nbElems);
        for (int i = 0; i < nbElems; ++i) {
            long offset = OFFSET_SERIALIZER.deserialize(byteBuffer);
            long lastOffset = OFFSET_SERIALIZER.deserialize(byteBuffer);
            PersistedPageHolder<K, V> valueHolder = new PersistedPageHolder<K, V>(btree, null, offset, lastOffset);
            node.setValue(i, valueHolder);
            int keyLength = byteBuffer.getInt();
            int currentPosition = byteBuffer.position();
            K key = btree.getKeySerializer().deserialize(byteBuffer);
            byteBuffer.position(currentPosition + keyLength);
            BTreeFactory.setKey(btree, node, i, key);
        }
        long offset = OFFSET_SERIALIZER.deserialize(byteBuffer);
        long lastOffset = OFFSET_SERIALIZER.deserialize(byteBuffer);
        PersistedPageHolder<K, V> valueHolder = new PersistedPageHolder<K, V>(btree, null, offset, lastOffset);
        node.setValue(nbElems, valueHolder);
        return node;
    }

    private ByteBuffer readBytes(PageIO[] pageIos, long position) {
        int length = this.readInt(pageIos, position);
        int pageNb = this.computePageNb(position += 4L);
        int pagePos = (int)(position + (long)((pageNb + 1) * 8) + 4L) - pageNb * this.pageSize;
        ByteBuffer pageData = pageIos[pageNb].getData();
        int remaining = pageData.capacity() - pagePos;
        if (length == 0) {
            return null;
        }
        ByteBuffer bytes = ByteBuffer.allocate(length);
        int bytesPos = 0;
        while (length > 0) {
            int oldLimit;
            if (length <= remaining) {
                pageData.mark();
                pageData.position(pagePos);
                oldLimit = pageData.limit();
                pageData.limit(pagePos + length);
                bytes.put(pageData);
                pageData.limit(oldLimit);
                pageData.reset();
                bytes.rewind();
                return bytes;
            }
            pageData.mark();
            pageData.position(pagePos);
            oldLimit = pageData.limit();
            pageData.limit(pagePos + remaining);
            bytes.put(pageData);
            pageData.limit(oldLimit);
            pageData.reset();
            pagePos = 8;
            bytesPos += remaining;
            pageData = pageIos[++pageNb].getData();
            length -= remaining;
            remaining = pageData.capacity() - pagePos;
        }
        bytes.rewind();
        return bytes;
    }

    private int readInt(PageIO[] pageIos, long position) {
        int pageNb = this.computePageNb(position);
        int pagePos = (int)(position + (long)((pageNb + 1) * 8) + 4L) - pageNb * this.pageSize;
        ByteBuffer pageData = pageIos[pageNb].getData();
        int remaining = pageData.capacity() - pagePos;
        int value = 0;
        if (remaining >= 4) {
            value = pageData.getInt(pagePos);
        } else {
            value = 0;
            switch (remaining) {
                case 3: {
                    value += (pageData.get(pagePos + 2) & 0xFF) << 8;
                }
                case 2: {
                    value += (pageData.get(pagePos + 1) & 0xFF) << 16;
                }
                case 1: {
                    value += pageData.get(pagePos) << 24;
                }
            }
            pageData = pageIos[pageNb + 1].getData();
            pagePos = 8;
            switch (remaining) {
                case 1: {
                    value += (pageData.get(pagePos) & 0xFF) << 16;
                }
                case 2: {
                    value += (pageData.get(pagePos + 2 - remaining) & 0xFF) << 8;
                }
                case 3: {
                    value += pageData.get(pagePos + 3 - remaining) & 0xFF;
                }
            }
        }
        return value;
    }

    private byte readByte(PageIO[] pageIos, long position) {
        int pageNb = this.computePageNb(position);
        int pagePos = (int)(position + (long)((pageNb + 1) * 8) + 4L) - pageNb * this.pageSize;
        ByteBuffer pageData = pageIos[pageNb].getData();
        byte value = 0;
        value = pageData.get(pagePos);
        return value;
    }

    private long readLong(PageIO[] pageIos, long position) {
        int pageNb = this.computePageNb(position);
        int pagePos = (int)(position + (long)((pageNb + 1) * 8) + 4L) - pageNb * this.pageSize;
        ByteBuffer pageData = pageIos[pageNb].getData();
        int remaining = pageData.capacity() - pagePos;
        long value = 0L;
        if (remaining >= 8) {
            value = pageData.getLong(pagePos);
        } else {
            switch (remaining) {
                case 7: {
                    value += ((long)pageData.get(pagePos + 6) & 0xFFL) << 8;
                }
                case 6: {
                    value += ((long)pageData.get(pagePos + 5) & 0xFFL) << 16;
                }
                case 5: {
                    value += ((long)pageData.get(pagePos + 4) & 0xFFL) << 24;
                }
                case 4: {
                    value += ((long)pageData.get(pagePos + 3) & 0xFFL) << 32;
                }
                case 3: {
                    value += ((long)pageData.get(pagePos + 2) & 0xFFL) << 40;
                }
                case 2: {
                    value += ((long)pageData.get(pagePos + 1) & 0xFFL) << 48;
                }
                case 1: {
                    value += (long)pageData.get(pagePos) << 56;
                }
            }
            pageData = pageIos[pageNb + 1].getData();
            pagePos = 8;
            switch (remaining) {
                case 1: {
                    value += ((long)pageData.get(pagePos) & 0xFFL) << 48;
                }
                case 2: {
                    value += ((long)pageData.get(pagePos + 2 - remaining) & 0xFFL) << 40;
                }
                case 3: {
                    value += ((long)pageData.get(pagePos + 3 - remaining) & 0xFFL) << 32;
                }
                case 4: {
                    value += ((long)pageData.get(pagePos + 4 - remaining) & 0xFFL) << 24;
                }
                case 5: {
                    value += ((long)pageData.get(pagePos + 5 - remaining) & 0xFFL) << 16;
                }
                case 6: {
                    value += ((long)pageData.get(pagePos + 6 - remaining) & 0xFFL) << 8;
                }
                case 7: {
                    value += (long)pageData.get(pagePos + 7 - remaining) & 0xFFL;
                }
            }
        }
        return value;
    }

    public synchronized <K, V> void manage(BTree<K, V> btree) throws BTreeAlreadyManagedException, IOException {
        this.manage(btree, false);
    }

    public synchronized <K, V> void manage(BTree<K, V> btree, boolean internalTree) throws BTreeAlreadyManagedException, IOException {
        LOG.debug("Managing the btree {} which is an internam tree : {}", (Object)btree.getName(), (Object)internalTree);
        BTreeFactory.setRecordManager(btree, this);
        String name = btree.getName();
        if (this.managedBTrees.containsKey(name)) {
            LOG.error("There is already a BTree named '{}' managed by this recordManager", (Object)name);
            throw new BTreeAlreadyManagedException(name);
        }
        if (!internalTree) {
            this.managedBTrees.put(name, btree);
        }
        byte[] btreeNameBytes = Strings.getBytesUtf8(name);
        byte[] keySerializerBytes = Strings.getBytesUtf8(btree.getKeySerializerFQCN());
        byte[] valueSerializerBytes = Strings.getBytesUtf8(btree.getValueSerializerFQCN());
        int bufferSize = 4 + btreeNameBytes.length + 4 + keySerializerBytes.length + 4 + valueSerializerBytes.length + 4 + 8 + 8 + 8 + 8 + 4;
        PageIO[] pageIos = this.getFreePageIOs(bufferSize);
        long btreeOffset = pageIos[0].getOffset();
        ((PersistedBTree)btree).setBtreeOffset(btreeOffset);
        long position = 0L;
        position = this.store(position, btree.getRevision(), pageIos);
        position = this.store(position, btree.getNbElems(), pageIos);
        Page<K, V> rootPage = BTreeFactory.getRootPage(btree);
        PageIO[] rootPageIos = this.serializePage(btree, btree.getRevision(), rootPage);
        PageIO rootPageIo = rootPageIos[0];
        position = this.store(position, rootPageIo.getOffset(), pageIos);
        ((PersistedBTree)btree).setRootPageOffset(rootPageIo.getOffset());
        ((PersistedLeaf)rootPage).setOffset(rootPageIo.getOffset());
        position = this.store(position, -1L, pageIos);
        position = this.store(position, btree.getPageSize(), pageIos);
        position = this.store(position, btreeNameBytes, pageIos);
        position = this.store(position, keySerializerBytes, pageIos);
        position = this.store(position, valueSerializerBytes, pageIos);
        position = this.store(position, btree.isAllowDuplicates() ? 1 : 0, pageIos);
        LOG.debug("Flushing the newly managed '{}' btree header", (Object)btree.getName());
        this.flushPages(pageIos);
        LOG.debug("Flushing the newly managed '{}' btree rootpage", (Object)btree.getName());
        this.flushPages(rootPageIos);
        if (!internalTree) {
            ++this.nbBtree;
            if (this.lastAddedBTreeOffset != -1L) {
                pageIos = this.readPageIOs(this.lastAddedBTreeOffset, 32L);
                this.store(24L, btreeOffset, pageIos);
                LOG.debug("Updated the previous btree pointer on the added BTree {}", (Object)btree.getName());
                this.flushPages(pageIos);
            }
            this.lastAddedBTreeOffset = btreeOffset;
            this.updateRecordManagerHeader();
        }
        if (LOG_CHECK.isDebugEnabled()) {
            this.check();
        }
    }

    private <K, V> PageIO[] serializePage(BTree<K, V> btree, long revision, Page<K, V> page) throws IOException {
        int nbElems = page.getNbElems();
        if (nbElems == 0) {
            return this.serializeRootPage(revision);
        }
        int nbBuffers = 3 + nbElems * 3;
        int dataSize = 0;
        int serializedSize = 0;
        if (page.isNode()) {
            ++nbBuffers;
        }
        ArrayList<byte[]> serializedData = new ArrayList<byte[]>(nbBuffers);
        byte[] buffer = LongSerializer.serialize(revision);
        serializedData.add(buffer);
        serializedSize += buffer.length;
        int pageNbElems = nbElems;
        if (page.isNode()) {
            pageNbElems = -nbElems;
        }
        buffer = IntSerializer.serialize(pageNbElems);
        serializedData.add(buffer);
        serializedSize += buffer.length;
        for (int pos = 0; pos < nbElems; ++pos) {
            if (page.isNode()) {
                dataSize += this.serializeNodeValue((PersistedNode)page, pos, serializedData);
                dataSize += this.serializeNodeKey((PersistedNode)page, pos, serializedData);
                continue;
            }
            dataSize += this.serializeLeafValue((PersistedLeaf)page, pos, serializedData);
            dataSize += this.serializeLeafKey((PersistedLeaf)page, pos, serializedData);
        }
        if (page.isNode()) {
            dataSize += this.serializeNodeValue((PersistedNode)page, nbElems, serializedData);
        }
        buffer = IntSerializer.serialize(dataSize);
        serializedData.add(2, buffer);
        serializedSize += buffer.length;
        PageIO[] pageIos = this.getFreePageIOs(serializedSize += dataSize);
        long position = 0L;
        for (byte[] bytes : serializedData) {
            position = this.storeRaw(position, bytes, pageIos);
        }
        return pageIos;
    }

    private <K, V> int serializeNodeKey(PersistedNode<K, V> node, int pos, List<byte[]> serializedData) {
        KeyHolder<K> holder = node.getKeyHolder(pos);
        byte[] buffer = ((PersistedKeyHolder)holder).getRaw();
        byte[] length = IntSerializer.serialize(buffer.length);
        serializedData.add(length);
        if (buffer.length != 0) {
            serializedData.add(buffer);
        }
        return buffer.length + 4;
    }

    private <K, V> int serializeNodeValue(PersistedNode<K, V> node, int pos, List<byte[]> serializedData) throws IOException {
        Page child = node.getReference(pos);
        byte[] buffer = LongSerializer.serialize(((AbstractPage)child).getOffset());
        serializedData.add(buffer);
        int dataSize = buffer.length;
        buffer = LongSerializer.serialize(((AbstractPage)child).getLastOffset());
        serializedData.add(buffer);
        return dataSize += buffer.length;
    }

    private <K, V> int serializeLeafKey(PersistedLeaf<K, V> leaf, int pos, List<byte[]> serializedData) {
        int dataSize = 0;
        KeyHolder<K> keyHolder = leaf.getKeyHolder(pos);
        byte[] keyData = ((PersistedKeyHolder)keyHolder).getRaw();
        if (keyData != null) {
            byte[] length = IntSerializer.serialize(keyData.length);
            serializedData.add(length);
            serializedData.add(keyData);
            dataSize += keyData.length + 4;
        } else {
            serializedData.add(IntSerializer.serialize(0));
            dataSize += 4;
        }
        return dataSize;
    }

    private <K, V> int serializeLeafValue(PersistedLeaf<K, V> leaf, int pos, List<byte[]> serializedData) throws IOException {
        ValueHolder<V> valueHolder = leaf.getValue(pos);
        int dataSize = 0;
        int nbValues = valueHolder.size();
        if (!valueHolder.isSubBtree()) {
            byte[] buffer = IntSerializer.serialize(nbValues);
            serializedData.add(buffer);
            dataSize = 4;
            byte[] data = ((PersistedValueHolder)valueHolder).getRaw();
            dataSize += data.length;
            buffer = IntSerializer.serialize(data.length);
            serializedData.add(buffer);
            dataSize += 4;
            if (data.length > 0) {
                serializedData.add(data);
            }
        } else {
            if (nbValues == 0) {
                byte[] buffer = IntSerializer.serialize(nbValues);
                serializedData.add(buffer);
                return buffer.length;
            }
            if (valueHolder.isSubBtree()) {
                byte[] buffer = IntSerializer.serialize(-(nbValues + 1));
                serializedData.add(buffer);
                dataSize += buffer.length;
                buffer = LongSerializer.serialize(((PersistedValueHolder)valueHolder).getOffset());
                serializedData.add(buffer);
                dataSize += buffer.length;
            } else {
                byte[] buffer = IntSerializer.serialize(nbValues);
                serializedData.add(buffer);
                dataSize += buffer.length;
                byte[] data = ((PersistedValueHolder)valueHolder).getRaw();
                buffer = IntSerializer.serialize(data.length);
                serializedData.add(buffer);
                dataSize += buffer.length;
                if (data.length > 0) {
                    serializedData.add(data);
                }
                dataSize += data.length;
            }
        }
        return dataSize;
    }

    private PageIO[] serializeRootPage(long revision) throws IOException {
        PageIO[] pageIos = new PageIO[1];
        PageIO newPage = this.fetchNewPage();
        long position = 0L;
        position = this.store(position, revision, newPage);
        position = this.store(position, 0, newPage);
        newPage.setSize((int)position);
        pageIos[0] = newPage;
        return pageIos;
    }

    public void updateRecordManagerHeader() throws IOException {
        RecordManager.HEADER_BYTES[0] = (byte)(this.pageSize >>> 24);
        RecordManager.HEADER_BYTES[1] = (byte)(this.pageSize >>> 16);
        RecordManager.HEADER_BYTES[2] = (byte)(this.pageSize >>> 8);
        RecordManager.HEADER_BYTES[3] = (byte)this.pageSize;
        RecordManager.HEADER_BYTES[4] = (byte)(this.nbBtree >>> 24);
        RecordManager.HEADER_BYTES[5] = (byte)(this.nbBtree >>> 16);
        RecordManager.HEADER_BYTES[6] = (byte)(this.nbBtree >>> 8);
        RecordManager.HEADER_BYTES[7] = (byte)this.nbBtree;
        RecordManager.HEADER_BYTES[8] = (byte)(this.firstFreePage >>> 56);
        RecordManager.HEADER_BYTES[9] = (byte)(this.firstFreePage >>> 48);
        RecordManager.HEADER_BYTES[10] = (byte)(this.firstFreePage >>> 40);
        RecordManager.HEADER_BYTES[11] = (byte)(this.firstFreePage >>> 32);
        RecordManager.HEADER_BYTES[12] = (byte)(this.firstFreePage >>> 24);
        RecordManager.HEADER_BYTES[13] = (byte)(this.firstFreePage >>> 16);
        RecordManager.HEADER_BYTES[14] = (byte)(this.firstFreePage >>> 8);
        RecordManager.HEADER_BYTES[15] = (byte)this.firstFreePage;
        RecordManager.HEADER_BYTES[17] = (byte)(this.bobOldRevision >>> 56);
        RecordManager.HEADER_BYTES[18] = (byte)(this.bobOldRevision >>> 48);
        RecordManager.HEADER_BYTES[19] = (byte)(this.bobOldRevision >>> 40);
        RecordManager.HEADER_BYTES[20] = (byte)(this.bobOldRevision >>> 32);
        RecordManager.HEADER_BYTES[21] = (byte)(this.bobOldRevision >>> 24);
        RecordManager.HEADER_BYTES[22] = (byte)(this.bobOldRevision >>> 16);
        RecordManager.HEADER_BYTES[23] = (byte)(this.bobOldRevision >>> 8);
        RecordManager.HEADER_BYTES[24] = (byte)this.bobOldRevision;
        RecordManager.HEADER_BYTES[17] = (byte)(this.bobCurrentRevision >>> 56);
        RecordManager.HEADER_BYTES[18] = (byte)(this.bobCurrentRevision >>> 48);
        RecordManager.HEADER_BYTES[19] = (byte)(this.bobCurrentRevision >>> 40);
        RecordManager.HEADER_BYTES[20] = (byte)(this.bobCurrentRevision >>> 32);
        RecordManager.HEADER_BYTES[21] = (byte)(this.bobCurrentRevision >>> 24);
        RecordManager.HEADER_BYTES[22] = (byte)(this.bobCurrentRevision >>> 16);
        RecordManager.HEADER_BYTES[23] = (byte)(this.bobCurrentRevision >>> 8);
        RecordManager.HEADER_BYTES[24] = (byte)this.bobCurrentRevision;
        HEADER_BUFFER.put(HEADER_BYTES);
        HEADER_BUFFER.flip();
        LOG.debug("Update RM header, FF : {}", (Object)this.firstFreePage);
        this.fileChannel.write(HEADER_BUFFER, 0L);
        HEADER_BUFFER.clear();
        this.nbUpdateRMHeader.incrementAndGet();
    }

    <K, V> void updateBtreeHeader(BTree<K, V> btree, long rootPageOffset) throws EndOfFileExceededException, IOException {
        long offset = ((PersistedBTree)btree).getBtreeOffset();
        long headerSize = 24L;
        PageIO[] pageIos = this.readPageIOs(offset, headerSize);
        long position = 0L;
        position = this.store(position, btree.getRevision(), pageIos);
        position = this.store(position, btree.getNbElems(), pageIos);
        position = this.store(position, rootPageOffset, pageIos);
        if (LOG.isDebugEnabled()) {
            LOG.debug("-----> Flushing the '{}' BTreeHeader", (Object)btree.getName());
            LOG.debug("  revision : " + btree.getRevision() + ", NbElems : " + btree.getNbElems() + ", root offset : " + rootPageOffset);
        }
        this.flushPages(pageIos);
        this.nbUpdateBTreeHeader.incrementAndGet();
        if (LOG_CHECK.isDebugEnabled()) {
            this.check();
        }
    }

    private void flushPages(PageIO ... pageIos) throws IOException {
        if (LOG.isDebugEnabled()) {
            for (PageIO pageIo : pageIos) {
                this.dump(pageIo);
            }
        }
        for (PageIO pageIo : pageIos) {
            pageIo.getData().rewind();
            if (this.fileChannel.size() < pageIo.getOffset() + (long)this.pageSize) {
                LOG.debug("Adding a page at the end of the file");
                this.fileChannel.write(pageIo.getData(), this.fileChannel.size());
            } else {
                LOG.debug("Writing a page at position {}", (Object)pageIo.getOffset());
                this.fileChannel.write(pageIo.getData(), pageIo.getOffset());
            }
            this.nbUpdatePageIOs.incrementAndGet();
            pageIo.getData().rewind();
        }
    }

    private int computePageNb(long offset) {
        long pageNb = 0L;
        if ((offset -= (long)(this.pageSize - 8 - 4)) < 0L) {
            return (int)pageNb;
        }
        pageNb = 1L + offset / (long)(this.pageSize - 8);
        return (int)pageNb;
    }

    private long store(long position, byte[] bytes, PageIO ... pageIos) {
        if (bytes != null) {
            position = this.store(position, bytes.length, pageIos);
            int pageNb = this.computePageNb(position);
            ByteBuffer pageData = pageIos[pageNb].getData();
            int pagePos = (int)(position + (long)((pageNb + 1) * 8) + 4L) - pageNb * this.pageSize;
            int remaining = pageData.capacity() - pagePos;
            int nbStored = bytes.length;
            while (nbStored > 0) {
                if (remaining > nbStored) {
                    pageData.mark();
                    pageData.position(pagePos);
                    pageData.put(bytes, bytes.length - nbStored, nbStored);
                    pageData.reset();
                    nbStored = 0;
                    continue;
                }
                pageData.mark();
                pageData.position(pagePos);
                pageData.put(bytes, bytes.length - nbStored, remaining);
                pageData.reset();
                pageData = pageIos[++pageNb].getData();
                pagePos = 8;
                nbStored -= remaining;
                remaining = pageData.capacity() - pagePos;
            }
            position += (long)bytes.length;
        } else {
            position = this.store(position, 0, pageIos);
        }
        return position;
    }

    private long storeRaw(long position, byte[] bytes, PageIO ... pageIos) {
        if (bytes != null) {
            int pageNb = this.computePageNb(position);
            ByteBuffer pageData = pageIos[pageNb].getData();
            int pagePos = (int)(position + (long)((pageNb + 1) * 8) + 4L) - pageNb * this.pageSize;
            int remaining = pageData.capacity() - pagePos;
            int nbStored = bytes.length;
            while (nbStored > 0) {
                if (remaining > nbStored) {
                    pageData.mark();
                    pageData.position(pagePos);
                    pageData.put(bytes, bytes.length - nbStored, nbStored);
                    pageData.reset();
                    nbStored = 0;
                    continue;
                }
                pageData.mark();
                pageData.position(pagePos);
                pageData.put(bytes, bytes.length - nbStored, remaining);
                pageData.reset();
                if (++pageNb == pageIos.length) break;
                pageData = pageIos[pageNb].getData();
                pagePos = 8;
                nbStored -= remaining;
                remaining = pageData.capacity() - pagePos;
            }
            position += (long)bytes.length;
        } else {
            position = this.store(position, 0, pageIos);
        }
        return position;
    }

    private long store(long position, int value, PageIO ... pageIos) {
        int pageNb = this.computePageNb(position);
        int pagePos = (int)(position + (long)((pageNb + 1) * 8) + 4L) - pageNb * this.pageSize;
        ByteBuffer pageData = pageIos[pageNb].getData();
        int remaining = pageData.capacity() - pagePos;
        if (remaining < 4) {
            switch (remaining) {
                case 3: {
                    pageData.put(pagePos + 2, (byte)(value >>> 8));
                }
                case 2: {
                    pageData.put(pagePos + 1, (byte)(value >>> 16));
                }
                case 1: {
                    pageData.put(pagePos, (byte)(value >>> 24));
                }
            }
            pageData = pageIos[pageNb + 1].getData();
            pagePos = 8;
            switch (remaining) {
                case 1: {
                    pageData.put(pagePos, (byte)(value >>> 16));
                }
                case 2: {
                    pageData.put(pagePos + 2 - remaining, (byte)(value >>> 8));
                }
                case 3: {
                    pageData.put(pagePos + 3 - remaining, (byte)value);
                }
            }
        } else {
            pageData.putInt(pagePos, value);
        }
        return position += 4L;
    }

    private long store(long position, long value, PageIO ... pageIos) {
        int pageNb = this.computePageNb(position);
        int pagePos = (int)(position + (long)((pageNb + 1) * 8) + 4L) - pageNb * this.pageSize;
        ByteBuffer pageData = pageIos[pageNb].getData();
        int remaining = pageData.capacity() - pagePos;
        if (remaining < 8) {
            switch (remaining) {
                case 7: {
                    pageData.put(pagePos + 6, (byte)(value >>> 8));
                }
                case 6: {
                    pageData.put(pagePos + 5, (byte)(value >>> 16));
                }
                case 5: {
                    pageData.put(pagePos + 4, (byte)(value >>> 24));
                }
                case 4: {
                    pageData.put(pagePos + 3, (byte)(value >>> 32));
                }
                case 3: {
                    pageData.put(pagePos + 2, (byte)(value >>> 40));
                }
                case 2: {
                    pageData.put(pagePos + 1, (byte)(value >>> 48));
                }
                case 1: {
                    pageData.put(pagePos, (byte)(value >>> 56));
                }
            }
            pageData = pageIos[pageNb + 1].getData();
            pagePos = 8;
            switch (remaining) {
                case 1: {
                    pageData.put(pagePos, (byte)(value >>> 48));
                }
                case 2: {
                    pageData.put(pagePos + 2 - remaining, (byte)(value >>> 40));
                }
                case 3: {
                    pageData.put(pagePos + 3 - remaining, (byte)(value >>> 32));
                }
                case 4: {
                    pageData.put(pagePos + 4 - remaining, (byte)(value >>> 24));
                }
                case 5: {
                    pageData.put(pagePos + 5 - remaining, (byte)(value >>> 16));
                }
                case 6: {
                    pageData.put(pagePos + 6 - remaining, (byte)(value >>> 8));
                }
                case 7: {
                    pageData.put(pagePos + 7 - remaining, (byte)value);
                }
            }
        } else {
            pageData.putLong(pagePos, value);
        }
        return position += 8L;
    }

    <K, V> PageHolder<K, V> writePage(BTree<K, V> btree, Page<K, V> newPage, long newRevision) throws IOException {
        PageIO[] pageIos = this.serializePage(btree, newRevision, newPage);
        LOG.debug("Write data for '{}' btree ", (Object)btree.getName());
        this.flushPages(pageIos);
        long offset = pageIos[0].getOffset();
        long lastOffset = pageIos[pageIos.length - 1].getOffset();
        PersistedPageHolder<K, V> pageHolder = new PersistedPageHolder<K, V>(btree, newPage, offset, lastOffset);
        if (LOG_CHECK.isDebugEnabled()) {
            this.check();
        }
        return pageHolder;
    }

    private int computeNbPages(int dataSize) {
        if (dataSize <= 0) {
            return 0;
        }
        int availableSize = this.pageSize - 8;
        int nbNeededPages = 1;
        if (dataSize > availableSize - 4) {
            int remainingSize = dataSize - (availableSize - 4);
            nbNeededPages += remainingSize / availableSize;
            int remain = remainingSize % availableSize;
            if (remain > 0) {
                ++nbNeededPages;
            }
        }
        return nbNeededPages;
    }

    private PageIO[] getFreePageIOs(int dataSize) throws IOException {
        if (dataSize == 0) {
            return new PageIO[0];
        }
        int nbNeededPages = this.computeNbPages(dataSize);
        PageIO[] pageIOs = new PageIO[nbNeededPages];
        pageIOs[0] = this.fetchNewPage();
        pageIOs[0].setSize(dataSize);
        for (int i = 1; i < nbNeededPages; ++i) {
            pageIOs[i] = this.fetchNewPage();
            pageIOs[i - 1].setNextPage(pageIOs[i].getOffset());
        }
        return pageIOs;
    }

    private PageIO fetchNewPage() throws IOException {
        if (this.firstFreePage == -1L) {
            this.nbCreatedPages.incrementAndGet();
            PageIO newPage = new PageIO(this.endOfFileOffset);
            this.endOfFileOffset += (long)this.pageSize;
            ByteBuffer data = ByteBuffer.allocateDirect(this.pageSize);
            newPage.setData(data);
            newPage.setNextPage(-1L);
            newPage.setSize(0);
            LOG.debug("Requiring a new page at offset {}", (Object)newPage.getOffset());
            return newPage;
        }
        this.nbReusedPages.incrementAndGet();
        PageIO pageIo = this.fetchPage(this.firstFreePage);
        this.firstFreePage = pageIo.getNextPage();
        ByteBuffer data = ByteBuffer.allocateDirect(this.pageSize);
        pageIo.setData(data);
        pageIo.setNextPage(-1L);
        pageIo.setSize(0);
        LOG.debug("Reused page at offset {}", (Object)pageIo.getOffset());
        return pageIo;
    }

    private PageIO fetchPage(long offset) throws IOException, EndOfFileExceededException {
        if (this.fileChannel.size() < offset + (long)this.pageSize) {
            throw new EndOfFileExceededException("We are fetching a page on " + offset + " when the file's size is " + this.fileChannel.size());
        }
        this.fileChannel.position(offset);
        ByteBuffer data = ByteBuffer.allocate(this.pageSize);
        this.fileChannel.read(data);
        data.rewind();
        PageIO readPage = new PageIO(offset);
        readPage.setData(data);
        return readPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (this.pageSize == -1) {
            this.pageSize = pageSize;
        }
    }

    public void close() throws IOException {
        for (BTree<Object, Object> tree : this.managedBTrees.values()) {
            tree.close();
        }
        this.managedBTrees.clear();
        this.fileChannel.force(true);
        this.fileChannel.close();
    }

    public static String dump(byte octet) {
        return new String(new byte[]{HEX_CHAR[(octet & 0xF0) >> 4], HEX_CHAR[octet & 0xF]});
    }

    private void dump(PageIO pageIo) {
        ByteBuffer buffer = pageIo.getData();
        buffer.mark();
        byte[] longBuffer = new byte[8];
        byte[] intBuffer = new byte[4];
        buffer.get(longBuffer);
        long nextOffset = LongSerializer.deserialize(longBuffer);
        buffer.get(intBuffer);
        int size = IntSerializer.deserialize(intBuffer);
        buffer.reset();
        System.out.println("PageIO[" + Long.toHexString(pageIo.getOffset()) + "], size = " + size + ", NEXT PageIO:" + Long.toHexString(nextOffset));
        System.out.println(" 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F ");
        System.out.println("+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+");
        int position = buffer.position();
        for (int i = 0; i < buffer.limit(); i += 16) {
            System.out.print("|");
            for (int j = 0; j < 16; ++j) {
                System.out.print(RecordManager.dump(buffer.get()));
                if (j == 15) {
                    System.out.println("|");
                    continue;
                }
                System.out.print(" ");
            }
        }
        System.out.println("+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+");
        buffer.reset();
    }

    public void dump() throws IOException {
        RandomAccessFile randomFile = new RandomAccessFile(this.file, "r");
        FileChannel fileChannel = randomFile.getChannel();
        ByteBuffer header = ByteBuffer.allocate(HEADER_SIZE);
        fileChannel.read(header);
        header.rewind();
        int pageSize = header.getInt();
        int nbBTree = header.getInt();
        long firstFreePage = header.getLong();
        if (LOG.isDebugEnabled()) {
            LOG.debug("RecordManager");
            LOG.debug("-------------");
            LOG.debug("  Header ");
            LOG.debug("    '{}'", (Object)Strings.dumpBytes(header.array()));
            LOG.debug("    page size : {}", (Object)pageSize);
            LOG.debug("    nbTree : {}", (Object)nbBTree);
            LOG.debug("    firstFreePage : {}", (Object)firstFreePage);
        }
        long position = HEADER_SIZE;
        for (int i = 0; i < nbBTree; ++i) {
            PageIO[] pageIos;
            LOG.debug("  Btree[{}]", (Object)i);
            for (PageIO pageIo : pageIos = this.readPageIOs(position, Long.MAX_VALUE)) {
                LOG.debug("    {}", (Object)pageIo);
            }
        }
        randomFile.close();
    }

    public int getNbManagedTrees() {
        return this.nbBtree - 2;
    }

    public Set<String> getManagedTrees() {
        HashSet<String> btrees = new HashSet<String>(this.managedBTrees.keySet());
        btrees.remove(COPIED_PAGE_BTREE_NAME);
        btrees.remove(REVISION_BTREE_NAME);
        return btrees;
    }

    <K, V> void storeRootPage(BTree<K, V> btree, Page<K, V> rootPage) throws IOException {
        if (!this.isKeepRevisions()) {
            return;
        }
        if (btree == this.copiedPageBTree || btree == this.revisionBTree) {
            return;
        }
        RevisionName revisionName = new RevisionName(rootPage.getRevision(), btree.getName());
        ((AbstractBTree)this.revisionBTree).insert(revisionName, ((AbstractPage)rootPage).getOffset(), 0L);
        if (LOG_CHECK.isDebugEnabled()) {
            this.check();
        }
    }

    <K, V> Page<K, V> getRootPage(BTree<K, V> btree, long revision) throws KeyNotFoundException, IOException {
        if (btree.getRevision() == revision) {
            return btree.getRootPage();
        }
        RevisionName revisionName = new RevisionName(revision, btree.getName());
        long rootPageOffset = this.revisionBTree.get(revisionName);
        PageIO[] rootPageIos = this.readPageIOs(rootPageOffset, Long.MAX_VALUE);
        Page<K, V> btreeRoot = this.readPage(btree, rootPageIos);
        return btreeRoot;
    }

    public <K, V> BTree<K, V> getManagedTree(String name) {
        return this.managedBTrees.get(name);
    }

    <K, V> void addFreePages(BTree<K, V> btree, List<Page<K, V>> pages) throws EndOfFileExceededException, IOException {
        if (btree == this.copiedPageBTree || btree == this.revisionBTree) {
            return;
        }
        if (pages == null || pages.isEmpty()) {
            return;
        }
        if (!this.keepRevisions) {
            for (Page<K, V> page : pages) {
                long firstOffset = ((AbstractPage)page).getOffset();
                if (firstOffset == -1L) continue;
                long lastOffset = ((AbstractPage)page).getLastOffset();
                if (this.firstFreePage == -1L) {
                    this.firstFreePage = firstOffset;
                    continue;
                }
                long offset = ((AbstractPage)page).getLastOffset();
                if (offset == -1L) {
                    offset = ((AbstractPage)page).getOffset();
                }
                PageIO pageIo = this.fetchPage(offset);
                pageIo.setNextPage(this.firstFreePage);
                LOG.debug("Flushing the first free page");
                this.flushPages(pageIo);
                this.firstFreePage = firstOffset;
            }
        } else {
            LOG.debug("We should not get there");
            for (Page<K, V> p : pages) {
                this.addFreePage(btree, p);
            }
        }
    }

    private <K, V> void addFreePage(BTree<K, V> btree, Page<K, V> freePage) {
        try {
            RevisionName revision = new RevisionName(freePage.getRevision(), btree.getName());
            long[] offsetArray = null;
            if (this.copiedPageBTree.hasKey(revision)) {
                offsetArray = this.copiedPageBTree.get(revision);
                long[] tmp = new long[offsetArray.length + 1];
                System.arraycopy(offsetArray, 0, tmp, 0, offsetArray.length);
                offsetArray = tmp;
            } else {
                offsetArray = new long[1];
            }
            offsetArray[offsetArray.length - 1] = ((AbstractPage)freePage).getOffset();
            ((AbstractBTree)this.copiedPageBTree).insert(revision, offsetArray, 0L);
        }
        catch (Exception e) {
            throw new FreePageException(e);
        }
    }

    public boolean isKeepRevisions() {
        return this.keepRevisions;
    }

    public void setKeepRevisions(boolean keepRevisions) {
        this.keepRevisions = keepRevisions;
    }

    public <K, V> BTree<K, V> addBTree(String name, ElementSerializer<K> keySerializer, ElementSerializer<V> valueSerializer, boolean allowDuplicates) throws IOException, BTreeAlreadyManagedException {
        PersistedBTreeConfiguration<K, V> config = new PersistedBTreeConfiguration<K, V>();
        config.setName(name);
        config.setKeySerializer(keySerializer);
        config.setValueSerializer(valueSerializer);
        config.setAllowDuplicates(allowDuplicates);
        PersistedBTree btree = new PersistedBTree(config);
        this.manage(btree);
        if (LOG_CHECK.isDebugEnabled()) {
            this.check();
        }
        return btree;
    }

    private void setCheckedPage(long[] checkedPages, long offset, int pageSize) {
        long pageOffset = (offset - (long)HEADER_SIZE) / (long)pageSize;
        int index = (int)(pageOffset / 64L);
        long bits = checkedPages[index];
        long mask = 1L << (int)(pageOffset % 64L);
        if ((bits & mask) == 1L) {
            throw new RecordManagerException("The page at : " + offset + " has already been checked");
        }
        int n = index;
        checkedPages[n] = checkedPages[n] | mask;
    }

    private void checkFreePages(long[] checkedPages, int pageSize, long firstFreePage) throws IOException {
        if (firstFreePage == -1L) {
            return;
        }
        long currentOffset = firstFreePage;
        long fileSize = this.fileChannel.size();
        while (currentOffset != -1L) {
            if (currentOffset > fileSize) {
                throw new FreePageException("Wrong free page offset, above file size : " + currentOffset);
            }
            try {
                long newOffset;
                PageIO pageIo = this.fetchPage(currentOffset);
                if (currentOffset != pageIo.getOffset()) {
                    throw new InvalidBTreeException("PageIO offset is incorrect : " + currentOffset + "-" + pageIo.getOffset());
                }
                this.setCheckedPage(checkedPages, currentOffset, pageSize);
                currentOffset = newOffset = pageIo.getNextPage();
            }
            catch (IOException ioe) {
                throw new InvalidBTreeException("Cannot fetch page at : " + currentOffset);
            }
        }
    }

    private void checkRoot(long[] checkedPages, long offset, int pageSize, long nbBTreeElems, ElementSerializer keySerializer, ElementSerializer valueSerializer, boolean allowDuplicates) throws EndOfFileExceededException, IOException {
        PageIO[] rootPageIos = this.readPageIOs(offset, Long.MAX_VALUE);
        long position = 0L;
        long revision = this.readLong(rootPageIos, position);
        int nbElems = this.readInt(rootPageIos, position += 8L);
        ByteBuffer byteBuffer = null;
        ByteBuffer data = this.readBytes(rootPageIos, position += 4L);
        if (nbElems >= 0) {
            long pageOffset = rootPageIos[0].getOffset();
            if (pageOffset < 0L || pageOffset > this.fileChannel.size()) {
                throw new InvalidBTreeException("The page offset is incorrect : " + pageOffset);
            }
            long pageLastOffset = rootPageIos[rootPageIos.length - 1].getOffset();
            if (pageLastOffset <= 0L || pageLastOffset > this.fileChannel.size()) {
                throw new InvalidBTreeException("The page last offset is incorrect : " + pageLastOffset);
            }
            for (int i = 0; i < nbElems; ++i) {
                if (!allowDuplicates) {
                    valueSerializer.deserialize(byteBuffer);
                }
                keySerializer.deserialize(byteBuffer);
            }
        }
    }

    private long checkBTree(long[] checkedPages, PageIO[] pageIos, int pageSize, boolean isLast) throws EndOfFileExceededException, IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        long dataPos = 0L;
        long revision = this.readLong(pageIos, dataPos);
        long nbElems = this.readLong(pageIos, dataPos += 8L);
        long rootPageOffset = this.readLong(pageIos, dataPos += 8L);
        if (rootPageOffset < 0L || rootPageOffset > this.fileChannel.size()) {
            throw new InvalidBTreeException("The rootpage is incorrect : " + rootPageOffset);
        }
        long nextBTreeOffset = this.readLong(pageIos, dataPos += 8L);
        if (rootPageOffset < 0L && !isLast || nextBTreeOffset > this.fileChannel.size()) {
            throw new InvalidBTreeException("The rootpage is incorrect : " + rootPageOffset);
        }
        int btreePageSize = this.readInt(pageIos, dataPos += 8L);
        if (btreePageSize < 2 || (btreePageSize & ~btreePageSize + 1) != btreePageSize) {
            throw new InvalidBTreeException("The BTree page size is not a power of 2 : " + btreePageSize);
        }
        ByteBuffer btreeNameBytes = this.readBytes(pageIos, dataPos += 4L);
        dataPos += 4L;
        String btreeName = Strings.utf8ToString(btreeNameBytes);
        ByteBuffer keySerializerBytes = this.readBytes(pageIos, dataPos += (long)btreeNameBytes.limit());
        String keySerializerFqcn = null;
        dataPos += 4L;
        if (keySerializerBytes != null) {
            dataPos += (long)keySerializerBytes.limit();
            keySerializerFqcn = Strings.utf8ToString(keySerializerBytes);
        } else {
            keySerializerFqcn = "";
        }
        ByteBuffer valueSerializerBytes = this.readBytes(pageIos, dataPos);
        String valueSerializerFqcn = null;
        dataPos += 4L;
        if (valueSerializerBytes != null) {
            dataPos += (long)valueSerializerBytes.limit();
            valueSerializerFqcn = Strings.utf8ToString(valueSerializerBytes);
        } else {
            valueSerializerFqcn = "";
        }
        int allowDuplicates = this.readInt(pageIos, dataPos);
        dataPos += 4L;
        Class<?> valueSerializer = Class.forName(valueSerializerFqcn);
        Class<?> keySerializer = Class.forName(keySerializerFqcn);
        return nextBTreeOffset;
    }

    private void checkBTrees(long[] checkedPages, int pageSize, int nbBTrees) throws EndOfFileExceededException, IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        long position = HEADER_SIZE;
        for (int i = 0; i < nbBTrees; ++i) {
            PageIO[] pageIos = this.readPageIOs(position, Long.MAX_VALUE);
            int pageNb = 0;
            for (PageIO currentPageIo : pageIos) {
                long nextPageOffset = currentPageIo.getNextPage();
                if (pageNb == pageIos.length - 1) {
                    if (nextPageOffset != -1L) {
                        throw new InvalidBTreeException("The pointer to the next page is not valid, expected NO_PAGE");
                    }
                } else if (nextPageOffset == -1L) {
                    throw new InvalidBTreeException("The pointer to the next page is not valid, NO_PAGE");
                }
                if (nextPageOffset != -1L && (nextPageOffset - (long)HEADER_SIZE) % (long)pageSize != 0L) {
                    throw new InvalidBTreeException("The pointer to the next page is not valid");
                }
                this.setCheckedPage(checkedPages, currentPageIo.getOffset(), pageSize);
            }
            long nextBTree = this.checkBTree(checkedPages, pageIos, pageSize, i == nbBTrees - 1);
            if (nextBTree == -1L && i < nbBTrees - 1) {
                throw new InvalidBTreeException("The pointer to the next BTree is incorrect");
            }
            position = nextBTree;
        }
    }

    private void check() {
        try {
            ByteBuffer header = ByteBuffer.allocate(HEADER_SIZE);
            long fileSize = this.fileChannel.size();
            if (fileSize < (long)HEADER_SIZE) {
                throw new InvalidBTreeException("File size too small : " + fileSize);
            }
            this.fileChannel.read(header, 0L);
            header.flip();
            int pageSize = header.getInt();
            if (pageSize < 0 || pageSize < 32 || (pageSize & ~pageSize + 1) != pageSize) {
                throw new InvalidBTreeException("Wrong page size : " + pageSize);
            }
            long nbPages = (fileSize - (long)HEADER_SIZE) / (long)pageSize;
            int nbBTrees = header.getInt();
            if (nbBTrees < 0) {
                throw new InvalidBTreeException("Wrong nb trees : " + nbBTrees);
            }
            long firstFreePage = header.getLong();
            if (firstFreePage > fileSize) {
                throw new InvalidBTreeException("First free page pointing after the end of the file : " + firstFreePage);
            }
            if (firstFreePage != -1L && (firstFreePage - (long)HEADER_SIZE) % (long)pageSize != 0L) {
                throw new InvalidBTreeException("First free page not pointing to a correct offset : " + firstFreePage);
            }
            int nbPageBits = (int)(nbPages / 64L);
            long[] checkedPages = new long[nbPageBits + 1];
            this.checkFreePages(checkedPages, pageSize, firstFreePage);
            this.checkBTrees(checkedPages, pageSize, nbBTrees);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidBTreeException("Error : " + e.getMessage());
        }
    }

    <K, V> BTree<K, V> loadDupsBTree(long offset) {
        try {
            PageIO[] pageIos = this.readPageIOs(offset, Long.MAX_VALUE);
            BTree subBtree = BTreeFactory.createPersistedBTree();
            ((PersistedBTree)subBtree).setBtreeOffset(offset);
            this.loadBTree(pageIos, subBtree);
            return subBtree;
        }
        catch (Exception e) {
            throw new BTreeCreationException(e);
        }
    }

    <K, V> Map<Page<?, ?>, BTree<?, ?>> getPendingPages() {
        return this.pendingPages;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RM free pages : [");
        if (this.firstFreePage != -1L) {
            long current = this.firstFreePage;
            boolean isFirst = true;
            while (current != -1L) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                try {
                    PageIO pageIo = this.fetchPage(current);
                    sb.append(pageIo.getOffset());
                    current = pageIo.getNextPage();
                }
                catch (EndOfFileExceededException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        sb.append("]");
        return sb.toString();
    }

    static {
        LONG_LENGTH = new byte[]{-1, -1, -1, -8};
        OFFSET_SERIALIZER = new LongSerializer();
        HEX_CHAR = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    }
}

