/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import org.apache.directory.mavibot.btree.KeyHolder;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;

class PersistedKeyHolder<K>
extends KeyHolder<K> {
    private byte[] raw;
    private ElementSerializer<K> keySerializer;

    PersistedKeyHolder(ElementSerializer<K> keySerializer, K key) {
        super(key);
        this.keySerializer = keySerializer;
        this.raw = keySerializer.serialize(key);
    }

    PersistedKeyHolder(ElementSerializer<K> keySerializer, byte[] raw) {
        super(null);
        this.keySerializer = keySerializer;
        this.raw = raw;
    }

    @Override
    K getKey() {
        if (this.key == null) {
            try {
                this.key = this.keySerializer.fromBytes(this.raw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return (K)this.key;
    }

    @Override
    void setKey(K key) {
        this.key = key;
        this.raw = this.keySerializer.serialize(key);
    }

    byte[] getRaw() {
        return this.raw;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PersistedKeyHolder[");
        if (this.key != null) {
            sb.append(this.key);
            sb.append(", ");
        } else {
            sb.append("null,");
        }
        if (this.raw != null) {
            sb.append(this.raw.length);
        } else {
            sb.append("null");
        }
        sb.append("]");
        return sb.toString();
    }
}

