/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Comparator;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.ValueArrayCursor;
import org.apache.directory.mavibot.btree.ValueBTreeCursor;
import org.apache.directory.mavibot.btree.ValueCursor;
import org.apache.directory.mavibot.btree.ValueHolder;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;

abstract class AbstractValueHolder<V>
implements ValueHolder<V> {
    protected BTree<V, V> valueBtree;
    protected V[] valueArray;
    protected ElementSerializer<V> valueSerializer;
    protected int valueThresholdUp = 1;
    protected int valueThresholdLow = 1;
    protected int nbArrayElems;

    AbstractValueHolder() {
    }

    @Override
    public boolean isSubBtree() {
        return this.valueBtree != null;
    }

    @Override
    public ValueHolder<V> clone() throws CloneNotSupportedException {
        ValueHolder copy = (ValueHolder)super.clone();
        return copy;
    }

    @Override
    public ValueCursor<V> getCursor() {
        if (this.valueBtree != null) {
            return new ValueBTreeCursor<V>(this.valueBtree);
        }
        return new ValueArrayCursor<V>(this.valueArray);
    }

    private int findPos(V value) {
        int result;
        if (this.valueArray.length == 0) {
            return -1;
        }
        int pivot = this.valueArray.length / 2;
        int low = 0;
        int high = this.valueArray.length - 1;
        Comparator<V> comparator = this.valueSerializer.getComparator();
        while (high > low) {
            switch (high - low) {
                case 1: {
                    result = comparator.compare(value, this.valueArray[pivot]);
                    if (result == 0) {
                        return pivot;
                    }
                    if (result < 0) {
                        if (pivot == low) {
                            return -(low + 1);
                        }
                        result = comparator.compare(value, this.valueArray[low]);
                        if (result == 0) {
                            return low;
                        }
                        if (result < 0) {
                            return -(low + 1);
                        }
                        return -(low + 2);
                    }
                    if (pivot == high) {
                        return -(high + 2);
                    }
                    result = comparator.compare(value, this.valueArray[high]);
                    if (result == 0) {
                        return high;
                    }
                    if (result < 0) {
                        return -(high + 1);
                    }
                    return -(high + 2);
                }
            }
            result = comparator.compare(value, this.valueArray[pivot]);
            if (result == 0) {
                return pivot;
            }
            if (result < 0) {
                high = pivot - 1;
            } else {
                low = pivot + 1;
            }
            pivot = (high + low) / 2;
        }
        result = comparator.compare(value, this.valueArray[pivot]);
        if (result == 0) {
            return pivot;
        }
        if (result < 0) {
            return -(pivot + 1);
        }
        return -(pivot + 2);
    }

    private boolean arrayContains(V value) {
        if (this.valueArray.length == 0) {
            return false;
        }
        return this.findPos(value) >= 0;
    }

    protected boolean btreeContains(V value) {
        try {
            return this.valueBtree.hasKey(value);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean contains(V checkedValue) {
        if (this.valueArray == null) {
            return this.btreeContains(checkedValue);
        }
        return this.arrayContains(checkedValue);
    }

    protected abstract void createSubTree();

    private void addInArray(V value) {
        if (this.size() >= this.valueThresholdUp) {
            this.createSubTree();
            try {
                for (V val : this.valueArray) {
                    this.valueBtree.insert(val, null);
                }
                this.nbArrayElems = 0;
                this.valueArray = null;
                this.valueBtree.insert(value, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (this.valueArray == null) {
            this.valueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), 1);
            this.nbArrayElems = 1;
            this.valueArray[0] = value;
        } else {
            int pos = this.findPos(value);
            if (pos >= 0) {
                return;
            }
            pos = -(pos + 1);
            Object[] newValueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), this.valueArray.length + 1);
            System.arraycopy(this.valueArray, 0, newValueArray, 0, pos);
            newValueArray[pos] = value;
            System.arraycopy(this.valueArray, pos, newValueArray, pos + 1, this.valueArray.length - pos);
            this.valueArray = newValueArray;
        }
    }

    private void addInBtree(V value) {
        try {
            this.valueBtree.insert(value, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void add(V value) {
        if (this.valueBtree == null) {
            this.addInArray(value);
        } else {
            this.addInBtree(value);
        }
    }
}

