/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.IOException;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.Cursor;
import org.apache.directory.server.i18n.I18n;

public class ValueTreeCursor<V>
extends AbstractCursor<V> {
    private Cursor<V, V> wrapped;
    private V available;
    private V NOT_AVAILABLE = new Object();

    public ValueTreeCursor(BTree<V, V> dupsTree) {
        try {
            this.wrapped = dupsTree.browse();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean available() {
        return this.available != this.NOT_AVAILABLE;
    }

    @Override
    public void before(V element) throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    @Override
    public void after(V element) throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        try {
            if (this.wrapped.hasPrev()) {
                this.available = this.wrapped.prev().getKey();
                return true;
            }
            this.available = this.NOT_AVAILABLE;
            return false;
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        try {
            if (this.wrapped.hasNext()) {
                this.available = this.wrapped.next().getKey();
                return true;
            }
            this.available = this.NOT_AVAILABLE;
            return false;
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
    }

    @Override
    public V get() throws CursorException {
        return this.available;
    }
}

