/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.subtree;

import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.subtree.Subentry;
import org.apache.directory.api.ldap.model.subtree.SubtreeSpecification;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.subtree.SubentryCache;
import org.apache.directory.server.core.api.subtree.SubtreeEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubentryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SubentryUtils.class);
    protected DirectoryService directoryService;
    protected SchemaManager schemaManager;
    protected static AttributeType ACCESS_CONTROL_SUBENTRIES_AT;
    protected static AttributeType COLLECTIVE_ATTRIBUTE_SUBENTRIES_AT;
    protected static AttributeType SUBSCHEMA_SUBENTRY_AT;
    protected static AttributeType TRIGGER_EXECUTION_SUBENTRIES_AT;

    public SubentryUtils(DirectoryService directoryService) {
        this.directoryService = directoryService;
        this.schemaManager = directoryService.getSchemaManager();
        ACCESS_CONTROL_SUBENTRIES_AT = this.schemaManager.getAttributeType("accessControlSubentries");
        COLLECTIVE_ATTRIBUTE_SUBENTRIES_AT = this.schemaManager.getAttributeType("collectiveAttributeSubentries");
        SUBSCHEMA_SUBENTRY_AT = this.schemaManager.getAttributeType("subschemaSubentry");
        TRIGGER_EXECUTION_SUBENTRIES_AT = this.schemaManager.getAttributeType("triggerExecutionSubentries");
    }

    public Entry getSubentryAttributes(Dn dn, Entry entryAttrs) throws LdapException {
        DefaultEntry subentryAttrs = new DefaultEntry(this.schemaManager, dn);
        SubentryCache subentryCache = this.directoryService.getSubentryCache();
        SubtreeEvaluator evaluator = this.directoryService.getEvaluator();
        for (Dn subentryDn : subentryCache) {
            Attribute operational;
            Dn apDn = subentryDn.getParent();
            Subentry subentry = subentryCache.getSubentry(subentryDn);
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            if (!evaluator.evaluate(ss, apDn, dn, entryAttrs)) continue;
            if (subentry.isAccessControlAdminRole()) {
                operational = subentryAttrs.get(ACCESS_CONTROL_SUBENTRIES_AT);
                if (operational == null) {
                    operational = new DefaultAttribute(ACCESS_CONTROL_SUBENTRIES_AT);
                    subentryAttrs.put(operational);
                }
                operational.add(subentryDn.getNormName());
            }
            if (subentry.isSchemaAdminRole()) {
                operational = subentryAttrs.get(SUBSCHEMA_SUBENTRY_AT);
                if (operational == null) {
                    operational = new DefaultAttribute(SUBSCHEMA_SUBENTRY_AT);
                    subentryAttrs.put(operational);
                }
                operational.add(subentryDn.getNormName());
            }
            if (subentry.isCollectiveAdminRole()) {
                operational = subentryAttrs.get(COLLECTIVE_ATTRIBUTE_SUBENTRIES_AT);
                if (operational == null) {
                    operational = new DefaultAttribute(COLLECTIVE_ATTRIBUTE_SUBENTRIES_AT);
                    subentryAttrs.put(operational);
                }
                operational.add(subentryDn.getNormName());
            }
            if (!subentry.isTriggersAdminRole()) continue;
            operational = subentryAttrs.get(TRIGGER_EXECUTION_SUBENTRIES_AT);
            if (operational == null) {
                operational = new DefaultAttribute(TRIGGER_EXECUTION_SUBENTRIES_AT);
                subentryAttrs.put(operational);
            }
            operational.add(subentryDn.getNormName());
        }
        return subentryAttrs;
    }
}

