/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthorizationInterceptor.class);
    private static Dn ADMIN_SYSTEM_DN;
    private static Dn GROUPS_BASE_DN;
    private static Dn USERS_BASE_DN;
    private static Dn ADMIN_GROUP_DN;
    private Set<String> administrators = new HashSet<String>(2);
    private PartitionNexus nexus;

    public DefaultAuthorizationInterceptor() {
        super(InterceptorEnum.DEFAULT_AUTHORIZATION_INTERCEPTOR);
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        this.nexus = directoryService.getPartitionNexus();
        ADMIN_SYSTEM_DN = directoryService.getDnFactory().create("uid=admin,ou=system");
        GROUPS_BASE_DN = directoryService.getDnFactory().create("ou=groups,ou=system");
        USERS_BASE_DN = directoryService.getDnFactory().create("ou=users,ou=system");
        ADMIN_GROUP_DN = directoryService.getDnFactory().create("cn=Administrators,ou=groups,ou=system");
        this.loadAdministrators(directoryService);
    }

    private void loadAdministrators(DirectoryService directoryService) throws LdapException {
        HashSet<String> newAdministrators = new HashSet<String>(2);
        CoreSession adminSession = directoryService.getAdminSession();
        Entry adminGroup = this.nexus.lookup(new LookupOperationContext(adminSession, ADMIN_GROUP_DN));
        if (adminGroup == null) {
            return;
        }
        Attribute uniqueMember = adminGroup.get(UNIQUE_MEMBER_AT);
        for (Value value : uniqueMember) {
            Dn memberDn = directoryService.getDnFactory().create(value.getString());
            newAdministrators.add(memberDn.getNormName());
        }
        this.administrators = newAdministrators;
    }

    @Override
    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        if (deleteContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            this.next(deleteContext);
            return;
        }
        Dn dn = deleteContext.getDn();
        if (dn.isEmpty()) {
            String msg = I18n.err(I18n.ERR_12, new Object[0]);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.equals(ADMIN_GROUP_DN)) {
            String msg = I18n.err(I18n.ERR_13, new Object[0]);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        Dn principalDn = DefaultAuthorizationInterceptor.getPrincipal(deleteContext).getDn();
        if (dn.equals(ADMIN_SYSTEM_DN)) {
            String msg = I18n.err(I18n.ERR_14, principalDn.getName());
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.size() > 2 && !this.isAnAdministrator(principalDn)) {
            if (dn.isDescendantOf(ADMIN_SYSTEM_DN)) {
                String msg = I18n.err(I18n.ERR_15, principalDn.getName(), dn.getName());
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
            if (dn.isDescendantOf(GROUPS_BASE_DN)) {
                String msg = I18n.err(I18n.ERR_16, principalDn.getName(), dn.getName());
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
            if (dn.isDescendantOf(USERS_BASE_DN)) {
                String msg = I18n.err(I18n.ERR_16, principalDn.getName(), dn.getName());
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
        }
        this.next(deleteContext);
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        CoreSession session = lookupContext.getSession();
        Entry entry = this.next(lookupContext);
        if (session.getDirectoryService().isAccessControlEnabled()) {
            return entry;
        }
        this.protectLookUp(session.getEffectivePrincipal().getDn(), lookupContext.getDn());
        return entry;
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        if (!modifyContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            Dn dn = modifyContext.getDn();
            this.protectModifyAlterations(modifyContext, dn);
            this.next(modifyContext);
            if (dn.equals(ADMIN_GROUP_DN)) {
                this.loadAdministrators(modifyContext.getSession().getDirectoryService());
            }
        } else {
            this.next(modifyContext);
        }
    }

    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        if (!moveContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            this.protectDnAlterations(moveContext, moveContext.getDn());
        }
        this.next(moveContext);
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        if (!moveAndRenameContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            this.protectDnAlterations(moveAndRenameContext, moveAndRenameContext.getDn());
        }
        this.next(moveAndRenameContext);
    }

    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        if (!renameContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            this.protectDnAlterations(renameContext, renameContext.getDn());
        }
        this.next(renameContext);
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        EntryFilteringCursor cursor = this.next(searchContext);
        if (searchContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            return cursor;
        }
        cursor.addEntryFilter(new DefaultAuthorizationSearchFilter());
        return cursor;
    }

    private boolean isTheAdministrator(Dn dn) {
        return dn.equals(ADMIN_SYSTEM_DN);
    }

    private boolean isAnAdministrator(Dn dn) {
        return this.isTheAdministrator(dn) || this.administrators.contains(dn.getNormName());
    }

    private void protectModifyAlterations(OperationContext opCtx, Dn dn) throws LdapException {
        Dn principalDn = DefaultAuthorizationInterceptor.getPrincipal(opCtx).getDn();
        if (dn.isEmpty()) {
            String msg = I18n.err(I18n.ERR_17, new Object[0]);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (!this.isAnAdministrator(principalDn)) {
            if (dn.equals(DefaultAuthorizationInterceptor.getPrincipal(opCtx).getDn())) {
                return;
            }
            if (dn.equals(ADMIN_SYSTEM_DN)) {
                String msg = I18n.err(I18n.ERR_18, principalDn.getName());
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
            if (dn.size() > 2) {
                if (dn.isDescendantOf(ADMIN_SYSTEM_DN)) {
                    String msg = I18n.err(I18n.ERR_19, principalDn.getName(), dn.getName());
                    LOG.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
                if (dn.isDescendantOf(GROUPS_BASE_DN)) {
                    String msg = I18n.err(I18n.ERR_20, principalDn.getName(), dn.getName());
                    LOG.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
                if (dn.isDescendantOf(USERS_BASE_DN)) {
                    String msg = I18n.err(I18n.ERR_20, principalDn.getName(), dn.getName());
                    LOG.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
            }
        }
    }

    private void protectDnAlterations(OperationContext opCtx, Dn dn) throws LdapException {
        Dn principalDn = DefaultAuthorizationInterceptor.getPrincipal(opCtx).getDn();
        if (dn.isEmpty()) {
            String msg = I18n.err(I18n.ERR_234, new Object[0]);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.equals(ADMIN_GROUP_DN)) {
            String msg = I18n.err(I18n.ERR_21, new Object[0]);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (this.isTheAdministrator(dn)) {
            String msg = I18n.err(I18n.ERR_22, principalDn.getName(), dn.getName());
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.size() > 2 && !this.isAnAdministrator(principalDn)) {
            if (dn.isDescendantOf(ADMIN_SYSTEM_DN)) {
                String msg = I18n.err(I18n.ERR_23, principalDn.getName(), dn.getName());
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
            if (dn.isDescendantOf(GROUPS_BASE_DN)) {
                String msg = I18n.err(I18n.ERR_24, principalDn.getName(), dn.getName());
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
            if (dn.isDescendantOf(USERS_BASE_DN)) {
                String msg = I18n.err(I18n.ERR_24, principalDn.getName(), dn.getName());
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
        }
    }

    private void protectLookUp(Dn principalDn, Dn normalizedDn) throws LdapException {
        if (!this.isAnAdministrator(principalDn)) {
            if (normalizedDn.size() > 2) {
                if (normalizedDn.isDescendantOf(ADMIN_SYSTEM_DN)) {
                    if (normalizedDn.getNormName().equals(principalDn.getNormName())) {
                        return;
                    }
                    String msg = I18n.err(I18n.ERR_25, normalizedDn.getName(), principalDn.getName());
                    LOG.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
                if (normalizedDn.isDescendantOf(GROUPS_BASE_DN) || normalizedDn.isDescendantOf(USERS_BASE_DN)) {
                    if (normalizedDn.equals(principalDn)) {
                        return;
                    }
                    String msg = I18n.err(I18n.ERR_26, normalizedDn.getName(), principalDn.getName());
                    LOG.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
            }
            if (this.isTheAdministrator(normalizedDn)) {
                if (normalizedDn.getNormName().equals(principalDn.getNormName())) {
                    return;
                }
                String msg = I18n.err(I18n.ERR_27, principalDn.getName());
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
        }
    }

    private boolean isSearchable(OperationContext opContext, Entry entry) throws LdapException {
        Dn principalDn = opContext.getSession().getEffectivePrincipal().getDn();
        Dn dn = entry.getDn();
        dn.apply(opContext.getSession().getDirectoryService().getSchemaManager());
        if (this.isAnAdministrator(principalDn)) {
            return true;
        }
        boolean isSelfRead = dn.equals(principalDn);
        if (isSelfRead) {
            return true;
        }
        if (dn.size() >= 2 && (dn.isDescendantOf(ADMIN_SYSTEM_DN) || dn.isDescendantOf(GROUPS_BASE_DN) || dn.isDescendantOf(USERS_BASE_DN))) {
            return false;
        }
        return !this.isTheAdministrator(dn);
    }

    private class DefaultAuthorizationSearchFilter
    implements EntryFilter {
        private DefaultAuthorizationSearchFilter() {
        }

        @Override
        public boolean accept(SearchOperationContext operation, Entry entry) throws LdapException {
            return DefaultAuthorizationInterceptor.this.isSearchable(operation, entry);
        }

        @Override
        public String toString(String tabs) {
            return tabs + "DefaultAuthorizationSearchFilter";
        }
    }
}

