/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.protocol.mina;

import java.nio.ByteBuffer;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.codec.api.LdapEncoder;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.util.Strings;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapProtocolEncoder
implements ProtocolEncoder {
    private static final Logger CODEC_LOG = LoggerFactory.getLogger(Loggers.CODEC_LOG.getName());
    private static final boolean IS_DEBUG = CODEC_LOG.isDebugEnabled();
    private LdapEncoder encoder = new LdapEncoder(LdapApiServiceFactory.getSingleton());

    @Override
    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        ByteBuffer buffer = this.encoder.encodeMessage((Message)message);
        IoBuffer ioBuffer = IoBuffer.wrap(buffer);
        if (IS_DEBUG) {
            byte[] dumpBuffer = new byte[buffer.limit()];
            buffer.get(dumpBuffer);
            buffer.flip();
            CODEC_LOG.debug("Encoded message \n " + message + "\n : " + Strings.dumpBytes(dumpBuffer));
        }
        out.write(ioBuffer);
    }

    @Override
    public void dispose(IoSession session) throws Exception {
    }
}

