/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.ComparableComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableComparator<E>
extends LdapComparator<E>
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String matchingRuleOid;
    private transient Comparator<E> wrapped;
    private transient SchemaManager schemaManager;

    public SerializableComparator(String matchingRuleOid) {
        super(matchingRuleOid);
        this.matchingRuleOid = matchingRuleOid;
    }

    @Override
    public int compare(E o1, E o2) {
        if (this.wrapped == null) {
            try {
                this.wrapped = this.schemaManager.lookupComparatorRegistry(this.matchingRuleOid);
            }
            catch (LdapException e) {
                throw new RuntimeException(I18n.err(I18n.ERR_04221, this.matchingRuleOid));
            }
        }
        return this.wrapped.compare(o1, o2);
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        if (this.wrapped == null) {
            try {
                this.wrapped = schemaManager.lookupComparatorRegistry(this.matchingRuleOid);
            }
            catch (LdapException ne) {
                this.wrapped = new ComparableComparator<E>(this.matchingRuleOid);
            }
        }
        ((LdapComparator)this.wrapped).setSchemaManager(schemaManager);
        super.setSchemaManager(schemaManager);
        this.schemaManager = schemaManager;
    }
}

