/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.api.ldap.model.exception.MessageException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.DeleteRequest;
import org.apache.directory.api.ldap.model.message.DeleteResponse;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteRequestDecorator
extends SingleReplyRequestDecorator<DeleteRequest, DeleteResponse>
implements DeleteRequest {
    private byte[] dnBytes;

    public DeleteRequestDecorator(LdapApiService codec, DeleteRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    @Override
    public Dn getName() {
        return ((DeleteRequest)this.getDecorated()).getName();
    }

    @Override
    public DeleteRequest setName(Dn name) {
        ((DeleteRequest)this.getDecorated()).setName(name);
        return this;
    }

    @Override
    public DeleteRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public DeleteRequest addControl(Control control) throws MessageException {
        return (DeleteRequest)super.addControl(control);
    }

    @Override
    public DeleteRequest addAllControls(Control[] controls) throws MessageException {
        return (DeleteRequest)super.addAllControls(controls);
    }

    @Override
    public DeleteRequest removeControl(Control control) throws MessageException {
        return (DeleteRequest)super.removeControl(control);
    }

    @Override
    public int computeLength() {
        this.dnBytes = Strings.getBytesUtf8(this.getName().getName());
        int dnLength = this.dnBytes.length;
        return 1 + TLV.getNbBytes(dnLength) + dnLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)74);
            buffer.put(TLV.getBytes(this.dnBytes.length));
            buffer.put(this.dnBytes);
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        return buffer;
    }
}

