/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.request;

import java.util.Map;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.StringConstants;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapProtocolUtils;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.server.ldap.handlers.bind.MechanismHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindRequestHandler
extends LdapRequestHandler<BindRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(BindRequestHandler.class);
    private Map<String, MechanismHandler> handlers;

    public void setSaslMechanismHandlers(Map<String, MechanismHandler> handlers) {
        this.handlers = handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSimpleAuth(LdapSession ldapSession, BindRequest bindRequest) throws Exception {
        DirectoryService directoryService = this.ldapServer.getDirectoryService();
        if (ldapSession.isAuthenticated()) {
            ldapSession.getCoreSession().unbind();
        }
        ldapSession.setSimpleAuthPending();
        BindOperationContext bindContext = new BindOperationContext(null);
        bindContext.setDn(bindRequest.getDn());
        bindContext.setCredentials(bindRequest.getCredentials());
        bindContext.setIoSession(ldapSession.getIoSession());
        bindContext.setInterceptors(directoryService.getInterceptors(OperationEnum.BIND));
        LdapProtocolUtils.setRequestControls(bindContext, bindRequest);
        try {
            Entry principalEntry = null;
            try {
                principalEntry = directoryService.getAdminSession().lookup(bindRequest.getDn(), new String[0]);
            }
            catch (LdapException le) {
                // empty catch block
            }
            if (principalEntry == null) {
                LOG.info("The {} principalDN cannot be found in the server : bind failure.", (Object)bindRequest.getName());
            } else if (((ClonedServerEntry)principalEntry).getOriginalEntry().contains("objectClass", "referral")) {
                LOG.info("Bind principalDn points to referral.");
                LdapResult result = ((BindResponse)bindRequest.getResultResponse()).getLdapResult();
                result.setDiagnosticMessage("Bind principalDn points to referral.");
                result.setResultCode(ResultCodeEnum.INVALID_CREDENTIALS);
                ldapSession.getIoSession().write(bindRequest.getResultResponse());
                return;
            }
            bindContext.setInterceptors(directoryService.getInterceptors(OperationEnum.BIND));
            directoryService.getOperationManager().bind(bindContext);
            ldapSession.setCoreSession(bindContext.getSession());
            if (!ldapSession.getCoreSession().isAnonymous()) {
                ldapSession.setAuthenticated();
            } else {
                ldapSession.setAnonymous();
            }
            ((BindResponse)bindRequest.getResultResponse()).addAllControls(bindContext.getResponseControls());
            this.sendBindSuccess(ldapSession, bindRequest, null);
        }
        catch (Exception e) {
            ResultCodeEnum code = null;
            LdapResult result = ((BindResponse)bindRequest.getResultResponse()).getLdapResult();
            if (e instanceof LdapUnwillingToPerformException) {
                code = ResultCodeEnum.UNWILLING_TO_PERFORM;
                result.setResultCode(code);
            } else if (e instanceof LdapInvalidDnException) {
                code = ResultCodeEnum.INVALID_DN_SYNTAX;
                result.setResultCode(code);
            } else {
                code = ResultCodeEnum.INVALID_CREDENTIALS;
                result.setResultCode(code);
            }
            String msg = code.toString() + ": Bind failed: " + e.getLocalizedMessage();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace(e);
                msg = msg + "\n\nBindRequest = \n" + bindRequest.toString();
            }
            Dn dn = null;
            if (e instanceof LdapAuthenticationException) {
                dn = ((LdapAuthenticationException)e).getResolvedDn();
            }
            if (dn != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn(dn);
            }
            result.setDiagnosticMessage(msg);
            ((BindResponse)bindRequest.getResultResponse()).addAllControls(bindContext.getResponseControls());
            ldapSession.getIoSession().write(bindRequest.getResultResponse());
        }
        finally {
            if (!ldapSession.isAuthenticated()) {
                ldapSession.setAnonymous();
            }
        }
    }

    private boolean checkMechanism(String saslMechanism) throws Exception {
        if (!this.ldapServer.getSupportedMechanisms().contains(saslMechanism)) {
            LOG.error(I18n.err(I18n.ERR_160, saslMechanism));
            return false;
        }
        return true;
    }

    private void generateSaslChallengeOrComplete(LdapSession ldapSession, SaslServer ss, BindRequest bindRequest) throws Exception {
        LdapResult result = ((BindResponse)bindRequest.getResultResponse()).getLdapResult();
        if (bindRequest.getCredentials() == null) {
            bindRequest.setCredentials(StringConstants.EMPTY_BYTES);
        }
        try {
            byte[] tokenBytes = ss.evaluateResponse(bindRequest.getCredentials());
            if (ss.isComplete()) {
                LdapPrincipal ldapPrincipal;
                if (tokenBytes != null) {
                    ldapSession.putSaslProperty("saslCreds", tokenBytes);
                }
                if ((ldapPrincipal = (LdapPrincipal)ldapSession.getSaslProperty("saslAuthentUser")) != null) {
                    DirectoryService ds = ldapSession.getLdapServer().getDirectoryService();
                    String saslMechanism = bindRequest.getSaslMechanism();
                    CoreSession userSession = ds.getSession(ldapPrincipal.getDn(), ldapPrincipal.getUserPassword(), saslMechanism, null);
                    ldapSession.setCoreSession(userSession);
                }
                ldapSession.setAuthenticated();
                MechanismHandler handler = (MechanismHandler)ldapSession.getSaslProperty("saslmechHandler");
                handler.cleanup(ldapSession);
                this.sendBindSuccess(ldapSession, bindRequest, tokenBytes);
            } else {
                LOG.info("Continuation token had length " + tokenBytes.length);
                result.setResultCode(ResultCodeEnum.SASL_BIND_IN_PROGRESS);
                BindResponse resp = (BindResponse)bindRequest.getResultResponse();
                resp.setServerSaslCreds(tokenBytes);
                ldapSession.setSaslAuthPending();
                ldapSession.getIoSession().write(resp);
                LOG.debug("Returning final authentication data to client to complete context.");
            }
        }
        catch (SaslException se) {
            this.sendInvalidCredentials(ldapSession, bindRequest, se);
        }
    }

    private void sendAuthMethNotSupported(LdapSession ldapSession, BindRequest bindRequest) {
        ldapSession.clearSaslProperties();
        ldapSession.setAnonymous();
        LdapResult bindResult = ((BindResponse)bindRequest.getResultResponse()).getLdapResult();
        bindResult.setResultCode(ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED);
        bindResult.setDiagnosticMessage(ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED.toString() + ": " + bindRequest.getSaslMechanism() + " is not a supported mechanism.");
        ldapSession.getIoSession().write(bindRequest.getResultResponse());
    }

    private void sendInvalidCredentials(LdapSession ldapSession, BindRequest bindRequest, Exception e) {
        LdapResult result = ((BindResponse)bindRequest.getResultResponse()).getLdapResult();
        String message = "";
        message = e != null ? (Object)((Object)ResultCodeEnum.INVALID_CREDENTIALS) + ": " + e.getLocalizedMessage() : ResultCodeEnum.INVALID_CREDENTIALS.toString();
        LOG.error(message);
        result.setResultCode(ResultCodeEnum.INVALID_CREDENTIALS);
        result.setDiagnosticMessage(message);
        ldapSession.clearSaslProperties();
        ldapSession.setAnonymous();
        ldapSession.getIoSession().write(bindRequest.getResultResponse());
    }

    private void sendBindSuccess(LdapSession ldapSession, BindRequest bindRequest, byte[] tokenBytes) {
        BindResponse response = (BindResponse)bindRequest.getResultResponse();
        response.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        response.setServerSaslCreds(tokenBytes);
        if (!ldapSession.getCoreSession().isAnonymous()) {
            ldapSession.setAuthenticated();
        } else {
            ldapSession.setAnonymous();
        }
        MechanismHandler handler = (MechanismHandler)ldapSession.getSaslProperty("saslmechHandler");
        if (handler != null) {
            handler.cleanup(ldapSession);
        }
        ldapSession.getIoSession().write(response);
        LOG.debug("Returned SUCCESS message: {}.", (Object)response);
    }

    private void handleSaslAuthPending(LdapSession ldapSession, BindRequest bindRequest) throws Exception {
        String saslMechanism = bindRequest.getSaslMechanism();
        if (Strings.isEmpty(saslMechanism) || !ldapSession.getSaslProperty("saslMech").equals(saslMechanism)) {
            this.sendAuthMethNotSupported(ldapSession, bindRequest);
            return;
        }
        MechanismHandler mechanismHandler = this.handlers.get(saslMechanism);
        if (mechanismHandler == null) {
            String message = I18n.err(I18n.ERR_161, saslMechanism);
            ldapSession.clearSaslProperties();
            ldapSession.setAnonymous();
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        SaslServer ss = mechanismHandler.handleMechanism(ldapSession, bindRequest);
        this.generateSaslChallengeOrComplete(ldapSession, ss, bindRequest);
    }

    public void handleSaslAuth(LdapSession ldapSession, BindRequest bindRequest) throws Exception {
        String saslMechanism = bindRequest.getSaslMechanism();
        if (ldapSession.isAuthenticated()) {
            ldapSession.getCoreSession().unbind();
            ldapSession.setAnonymous();
            ldapSession.clearSaslProperties();
        }
        if (ldapSession.isAnonymous()) {
            if (!this.checkMechanism(saslMechanism)) {
                this.sendAuthMethNotSupported(ldapSession, bindRequest);
                return;
            }
            ldapSession.putSaslProperty("saslMech", saslMechanism);
            MechanismHandler mechanismHandler = this.handlers.get(saslMechanism);
            ldapSession.putSaslProperty("saslmechHandler", mechanismHandler);
            mechanismHandler.init(ldapSession);
            SaslServer ss = mechanismHandler.handleMechanism(ldapSession, bindRequest);
            this.generateSaslChallengeOrComplete(ldapSession, ss, bindRequest);
            return;
        }
        if (ldapSession.isAuthPending()) {
            try {
                this.handleSaslAuthPending(ldapSession, bindRequest);
            }
            catch (SaslException se) {
                this.sendInvalidCredentials(ldapSession, bindRequest, se);
            }
            return;
        }
    }

    @Override
    public void handle(LdapSession ldapSession, BindRequest bindRequest) throws Exception {
        LOG.debug("Received: {}", (Object)bindRequest);
        if (!bindRequest.getVersion3()) {
            LOG.error(I18n.err(I18n.ERR_162, new Object[0]));
            LdapResult bindResult = ((BindResponse)bindRequest.getResultResponse()).getLdapResult();
            bindResult.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            bindResult.setDiagnosticMessage(I18n.err(I18n.ERR_163, new Object[0]));
            ldapSession.getIoSession().write(bindRequest.getResultResponse());
            return;
        }
        if (bindRequest.isSimple()) {
            this.handleSimpleAuth(ldapSession, bindRequest);
        } else {
            this.handleSaslAuth(ldapSession, bindRequest);
        }
    }
}

