/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.parsers;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.TokenStreamRecognitionException;
import java.text.ParseException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.api.ldap.model.schema.parsers.AbstractSchemaParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeTypeDescriptionSchemaParser
extends AbstractSchemaParser {
    protected static final Logger LOG = LoggerFactory.getLogger(AttributeTypeDescriptionSchemaParser.class);

    public synchronized AttributeType parseAttributeTypeDescription(String attributeTypeDescription) throws ParseException {
        LOG.debug("Parsing an AttributeType : {}", (Object)attributeTypeDescription);
        if (attributeTypeDescription == null) {
            LOG.error(I18n.err(I18n.ERR_04227, new Object[0]));
            throw new ParseException("Null", 0);
        }
        this.reset(attributeTypeDescription);
        try {
            MutableAttributeType attributeType = this.parser.attributeTypeDescription();
            AttributeTypeDescriptionSchemaParser.updateSchemaName(attributeType);
            return attributeType;
        }
        catch (RecognitionException re) {
            String msg = I18n.err(I18n.ERR_04228, attributeTypeDescription, re.getMessage(), re.getColumn());
            LOG.error(msg);
            throw new ParseException(msg, re.getColumn());
        }
        catch (TokenStreamRecognitionException tsre) {
            String msg = I18n.err(I18n.ERR_04229, attributeTypeDescription, tsre.getMessage());
            LOG.error(msg);
            throw new ParseException(msg, 0);
        }
        catch (TokenStreamException tse) {
            String msg = I18n.err(I18n.ERR_04229, attributeTypeDescription, tse.getMessage());
            LOG.error(msg);
            throw new ParseException(msg, 0);
        }
    }

    public AttributeType parse(String schemaDescription) throws ParseException {
        return this.parseAttributeTypeDescription(schemaDescription);
    }
}

