/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.normalizers;

import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnNormalizer
extends Normalizer {
    private static final long serialVersionUID = 1L;
    private SchemaManager schemaManager;

    public DnNormalizer() {
        super("2.5.13.1");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapException {
        DN dn = null;
        String dnStr = value.getString();
        dn = new DN(dnStr);
        dn.normalize(this.schemaManager.getNormalizerMapping());
        return new StringValue(dn.getNormName());
    }

    @Override
    public String normalize(String value) throws LdapException {
        DN dn = null;
        dn = new DN(value);
        dn.normalize(this.schemaManager.getNormalizerMapping());
        return dn.getNormName();
    }

    public String normalize(DN value) throws LdapException {
        DN dn = null;
        dn = new DN(value);
        dn.normalize(this.schemaManager.getNormalizerMapping());
        return dn.getNormName();
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }
}

