/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.ldap.entry.BinaryValue;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.name.AVA;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AVASerializer {
    protected static final Logger LOG = LoggerFactory.getLogger(AVASerializer.class);

    public static void serialize(AVA atav, ObjectOutput out) throws IOException {
        if (StringTools.isEmpty(atav.getUpName()) || StringTools.isEmpty(atav.getUpType()) || StringTools.isEmpty(atav.getNormType()) || atav.getStart() < 0 || atav.getLength() < 2 || atav.getUpValue().isNull() || atav.getNormValue().isNull()) {
            String message = "Cannot serialize an wrong ATAV, ";
            if (StringTools.isEmpty(atav.getUpName())) {
                message = message + "the upName should not be null or empty";
            } else if (StringTools.isEmpty(atav.getUpType())) {
                message = message + "the upType should not be null or empty";
            } else if (StringTools.isEmpty(atav.getNormType())) {
                message = message + "the normType should not be null or empty";
            } else if (atav.getStart() < 0) {
                message = message + "the start should not be < 0";
            } else if (atav.getLength() < 2) {
                message = message + "the length should not be < 2";
            } else if (atav.getUpValue().isNull()) {
                message = message + "the upValue should not be null";
            } else if (atav.getNormValue().isNull()) {
                message = message + "the value should not be null";
            }
            LOG.error(message);
            throw new IOException(message);
        }
        out.writeUTF(atav.getUpName());
        out.writeInt(atav.getStart());
        out.writeInt(atav.getLength());
        out.writeUTF(atav.getUpType());
        out.writeUTF(atav.getNormType());
        boolean isHR = !atav.getNormValue().isBinary();
        out.writeBoolean(isHR);
        if (isHR) {
            out.writeUTF(atav.getUpValue().getString());
            out.writeUTF(atav.getNormValue().getString());
        } else {
            out.writeInt(atav.getUpValue().length());
            out.write(atav.getUpValue().getBytes());
            out.writeInt(atav.getNormValue().length());
            out.write(atav.getNormValue().getBytes());
        }
    }

    public static AVA deserialize(ObjectInput in) throws IOException {
        String upName = in.readUTF();
        int start = in.readInt();
        int length = in.readInt();
        String upType = in.readUTF();
        String normType = in.readUTF();
        boolean isHR = in.readBoolean();
        try {
            if (isHR) {
                StringValue upValue = new StringValue(in.readUTF());
                StringValue normValue = new StringValue(in.readUTF());
                AVA atav = new AVA(upType, normType, upValue, normValue, upName);
                return atav;
            }
            int upValueLength = in.readInt();
            byte[] upValue = new byte[upValueLength];
            in.readFully(upValue);
            int valueLength = in.readInt();
            byte[] normValue = new byte[valueLength];
            in.readFully(normValue);
            AVA atav = new AVA(upType, normType, new BinaryValue(upValue), new BinaryValue(normValue), upName);
            return atav;
        }
        catch (LdapInvalidDnException ine) {
            throw new IOException(ine.getMessage());
        }
    }
}

