/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.ldif;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.ldif.ChangeType;
import org.apache.directory.shared.ldap.ldif.LdapLdifException;
import org.apache.directory.shared.ldap.ldif.LdifControl;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.DnParser;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.util.Base64;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifReader
implements Iterable<LdifEntry>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(LdifReader.class);
    protected List<String> lines;
    protected Position position;
    protected static final int DEFAULT_VERSION = 1;
    protected int version;
    protected static final int LDIF_ENTRY = 0;
    protected static final int CHANGE = 1;
    protected static final int UNKNOWN = 2;
    protected long sizeLimit = 1024000L;
    protected static final long SIZE_LIMIT_DEFAULT = 1024000L;
    protected static final int MOD_SPEC = 0;
    protected static final int ATTRVAL_SPEC = 1;
    protected static final int ATTRVAL_SPEC_OR_SEP = 2;
    protected LdifEntry prefetched;
    protected Reader reader;
    protected boolean containsEntries;
    protected boolean containsChanges;
    protected Exception error;

    public LdifReader() {
        this.lines = new ArrayList<String>();
        this.position = new Position();
        this.version = 1;
    }

    private void init(BufferedReader reader) throws LdapLdifException, LdapException {
        this.reader = reader;
        this.lines = new ArrayList<String>();
        this.position = new Position();
        this.version = 1;
        this.containsChanges = false;
        this.containsEntries = false;
        this.version = this.parseVersion();
        this.prefetched = this.parseEntry();
    }

    public LdifReader(String ldifFileName) throws LdapLdifException {
        File file = new File(ldifFileName);
        if (!file.exists()) {
            LOG.error(I18n.err("ERR_12010", file.getAbsoluteFile()));
            throw new LdapLdifException(I18n.err("ERR_12010", file.getAbsoluteFile()));
        }
        if (!file.canRead()) {
            LOG.error(I18n.err("ERR_12011", file.getName()));
            throw new LdapLdifException(I18n.err("ERR_12011", file.getName()));
        }
        try {
            this.init(new BufferedReader(new FileReader(file)));
        }
        catch (FileNotFoundException fnfe) {
            LOG.error(I18n.err("ERR_12010", file.getAbsoluteFile()));
            throw new LdapLdifException(I18n.err("ERR_12010", file.getAbsoluteFile()));
        }
        catch (LdapInvalidDnException lide) {
            throw new LdapLdifException(lide.getMessage());
        }
        catch (LdapException le) {
            throw new LdapLdifException(le.getMessage());
        }
    }

    public LdifReader(Reader in) throws LdapLdifException, LdapException {
        this.init(new BufferedReader(in));
    }

    public LdifReader(InputStream in) throws LdapLdifException, LdapException {
        this.init(new BufferedReader(new InputStreamReader(in)));
    }

    public LdifReader(File file) throws LdapLdifException {
        if (!file.exists()) {
            LOG.error(I18n.err("ERR_12010", file.getAbsoluteFile()));
            throw new LdapLdifException(I18n.err("ERR_12010", file.getAbsoluteFile()));
        }
        if (!file.canRead()) {
            LOG.error(I18n.err("ERR_12011", file.getName()));
            throw new LdapLdifException(I18n.err("ERR_12011", file.getName()));
        }
        try {
            this.init(new BufferedReader(new FileReader(file)));
        }
        catch (FileNotFoundException fnfe) {
            LOG.error(I18n.err("ERR_12010", file.getAbsoluteFile()));
            throw new LdapLdifException(I18n.err("ERR_12010", file.getAbsoluteFile()));
        }
        catch (LdapInvalidDnException lide) {
            throw new LdapLdifException(lide.getMessage());
        }
        catch (LdapException le) {
            throw new LdapLdifException(le.getMessage());
        }
    }

    public int getVersion() {
        return this.version;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(long sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    private static void parseFill(char[] document, Position position) {
        while (StringTools.isCharASCII(document, position.pos, ' ')) {
            position.inc();
        }
    }

    private static String parseNumber(char[] document, Position position) {
        int initPos = position.pos;
        while (StringTools.isDigit(document, position.pos)) {
            position.inc();
        }
        if (position.pos == initPos) {
            return null;
        }
        return new String(document, initPos, position.pos - initPos);
    }

    private ChangeType parseChangeType(String line) {
        ChangeType operation = ChangeType.Add;
        String modOp = StringTools.trim(line.substring("changetype:".length() + 1));
        if ("add".equalsIgnoreCase(modOp)) {
            operation = ChangeType.Add;
        } else if ("delete".equalsIgnoreCase(modOp)) {
            operation = ChangeType.Delete;
        } else if ("modify".equalsIgnoreCase(modOp)) {
            operation = ChangeType.Modify;
        } else if ("moddn".equalsIgnoreCase(modOp)) {
            operation = ChangeType.ModDn;
        } else if ("modrdn".equalsIgnoreCase(modOp)) {
            operation = ChangeType.ModRdn;
        }
        return operation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parseDn(String line) throws LdapLdifException {
        String dn = null;
        String lowerLine = line.toLowerCase();
        if (!lowerLine.startsWith("dn:") && !lowerLine.startsWith("DN:")) {
            LOG.error(I18n.err("ERR_12016", new Object[0]));
            throw new LdapLdifException(I18n.err("ERR_12013", new Object[0]));
        }
        int length = line.length();
        if (length == 3) {
            LOG.error(I18n.err("ERR_12012", new Object[0]));
            throw new LdapLdifException(I18n.err("ERR_12013", new Object[0]));
        }
        if (line.charAt(3) == ':') {
            if (length <= 4) {
                LOG.error(I18n.err("ERR_12012", new Object[0]));
                throw new LdapLdifException(I18n.err("ERR_12013", new Object[0]));
            }
            String trimmedLine = line.substring(4).trim();
            try {
                dn = new String(Base64.decode(trimmedLine.toCharArray()), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                LOG.error(I18n.err("ERR_12014", new Object[0]));
                throw new LdapLdifException(I18n.err("ERR_12015", new Object[0]));
            }
        } else {
            dn = line.substring(3).trim();
        }
        try {
            DnParser.parseInternal(dn, new ArrayList<RDN>());
            return dn;
        }
        catch (LdapInvalidDnException ine) {
            LOG.error(I18n.err("ERR_12017", dn));
            throw new LdapLdifException(ine.getMessage());
        }
    }

    protected static Object parseSimpleValue(String line, int pos) {
        if (line.length() > pos + 1) {
            char c = line.charAt(pos + 1);
            if (c == ':') {
                String value = StringTools.trim(line.substring(pos + 2));
                return Base64.decode(value.toCharArray());
            }
            return StringTools.trim(line.substring(pos + 1));
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object parseValue(String line, int pos) throws LdapLdifException {
        if (line.length() <= pos + 1) return null;
        char c = line.charAt(pos + 1);
        if (c == ':') {
            String value = StringTools.trim(line.substring(pos + 2));
            return Base64.decode(value.toCharArray());
        }
        if (c != '<') return StringTools.trim(line.substring(pos + 1));
        String urlName = StringTools.trim(line.substring(pos + 2));
        try {
            byte[] byArray;
            URL url = new URL(urlName);
            if (!"file".equals(url.getProtocol())) {
                LOG.error(I18n.err("ERR_12025", new Object[0]));
                throw new LdapLdifException(I18n.err("ERR_12026", new Object[0]));
            }
            String fileName = url.getFile();
            File file = new File(fileName);
            if (!file.exists()) {
                LOG.error(I18n.err("ERR_12018", fileName));
                throw new LdapLdifException(I18n.err("ERR_12019", new Object[0]));
            }
            long length = file.length();
            if (length > this.sizeLimit) {
                LOG.error(I18n.err("ERR_12020", fileName));
                throw new LdapLdifException(I18n.err("ERR_12021", new Object[0]));
            }
            byte[] data = new byte[(int)length];
            FilterInputStream inf = null;
            try {
                inf = new DataInputStream(new FileInputStream(file));
                ((DataInputStream)inf).read(data);
                byArray = data;
            }
            catch (FileNotFoundException fnfe) {
                try {
                    LOG.error(I18n.err("ERR_12018", fileName));
                    throw new LdapLdifException(I18n.err("ERR_12019", new Object[0]));
                    catch (IOException ioe) {
                        LOG.error(I18n.err("ERR_12022", fileName));
                        throw new LdapLdifException(I18n.err("ERR_12023", new Object[0]));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        inf.close();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        LOG.error(I18n.err("ERR_12024", ioe.getMessage()));
                    }
                    throw throwable;
                }
            }
            try {
                inf.close();
                return byArray;
            }
            catch (IOException ioe) {
                LOG.error(I18n.err("ERR_12024", ioe.getMessage()));
            }
            return byArray;
        }
        catch (MalformedURLException mue) {
            LOG.error(I18n.err("ERR_12027", urlName));
            throw new LdapLdifException(I18n.err("ERR_12028", new Object[0]));
        }
    }

    private Control parseControl(String line) throws LdapLdifException {
        String lowerLine = line.toLowerCase().trim();
        int pos = 0;
        char[] controlValue = line.trim().toCharArray();
        int length = controlValue.length;
        if (pos > length) {
            LOG.error(I18n.err("ERR_12029", new Object[0]));
            throw new LdapLdifException(I18n.err("ERR_12030", new Object[0]));
        }
        int initPos = pos;
        while (StringTools.isCharASCII(controlValue, pos, '.') || StringTools.isDigit(controlValue, pos)) {
            ++pos;
        }
        if (pos == initPos) {
            LOG.error(I18n.err("ERR_12029", new Object[0]));
            throw new LdapLdifException(I18n.err("ERR_12030", new Object[0]));
        }
        String oidString = lowerLine.substring(0, pos);
        if (!OID.isOID(oidString)) {
            LOG.error(I18n.err("ERR_12031", oidString));
            throw new LdapLdifException(I18n.err("ERR_12032", new Object[0]));
        }
        LdifControl control = new LdifControl(oidString);
        while (StringTools.isCharASCII(controlValue, pos, ' ')) {
            ++pos;
        }
        int criticalPos = lowerLine.indexOf(58);
        int criticalLength = 0;
        criticalLength = criticalPos == -1 ? length - pos : criticalPos - pos;
        if (criticalLength == 4 && "true".equalsIgnoreCase(lowerLine.substring(pos, pos + 4))) {
            control.setCritical(true);
        } else if (criticalLength == 5 && "false".equalsIgnoreCase(lowerLine.substring(pos, pos + 5))) {
            control.setCritical(false);
        } else if (criticalLength != 0) {
            LOG.error(I18n.err("ERR_12033", new Object[0]));
            throw new LdapLdifException(I18n.err("ERR_12034", new Object[0]));
        }
        if (criticalPos > 0) {
            if (StringTools.isCharASCII(controlValue, criticalPos + 1, ':')) {
                byte[] value = Base64.decode(line.substring(criticalPos + 2).toCharArray());
                control.setValue(value);
            } else if (!StringTools.isCharASCII(controlValue, criticalPos + 1, '<')) {
                byte[] value = new byte[length - criticalPos - 1];
                for (int i = 0; i < length - criticalPos - 1; ++i) {
                    value[i] = (byte)controlValue[i + criticalPos + 1];
                }
                control.setValue(value);
            }
        }
        return control;
    }

    public static EntryAttribute parseAttributeValue(String line) {
        int colonIndex = line.indexOf(58);
        if (colonIndex != -1) {
            String attributeType = line.toLowerCase().substring(0, colonIndex);
            Object attributeValue = LdifReader.parseSimpleValue(line, colonIndex);
            if (attributeValue instanceof String) {
                return new DefaultClientAttribute(attributeType, (String)attributeValue);
            }
            return new DefaultClientAttribute(attributeType, new byte[][]{(byte[])attributeValue});
        }
        return null;
    }

    public void parseAttributeValue(LdifEntry entry, String line, String lowerLine) throws LdapLdifException, LdapException {
        int colonIndex = line.indexOf(58);
        String attributeType = lowerLine.substring(0, colonIndex);
        if (attributeType.equals("dn")) {
            LOG.error(I18n.err("ERR_12002", new Object[0]));
            throw new LdapLdifException(I18n.err("ERR_12003", new Object[0]));
        }
        Object attributeValue = this.parseValue(line, colonIndex);
        entry.addAttribute(attributeType, attributeValue);
    }

    private void parseModRdn(LdifEntry entry, Iterator<String> iter) throws LdapLdifException {
        String lowerLine;
        String line;
        if (iter.hasNext()) {
            line = iter.next();
            lowerLine = line.toLowerCase();
            if (!lowerLine.startsWith("newrdn::") && !lowerLine.startsWith("newrdn:")) {
                LOG.error(I18n.err("ERR_12035", new Object[0]));
                throw new LdapLdifException(I18n.err("ERR_12036", new Object[0]));
            }
        } else {
            LOG.error(I18n.err("ERR_12035", new Object[0]));
            throw new LdapLdifException(I18n.err("ERR_12037", new Object[0]));
        }
        int colonIndex = line.indexOf(58);
        Object attributeValue = this.parseValue(line, colonIndex);
        entry.setNewRdn(attributeValue instanceof String ? (String)attributeValue : StringTools.utf8ToString((byte[])attributeValue));
        if (iter.hasNext()) {
            line = iter.next();
            lowerLine = line.toLowerCase();
            if (!lowerLine.startsWith("deleteoldrdn:")) {
                LOG.error(I18n.err("ERR_12038", new Object[0]));
                throw new LdapLdifException(I18n.err("ERR_12039", new Object[0]));
            }
        } else {
            LOG.error(I18n.err("ERR_12038", new Object[0]));
            throw new LdapLdifException(I18n.err("ERR_12039", new Object[0]));
        }
        colonIndex = line.indexOf(58);
        attributeValue = this.parseValue(line, colonIndex);
        entry.setDeleteOldRdn("1".equals(attributeValue));
    }

    private void parseModify(LdifEntry entry, Iterator<String> iter) throws LdapLdifException {
        int state = 0;
        String modified = null;
        ModificationOperation modificationType = ModificationOperation.ADD_ATTRIBUTE;
        DefaultClientAttribute attribute = null;
        boolean isEmptyValue = true;
        while (iter.hasNext()) {
            String line = iter.next();
            String lowerLine = line.toLowerCase();
            if (lowerLine.startsWith("-")) {
                if (state != 2) {
                    LOG.error(I18n.err("ERR_12040", new Object[0]));
                    throw new LdapLdifException(I18n.err("ERR_12041", new Object[0]));
                }
                if (isEmptyValue) {
                    entry.addModificationItem(modificationType, modified, null);
                } else {
                    entry.addModificationItem(modificationType, attribute);
                }
                state = 0;
                isEmptyValue = true;
                continue;
            }
            if (lowerLine.startsWith("add:")) {
                if (state != 0 && state != 1) {
                    LOG.error(I18n.err("ERR_12042", new Object[0]));
                    throw new LdapLdifException(I18n.err("ERR_12043", new Object[0]));
                }
                modified = StringTools.trim(line.substring("add:".length()));
                modificationType = ModificationOperation.ADD_ATTRIBUTE;
                attribute = new DefaultClientAttribute(modified);
                state = 1;
                continue;
            }
            if (lowerLine.startsWith("delete:")) {
                if (state != 0 && state != 1) {
                    LOG.error(I18n.err("ERR_12042", new Object[0]));
                    throw new LdapLdifException(I18n.err("ERR_12043", new Object[0]));
                }
                modified = StringTools.trim(line.substring("delete:".length()));
                modificationType = ModificationOperation.REMOVE_ATTRIBUTE;
                attribute = new DefaultClientAttribute(modified);
                state = 2;
                continue;
            }
            if (lowerLine.startsWith("replace:")) {
                if (state != 0 && state != 1) {
                    LOG.error(I18n.err("ERR_12042", new Object[0]));
                    throw new LdapLdifException(I18n.err("ERR_12043", new Object[0]));
                }
                modified = StringTools.trim(line.substring("replace:".length()));
                modificationType = ModificationOperation.REPLACE_ATTRIBUTE;
                attribute = new DefaultClientAttribute(modified);
                state = 2;
                continue;
            }
            if (state != 1 && state != 2) {
                LOG.error(I18n.err("ERR_12040", new Object[0]));
                throw new LdapLdifException(I18n.err("ERR_12043", new Object[0]));
            }
            int colonIndex = line.indexOf(58);
            String attributeType = line.substring(0, colonIndex);
            if (!attributeType.equalsIgnoreCase(modified)) {
                LOG.error(I18n.err("ERR_12044", new Object[0]));
                throw new LdapLdifException(I18n.err("ERR_12045", new Object[0]));
            }
            if (attributeType.equalsIgnoreCase("dn")) {
                LOG.error(I18n.err("ERR_12002", new Object[0]));
                throw new LdapLdifException(I18n.err("ERR_12003", new Object[0]));
            }
            Object attributeValue = this.parseValue(line, colonIndex);
            if (attributeValue instanceof String) {
                attribute.add((String)attributeValue);
            } else {
                attribute.add(new byte[][]{(byte[])attributeValue});
            }
            isEmptyValue = false;
            state = 2;
        }
    }

    private void parseChange(LdifEntry entry, Iterator<String> iter, ChangeType operation) throws LdapLdifException, LdapException {
        entry.setChangeType(operation);
        switch (operation.getChangeType()) {
            case 4: {
                return;
            }
            case 0: {
                while (iter.hasNext()) {
                    String line = iter.next();
                    String lowerLine = line.toLowerCase();
                    this.parseAttributeValue(entry, line, lowerLine);
                }
                return;
            }
            case 1: {
                this.parseModify(entry, iter);
                return;
            }
            case 2: 
            case 3: {
                this.parseModRdn(entry, iter);
                if (iter.hasNext()) {
                    String line = iter.next();
                    String lowerLine = line.toLowerCase();
                    if (lowerLine.startsWith("newsuperior:")) {
                        int colonIndex = line.indexOf(58);
                        Object attributeValue = this.parseValue(line, colonIndex);
                        entry.setNewSuperior(attributeValue instanceof String ? (String)attributeValue : StringTools.utf8ToString((byte[])attributeValue));
                    } else if (operation == ChangeType.ModDn) {
                        LOG.error(I18n.err("ERR_12046", new Object[0]));
                        throw new LdapLdifException(I18n.err("ERR_12047", new Object[0]));
                    }
                } else if (operation == ChangeType.ModDn) {
                    LOG.error(I18n.err("ERR_12046", new Object[0]));
                    throw new LdapLdifException(I18n.err("ERR_12047", new Object[0]));
                }
                return;
            }
        }
        LOG.error(I18n.err("ERR_12048", new Object[0]));
        throw new LdapLdifException(I18n.err("ERR_12049", new Object[0]));
    }

    private LdifEntry parseEntry() throws LdapLdifException, LdapException {
        if (this.lines == null || this.lines.size() == 0) {
            LOG.debug("The entry is empty : end of ldif file");
            return null;
        }
        String line = this.lines.get(0);
        String name = this.parseDn(line);
        DN dn = new DN(name);
        LdifEntry entry = new LdifEntry();
        entry.setDn(dn);
        this.lines.remove(0);
        Iterator<String> iter = this.lines.iterator();
        int type = 2;
        boolean controlSeen = false;
        boolean changeTypeSeen = false;
        ChangeType operation = ChangeType.Add;
        String lowerLine = null;
        Control control = null;
        while (iter.hasNext()) {
            line = iter.next();
            lowerLine = line.toLowerCase();
            if (lowerLine.startsWith("control:")) {
                if (this.containsEntries) {
                    LOG.error(I18n.err("ERR_12004", new Object[0]));
                    throw new LdapLdifException(I18n.err("ERR_12005", new Object[0]));
                }
                this.containsChanges = true;
                if (controlSeen) {
                    LOG.error(I18n.err("ERR_12050", new Object[0]));
                    throw new LdapLdifException(I18n.err("ERR_12051", new Object[0]));
                }
                control = this.parseControl(line.substring("control:".length()));
                entry.setControl(control);
                continue;
            }
            if (lowerLine.startsWith("changetype:")) {
                if (this.containsEntries) {
                    LOG.error(I18n.err("ERR_12004", new Object[0]));
                    throw new LdapLdifException(I18n.err("ERR_12005", new Object[0]));
                }
                this.containsChanges = true;
                if (changeTypeSeen) {
                    LOG.error(I18n.err("ERR_12052", new Object[0]));
                    throw new LdapLdifException(I18n.err("ERR_12053", new Object[0]));
                }
                type = 1;
                controlSeen = true;
                operation = this.parseChangeType(line);
                this.parseChange(entry, iter, operation);
                changeTypeSeen = true;
                continue;
            }
            if (line.indexOf(58) > 0) {
                if (this.containsChanges) {
                    LOG.error(I18n.err("ERR_12004", new Object[0]));
                    throw new LdapLdifException(I18n.err("ERR_12005", new Object[0]));
                }
                this.containsEntries = true;
                if (controlSeen || changeTypeSeen) {
                    LOG.error(I18n.err("ERR_12054", new Object[0]));
                    throw new LdapLdifException(I18n.err("ERR_12055", new Object[0]));
                }
                this.parseAttributeValue(entry, line, lowerLine);
                type = 0;
                continue;
            }
            LOG.error(I18n.err("ERR_12056", new Object[0]));
            throw new LdapLdifException(I18n.err("ERR_12057", new Object[0]));
        }
        if (type == 0) {
            LOG.debug("Read an entry : {}", entry);
        } else if (type == 1) {
            entry.setChangeType(operation);
            LOG.debug("Read a modification : {}", entry);
        } else {
            LOG.error(I18n.err("ERR_12058", new Object[0]));
            throw new LdapLdifException(I18n.err("ERR_12059", new Object[0]));
        }
        return entry;
    }

    private int parseVersion() throws LdapLdifException {
        int ver = 1;
        this.readLines();
        if (this.lines.size() == 0) {
            LOG.warn("The ldif file is empty");
            return ver;
        }
        String line = this.lines.get(0);
        char[] document = line.toCharArray();
        String versionNumber = null;
        if (line.startsWith("version:")) {
            this.position.inc("version:".length());
            LdifReader.parseFill(document, this.position);
            versionNumber = LdifReader.parseNumber(document, this.position);
            if (this.position.pos != document.length) {
                LOG.error(I18n.err("ERR_12060", new Object[0]));
                throw new LdapLdifException(I18n.err("ERR_12061", new Object[0]));
            }
            try {
                ver = Integer.parseInt(versionNumber);
            }
            catch (NumberFormatException nfe) {
                LOG.error(I18n.err("ERR_12060", new Object[0]));
                throw new LdapLdifException(I18n.err("ERR_12061", new Object[0]));
            }
            LOG.debug("Ldif version : {}", (Object)versionNumber);
            this.lines.remove(0);
            if (this.lines.size() == 0) {
                this.readLines();
            }
        } else {
            LOG.warn("No version information : assuming version: 1");
        }
        return ver;
    }

    protected void readLines() throws LdapLdifException {
        String line = null;
        boolean insideComment = true;
        boolean isFirstLine = true;
        this.lines.clear();
        StringBuffer sb = new StringBuffer();
        try {
            block6: while ((line = ((BufferedReader)this.reader).readLine()) != null) {
                if (line.length() == 0) {
                    if (isFirstLine) continue;
                    insideComment = false;
                    break;
                }
                switch (line.charAt(0)) {
                    case '#': {
                        insideComment = true;
                        continue block6;
                    }
                    case ' ': {
                        isFirstLine = false;
                        if (insideComment) continue block6;
                        if (sb.length() == 0) {
                            LOG.error(I18n.err("ERR_12062", new Object[0]));
                            throw new LdapLdifException(I18n.err("ERR_12061", new Object[0]));
                        }
                        sb.append(line.substring(1));
                        insideComment = false;
                        continue block6;
                    }
                }
                isFirstLine = false;
                if (sb.length() != 0) {
                    this.lines.add(sb.toString());
                }
                sb = new StringBuffer(line);
                insideComment = false;
            }
        }
        catch (IOException ioe) {
            throw new LdapLdifException(I18n.err("ERR_12063", new Object[0]));
        }
        if (sb.length() != 0) {
            this.lines.add(sb.toString());
        }
    }

    public List<LdifEntry> parseLdifFile(String fileName) throws LdapLdifException {
        return this.parseLdifFile(fileName, Charset.forName(StringTools.getDefaultCharsetName()).toString());
    }

    public List<LdifEntry> parseLdifFile(String fileName, String encoding) throws LdapLdifException {
        if (StringTools.isEmpty(fileName)) {
            LOG.error(I18n.err("ERR_12064", new Object[0]));
            throw new LdapLdifException(I18n.err("ERR_12065", new Object[0]));
        }
        File file = new File(fileName);
        if (!file.exists()) {
            LOG.error(I18n.err("ERR_12066", fileName));
            throw new LdapLdifException(I18n.err("ERR_12067", fileName));
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName(encoding)));
            List<LdifEntry> list = this.parseLdif(reader);
            return list;
        }
        catch (FileNotFoundException fnfe) {
            LOG.error(I18n.err("ERR_12068", fileName));
            throw new LdapLdifException(I18n.err("ERR_12067", fileName));
        }
        catch (LdapException le) {
            le.printStackTrace();
            throw new LdapLdifException(le.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public List<LdifEntry> parseLdif(String ldif) throws LdapLdifException {
        LOG.debug("Starts parsing ldif buffer");
        if (StringTools.isEmpty(ldif)) {
            return new ArrayList<LdifEntry>();
        }
        BufferedReader reader = new BufferedReader(new StringReader(ldif));
        try {
            List<LdifEntry> entries = this.parseLdif(reader);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parsed {} entries.", entries == null ? Integer.valueOf(0) : Integer.valueOf(entries.size()));
            }
            List<LdifEntry> list = entries;
            return list;
        }
        catch (LdapLdifException ne) {
            LOG.error(I18n.err("ERR_12069", ne.getLocalizedMessage()));
            throw new LdapLdifException(I18n.err("ERR_12070", new Object[0]));
        }
        catch (LdapException le) {
            throw new LdapLdifException(le.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    private LdifEntry nextInternal() {
        try {
            LOG.debug("next(): -- called");
            LdifEntry entry = this.prefetched;
            this.readLines();
            try {
                this.prefetched = this.parseEntry();
            }
            catch (LdapLdifException ne) {
                this.error = ne;
                throw new NoSuchElementException(ne.getMessage());
            }
            catch (LdapException le) {
                throw new NoSuchElementException(le.getMessage());
            }
            LOG.debug("next(): -- returning ldif {}\n", entry);
            return entry;
        }
        catch (LdapLdifException ne) {
            LOG.error(I18n.err("ERR_12071", new Object[0]));
            this.error = ne;
            return null;
        }
    }

    public LdifEntry next() {
        return this.nextInternal();
    }

    private boolean hasNextInternal() {
        return null != this.prefetched;
    }

    public boolean hasNext() {
        LOG.debug("hasNext(): -- returning {}", this.prefetched != null ? Boolean.TRUE : Boolean.FALSE);
        return this.hasNextInternal();
    }

    private void removeInternal() {
        throw new UnsupportedOperationException();
    }

    public void remove() {
        this.removeInternal();
    }

    @Override
    public Iterator<LdifEntry> iterator() {
        return new Iterator<LdifEntry>(){

            @Override
            public boolean hasNext() {
                return LdifReader.this.hasNextInternal();
            }

            @Override
            public LdifEntry next() {
                return LdifReader.this.nextInternal();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean hasError() {
        return this.error != null;
    }

    public Exception getError() {
        return this.error;
    }

    public List<LdifEntry> parseLdif(BufferedReader reader) throws LdapLdifException, LdapException {
        ArrayList<LdifEntry> entries = new ArrayList<LdifEntry>();
        this.reader = reader;
        this.version = this.parseVersion();
        this.prefetched = this.parseEntry();
        try {
            for (LdifEntry entry : this) {
                if (entry == null) continue;
                entries.add(entry);
            }
        }
        catch (NoSuchElementException nsee) {
            throw new LdapLdifException(I18n.err("ERR_12072", this.error.getLocalizedMessage()));
        }
        return entries;
    }

    public boolean containsEntries() {
        return this.containsEntries;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.position = new Position();
            this.reader.close();
            this.containsEntries = false;
            this.containsChanges = false;
        }
    }

    public class Position {
        private int pos = 0;

        public void inc() {
            ++this.pos;
        }

        public void inc(int val) {
            this.pos += val;
        }
    }
}

