/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.messages.value.PrincipalName;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrincipalNameEncoder {
    private static final String COMPONENT_SEPARATOR = "/";
    private static final String REALM_SEPARATOR = "@";

    public static DERSequence encode(KerberosPrincipal principal) {
        DERSequence vector = new DERSequence();
        vector.add(new DERTaggedObject(0, DERInteger.valueOf(principal.getNameType())));
        vector.add(new DERTaggedObject(1, PrincipalNameEncoder.encodeNameSequence(principal)));
        return vector;
    }

    public static DERSequence encode(PrincipalName name) {
        DERSequence vector = new DERSequence();
        vector.add(new DERTaggedObject(0, DERInteger.valueOf(name.getNameType().getOrdinal())));
        vector.add(new DERTaggedObject(1, PrincipalNameEncoder.encodeNameSequence(name)));
        return vector;
    }

    private static DERSequence encodeNameSequence(KerberosPrincipal principal) {
        Iterator<String> it = PrincipalNameEncoder.getNameStrings(principal).iterator();
        DERSequence vector = new DERSequence();
        while (it.hasNext()) {
            vector.add(DERGeneralString.valueOf(it.next()));
        }
        return vector;
    }

    private static List<String> getNameStrings(KerberosPrincipal principal) {
        String nameComponent = principal.getName().split(REALM_SEPARATOR)[0];
        String[] components = nameComponent.split(COMPONENT_SEPARATOR);
        return Arrays.asList(components);
    }

    private static DERSequence encodeNameSequence(PrincipalName principalName) {
        DERSequence vector = new DERSequence();
        for (String name : principalName.getNames()) {
            vector.add(DERGeneralString.valueOf(name));
        }
        return vector;
    }
}

