/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.ldif;

import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.partition.avl.AvlStore;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.shared.ldap.entry.DefaultServerEntry;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.ldif.LdifUtils;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifStore<E>
implements Store<E, Long> {
    private File workingDirectory;
    private boolean isSyncOnWrite = true;
    private AvlStore<E> wrappedStore = new AvlStore();
    private SchemaManager schemaManager;
    private LdifReader ldifReader;
    private FileFilter dirFilter = new FileFilter(){

        public boolean accept(File dir) {
            return dir.isDirectory();
        }
    };
    private static final String CONF_FILE_EXTN = ".ldif";
    private static Logger LOG = LoggerFactory.getLogger(LdifStore.class);

    @Override
    public void init(SchemaManager schemaManager) throws Exception {
        this.schemaManager = schemaManager;
        this.wrappedStore.init(schemaManager);
        this.loadConfig();
    }

    public void loadConfig() throws Exception {
        String upsuffixDir = this.wrappedStore.getUpSuffix().getName().toLowerCase();
        File dir = new File(this.workingDirectory, upsuffixDir);
        if (!dir.exists()) {
            throw new Exception(I18n.err(I18n.ERR_631, upsuffixDir, this.workingDirectory.getAbsolutePath()));
        }
        this.loadEntry(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEntry(File entryDir) throws Exception {
        LOG.debug("processing dir {}", (Object)entryDir.getName());
        File ldifFile = new File(entryDir, entryDir.getName() + CONF_FILE_EXTN);
        try {
            this.ldifReader = new LdifReader();
            if (ldifFile.exists()) {
                LOG.debug("parsing ldif file {}", (Object)ldifFile.getName());
                List<LdifEntry> entries = this.ldifReader.parseLdifFile(ldifFile.getAbsolutePath());
                if (entries != null && !entries.isEmpty()) {
                    LdifEntry ldifEntry = entries.get(0);
                    LOG.debug("adding entry {}", ldifEntry);
                    DefaultServerEntry serverEntry = new DefaultServerEntry(this.schemaManager, ldifEntry.getEntry());
                    this.wrappedStore.add(serverEntry);
                }
            } else {
                LOG.warn("ldif file doesn't exist {}", (Object)ldifFile.getAbsolutePath());
            }
        }
        finally {
            this.ldifReader.close();
        }
        File[] dirs = entryDir.listFiles(this.dirFilter);
        if (dirs != null) {
            for (File f : dirs) {
                this.loadEntry(f);
            }
        }
    }

    private File getFile(DN entryDn) {
        int size = entryDn.size();
        StringBuilder filePath = new StringBuilder();
        filePath.append(this.workingDirectory.getAbsolutePath()).append(File.separator);
        for (int i = 0; i < size; ++i) {
            filePath.append(entryDn.getRdn(i).getName().toLowerCase()).append(File.separator);
        }
        File dir = new File(filePath.toString());
        dir.mkdirs();
        return new File(dir, entryDn.getRdn().getName().toLowerCase() + CONF_FILE_EXTN);
    }

    @Override
    public void add(ServerEntry entry) throws Exception {
        this.wrappedStore.add(entry);
        FileWriter fw = new FileWriter(this.getFile(entry.getDn()));
        fw.write(LdifUtils.convertEntryToLdif(entry));
        fw.close();
    }

    @Override
    public void delete(Long id) throws Exception {
        ServerEntry entry = this.lookup(id);
        LOG.warn("deleting the entry with id {} and dn {}", id, (Object)entry.getDn());
        LOG.warn("having the parent id {}", this.getParentId(entry.getDn().getName()));
        this.wrappedStore.delete(id);
        if (entry != null) {
            File file = this.getFile(entry.getDn()).getParentFile();
            boolean deleted = this.deleteFile(file);
            LOG.warn("deleted file {} {}", file.getAbsoluteFile(), (Object)deleted);
        }
    }

    private boolean deleteFile(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                this.deleteFile(f);
            }
        }
        return file.delete();
    }

    @Override
    public void destroy() throws Exception {
        this.wrappedStore.destroy();
    }

    @Override
    public void modify(DN dn, List<Modification> mods) throws Exception {
        this.wrappedStore.modify(dn, mods);
    }

    @Override
    public void modify(DN dn, ModificationOperation modOp, ServerEntry mods) throws Exception {
        this.wrappedStore.modify(dn, modOp, mods);
    }

    @Override
    public void move(DN oldChildDn, DN newParentDn, RDN newRdn, boolean deleteOldRdn) throws Exception {
        this.wrappedStore.move(oldChildDn, newParentDn, newRdn, deleteOldRdn);
    }

    @Override
    public void move(DN oldChildDn, DN newParentDn) throws Exception {
        this.wrappedStore.move(oldChildDn, newParentDn);
    }

    @Override
    public void rename(DN dn, RDN newRdn, boolean deleteOldRdn) throws Exception {
        this.wrappedStore.rename(dn, newRdn, deleteOldRdn);
    }

    @Override
    public void sync() throws Exception {
    }

    @Override
    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void setSyncOnWrite(boolean isSyncOnWrite) {
        this.isSyncOnWrite = isSyncOnWrite;
    }

    @Override
    public boolean isSyncOnWrite() {
        return this.isSyncOnWrite;
    }

    @Override
    public void addIndex(Index<?, E, Long> index) throws Exception {
        this.wrappedStore.addIndex((Index<Object, E, Long>)index);
    }

    @Override
    public int count() throws Exception {
        return this.wrappedStore.count();
    }

    @Override
    public Index<String, E, Long> getAliasIndex() {
        return this.wrappedStore.getAliasIndex();
    }

    @Override
    public int getChildCount(Long id) throws Exception {
        return this.wrappedStore.getChildCount(id);
    }

    @Override
    public String getEntryDn(Long id) throws Exception {
        return this.wrappedStore.getEntryDn(id);
    }

    @Override
    public Long getEntryId(String dn) throws Exception {
        return this.wrappedStore.getEntryId(dn);
    }

    @Override
    public String getEntryUpdn(Long arg0) throws Exception {
        return this.wrappedStore.getEntryUpdn(arg0);
    }

    @Override
    public String getEntryUpdn(String dn) throws Exception {
        return this.wrappedStore.getEntryUpdn(dn);
    }

    @Override
    public String getName() {
        return this.wrappedStore.getName();
    }

    @Override
    public Index<String, E, Long> getNdnIndex() {
        return this.wrappedStore.getNdnIndex();
    }

    @Override
    public Index<Long, E, Long> getOneAliasIndex() {
        return this.wrappedStore.getOneAliasIndex();
    }

    @Override
    public Index<Long, E, Long> getOneLevelIndex() {
        return this.wrappedStore.getOneLevelIndex();
    }

    @Override
    public Long getParentId(Long arg0) throws Exception {
        return this.wrappedStore.getParentId(arg0);
    }

    @Override
    public Long getParentId(String dn) throws Exception {
        return this.wrappedStore.getParentId(dn);
    }

    @Override
    public Index<String, E, Long> getPresenceIndex() {
        return this.wrappedStore.getPresenceIndex();
    }

    @Override
    public String getProperty(String propertyName) throws Exception {
        return this.wrappedStore.getProperty(propertyName);
    }

    @Override
    public Index<Long, E, Long> getSubAliasIndex() {
        return this.wrappedStore.getSubAliasIndex();
    }

    @Override
    public Index<Long, E, Long> getSubLevelIndex() {
        return this.wrappedStore.getSubLevelIndex();
    }

    @Override
    public Index<?, E, Long> getIndex(String id) throws IndexNotFoundException {
        return this.wrappedStore.getIndex(id);
    }

    @Override
    public Index<?, E, Long> getSystemIndex(String id) throws IndexNotFoundException {
        return this.wrappedStore.getSystemIndex(id);
    }

    @Override
    public Index<String, E, Long> getUpdnIndex() {
        return this.wrappedStore.getUpdnIndex();
    }

    @Override
    public Index<?, E, Long> getUserIndex(String id) throws IndexNotFoundException {
        return this.wrappedStore.getUserIndex(id);
    }

    @Override
    public Set<Index<?, E, Long>> getUserIndices() {
        return this.wrappedStore.getUserIndices();
    }

    @Override
    public boolean hasIndexOn(String id) throws Exception {
        return this.wrappedStore.hasIndexOn(id);
    }

    @Override
    public boolean hasSystemIndexOn(String id) throws Exception {
        return this.wrappedStore.hasSystemIndexOn(id);
    }

    @Override
    public boolean hasUserIndexOn(String id) throws Exception {
        return this.wrappedStore.hasUserIndexOn(id);
    }

    @Override
    public boolean isInitialized() {
        return this.wrappedStore.isInitialized();
    }

    @Override
    public IndexCursor<Long, E, Long> list(Long id) throws Exception {
        return this.wrappedStore.list(id);
    }

    @Override
    public ServerEntry lookup(Long id) throws Exception {
        return this.wrappedStore.lookup(id);
    }

    @Override
    public void setAliasIndex(Index<String, E, Long> index) throws Exception {
        this.wrappedStore.setAliasIndex(index);
    }

    @Override
    public void setName(String name) {
        this.wrappedStore.setName(name);
    }

    @Override
    public void setNdnIndex(Index<String, E, Long> index) throws Exception {
        this.wrappedStore.setNdnIndex(index);
    }

    @Override
    public void setOneAliasIndex(Index<Long, E, Long> index) throws Exception {
        this.wrappedStore.setOneAliasIndex(index);
    }

    @Override
    public void setOneLevelIndex(Index<Long, E, Long> index) throws Exception {
        this.wrappedStore.setOneLevelIndex(index);
    }

    @Override
    public void setPresenceIndex(Index<String, E, Long> index) throws Exception {
        this.wrappedStore.setPresenceIndex(index);
    }

    @Override
    public void setProperty(String propertyName, String propertyValue) throws Exception {
        this.wrappedStore.setProperty(propertyName, propertyValue);
    }

    @Override
    public void setSubAliasIndex(Index<Long, E, Long> index) throws Exception {
        this.wrappedStore.setSubAliasIndex(index);
    }

    @Override
    public void setSubLevelIndex(Index<Long, E, Long> index) throws Exception {
        this.wrappedStore.setSubLevelIndex(index);
    }

    @Override
    public void setUpdnIndex(Index<String, E, Long> index) throws Exception {
        this.wrappedStore.setUpdnIndex(index);
    }

    @Override
    public Iterator<String> systemIndices() {
        return this.wrappedStore.systemIndices();
    }

    @Override
    public Iterator<String> userIndices() {
        return this.wrappedStore.userIndices();
    }

    @Override
    public int getCacheSize() {
        return this.wrappedStore.getCacheSize();
    }

    @Override
    public Index<String, E, Long> getEntryCsnIndex() {
        return this.wrappedStore.getEntryCsnIndex();
    }

    @Override
    public Index<String, E, Long> getEntryUuidIndex() {
        return this.wrappedStore.getEntryUuidIndex();
    }

    @Override
    public Index<String, E, Long> getObjectClassIndex() {
        return this.wrappedStore.getObjectClassIndex();
    }

    @Override
    public DN getSuffix() {
        return this.wrappedStore.getSuffix();
    }

    @Override
    public String getSuffixDn() {
        return this.wrappedStore.getSuffixDn();
    }

    @Override
    public DN getUpSuffix() {
        return this.wrappedStore.getUpSuffix();
    }

    @Override
    public void setCacheSize(int size) {
        this.wrappedStore.setCacheSize(size);
    }

    @Override
    public void setUserIndices(Set<Index<?, E, Long>> userIndices) {
        this.wrappedStore.setUserIndices(userIndices);
    }

    @Override
    public void setSuffixDn(String suffixDn) {
        this.wrappedStore.setSuffixDn(suffixDn);
    }

    @Override
    public void setEntryCsnIndex(Index<String, E, Long> index) throws Exception {
        this.wrappedStore.setEntryCsnIndex(index);
    }

    @Override
    public void setEntryUuidIndex(Index<String, E, Long> index) throws Exception {
        this.wrappedStore.setEntryUuidIndex(index);
    }

    @Override
    public void setObjectClassIndex(Index<String, E, Long> index) throws Exception {
        this.wrappedStore.setObjectClassIndex(index);
    }

    @Override
    public Long getDefaultId() {
        return 1L;
    }
}

