/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.registries;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.NoSuchAttributeException;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.SchemaObjectType;
import org.apache.directory.shared.ldap.schema.registries.DefaultSchemaObjectRegistry;
import org.apache.directory.shared.ldap.schema.registries.ObjectClassRegistry;
import org.apache.directory.shared.ldap.schema.registries.OidRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectClassRegistry
extends DefaultSchemaObjectRegistry<ObjectClass>
implements ObjectClassRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultObjectClassRegistry.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private Map<String, Set<ObjectClass>> oidToDescendants = new HashMap<String, Set<ObjectClass>>();

    public DefaultObjectClassRegistry() {
        super(SchemaObjectType.OBJECT_CLASS, new OidRegistry());
    }

    @Override
    public boolean hasDescendants(String ancestorId) throws NamingException {
        try {
            String oid = this.getOidByName(ancestorId);
            Set<ObjectClass> descendants = this.oidToDescendants.get(oid);
            return descendants != null && !descendants.isEmpty();
        }
        catch (NamingException ne) {
            throw new NoSuchAttributeException(ne.getMessage());
        }
    }

    @Override
    public Iterator<ObjectClass> descendants(String ancestorId) throws NamingException {
        try {
            String oid = this.getOidByName(ancestorId);
            Set<ObjectClass> descendants = this.oidToDescendants.get(oid);
            if (descendants == null) {
                return Collections.EMPTY_SET.iterator();
            }
            return descendants.iterator();
        }
        catch (NamingException ne) {
            throw new NoSuchAttributeException(ne.getMessage());
        }
    }

    @Override
    public void registerDescendants(ObjectClass objectClass, List<ObjectClass> ancestors) throws NamingException {
        if (ancestors == null || ancestors.size() == 0) {
            return;
        }
        for (ObjectClass ancestor : ancestors) {
            Set<ObjectClass> descendants = this.oidToDescendants.get(ancestor.getOid());
            if (descendants == null) {
                descendants = new HashSet<ObjectClass>(1);
                this.oidToDescendants.put(ancestor.getOid(), descendants);
            }
            descendants.add(objectClass);
            try {
                this.registerDescendants(objectClass, ancestor.getSuperiors());
            }
            catch (NamingException ne) {
                throw new NoSuchAttributeException(ne.getMessage());
            }
        }
    }

    @Override
    public void unregisterDescendants(ObjectClass attributeType, List<ObjectClass> ancestors) throws NamingException {
        if (ancestors == null || ancestors.size() == 0) {
            return;
        }
        for (ObjectClass ancestor : ancestors) {
            Set<ObjectClass> descendants = this.oidToDescendants.get(ancestor.getOid());
            if (descendants != null) {
                descendants.remove(attributeType);
                if (descendants.size() == 0) {
                    this.oidToDescendants.remove(descendants);
                }
            }
            try {
                this.unregisterDescendants(attributeType, ancestor.getSuperiors());
            }
            catch (NamingException ne) {
                throw new NoSuchAttributeException(ne.getMessage());
            }
        }
    }

    @Override
    public ObjectClass unregister(String numericOid) throws NamingException {
        try {
            ObjectClass removed = (ObjectClass)((Object)super.unregister(numericOid));
            this.oidToDescendants.remove(numericOid);
            this.unregisterDescendants(removed, removed.getSuperiors());
            return removed;
        }
        catch (NamingException ne) {
            throw new NoSuchAttributeException(ne.getMessage());
        }
    }

    @Override
    public DefaultObjectClassRegistry copy() {
        DefaultObjectClassRegistry copy = new DefaultObjectClassRegistry();
        copy.copy(this);
        return copy;
    }

    @Override
    public void clear() {
        for (SchemaObject objectClass : this.oidRegistry) {
            objectClass.clear();
        }
        super.clear();
        for (String oid : this.oidToDescendants.keySet()) {
            Set<ObjectClass> descendants = this.oidToDescendants.get(oid);
            if (descendants == null) continue;
            descendants.clear();
        }
        this.oidToDescendants.clear();
    }
}

