/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.AbstractSchemaObject;
import org.apache.directory.shared.ldap.schema.DescriptionUtils;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.LdapSyntax;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.SchemaObjectType;
import org.apache.directory.shared.ldap.schema.comparators.ComparableComparator;
import org.apache.directory.shared.ldap.schema.normalizers.NoOpNormalizer;
import org.apache.directory.shared.ldap.schema.registries.Registries;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingRule
extends AbstractSchemaObject {
    private static final long serialVersionUID = 1L;
    protected LdapComparator<? super Object> ldapComparator;
    protected Normalizer normalizer;
    protected LdapSyntax ldapSyntax;
    private String ldapSyntaxOid;

    public MatchingRule(String oid) {
        super(SchemaObjectType.MATCHING_RULE, oid);
    }

    @Override
    public void addToRegistries(List<Throwable> errors, Registries registries) throws NamingException {
        if (registries != null) {
            try {
                this.ldapComparator = (LdapComparator)registries.getComparatorRegistry().lookup(this.oid);
            }
            catch (NamingException ne) {
                this.ldapComparator = new ComparableComparator(this.oid);
            }
            try {
                this.normalizer = (Normalizer)registries.getNormalizerRegistry().lookup(this.oid);
            }
            catch (NamingException ne) {
                this.normalizer = new NoOpNormalizer(this.oid);
            }
            try {
                this.ldapSyntax = (LdapSyntax)registries.getLdapSyntaxRegistry().lookup(this.ldapSyntaxOid);
            }
            catch (NamingException ne) {
                throw new LdapSchemaViolationException(I18n.err("ERR_04317", new Object[0]), ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            if (this.ldapComparator != null) {
                registries.addReference(this, this.ldapComparator);
            }
            if (this.normalizer != null) {
                registries.addReference(this, this.normalizer);
            }
            if (this.ldapSyntax != null) {
                registries.addReference(this, this.ldapSyntax);
            }
        }
    }

    @Override
    public void removeFromRegistries(List<Throwable> errors, Registries registries) throws NamingException {
        if (registries != null) {
            if (this.ldapComparator != null) {
                registries.delReference(this, this.ldapComparator);
            }
            if (this.ldapSyntax != null) {
                registries.delReference(this, this.ldapSyntax);
            }
            if (this.normalizer != null) {
                registries.delReference(this, this.normalizer);
            }
        }
    }

    public LdapSyntax getSyntax() {
        return this.ldapSyntax;
    }

    public String getSyntaxOid() {
        return this.ldapSyntaxOid;
    }

    public void setSyntaxOid(String oid) {
        if (!this.isReadOnly) {
            this.ldapSyntaxOid = oid;
        }
    }

    public void setSyntax(LdapSyntax ldapSyntax) {
        if (!this.isReadOnly) {
            this.ldapSyntax = ldapSyntax;
            this.ldapSyntaxOid = ldapSyntax.getOid();
        }
    }

    public void updateSyntax(LdapSyntax ldapSyntax) {
        this.ldapSyntax = ldapSyntax;
        this.ldapSyntaxOid = ldapSyntax.getOid();
    }

    public LdapComparator<? super Object> getLdapComparator() {
        return this.ldapComparator;
    }

    public void setLdapComparator(LdapComparator<?> ldapComparator) {
        if (!this.isReadOnly) {
            this.ldapComparator = ldapComparator;
        }
    }

    public void updateLdapComparator(LdapComparator<?> ldapComparator) {
        this.ldapComparator = ldapComparator;
    }

    public Normalizer getNormalizer() {
        return this.normalizer;
    }

    public void setNormalizer(Normalizer normalizer) {
        if (!this.isReadOnly) {
            this.normalizer = normalizer;
        }
    }

    public void updateNormalizer(Normalizer normalizer) {
        this.normalizer = normalizer;
    }

    public String toString() {
        return (Object)((Object)this.objectType) + " " + DescriptionUtils.getDescription(this);
    }

    @Override
    public MatchingRule copy() {
        MatchingRule copy = new MatchingRule(this.oid);
        copy.copy(this);
        copy.ldapComparator = null;
        copy.ldapSyntax = null;
        copy.normalizer = null;
        copy.ldapSyntaxOid = this.ldapSyntaxOid;
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof MatchingRule)) {
            return false;
        }
        MatchingRule that = (MatchingRule)o;
        if (this.ldapComparator != null ? !this.ldapComparator.equals(that.ldapComparator) : that.ldapComparator != null) {
            return false;
        }
        if (this.normalizer != null ? !this.normalizer.equals(that.normalizer) : that.normalizer != null) {
            return false;
        }
        if (!this.compareOid(this.ldapSyntaxOid, that.ldapSyntaxOid)) {
            return false;
        }
        return this.ldapSyntax.equals(that.ldapSyntax);
    }

    @Override
    public void clear() {
        super.clear();
        this.ldapComparator = null;
        this.ldapSyntax = null;
        this.normalizer = null;
    }
}

