/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import java.text.ParseException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.ApproximateNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.filter.FilterParserMonitor;
import org.apache.directory.shared.ldap.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.filter.LessEqNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.Position;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterParser {
    private static ExprNode parseExtensible(String attr, String filter, Position pos) throws ParseException {
        ExtensibleNode node = new ExtensibleNode(attr);
        if (attr != null) {
            if (StringTools.areEquals(filter, pos.start, "dn")) {
                node.setDnAttributes(true);
                pos.start += 2;
            } else {
                --pos.start;
            }
            if (StringTools.charAt(filter, pos.start) == ':') {
                ++pos.start;
                int start = pos.start;
                if (StringTools.charAt(filter, pos.start) == '=') {
                    ++pos.start;
                    node.setValue(FilterParser.parseAssertionValue(filter, pos, true));
                    return node;
                }
                AttributeUtils.parseAttribute(filter, pos, false);
                node.setMatchingRuleId(filter.substring(start, pos.start));
                if (StringTools.areEquals(filter, pos.start, ":=")) {
                    pos.start += 2;
                    node.setValue(FilterParser.parseAssertionValue(filter, pos, true));
                    return node;
                }
                throw new ParseException(I18n.err("ERR_04146", new Object[0]), pos.start);
            }
            throw new ParseException(I18n.err("ERR_04147", new Object[0]), pos.start);
        }
        boolean oidRequested = false;
        if (StringTools.areEquals(filter, pos.start, ":dn")) {
            node.setDnAttributes(true);
            pos.start += 3;
        } else {
            oidRequested = true;
        }
        if (StringTools.charAt(filter, pos.start) == ':') {
            ++pos.start;
            int start = pos.start;
            if (StringTools.charAt(filter, pos.start) == '=') {
                if (oidRequested) {
                    throw new ParseException(I18n.err("ERR_04148", new Object[0]), pos.start);
                }
                ++pos.start;
                node.setValue(FilterParser.parseAssertionValue(filter, pos, true));
                return node;
            }
            AttributeUtils.parseAttribute(filter, pos, false);
            node.setMatchingRuleId(filter.substring(start, pos.start));
            if (StringTools.areEquals(filter, pos.start, ":=")) {
                pos.start += 2;
                node.setValue(FilterParser.parseAssertionValue(filter, pos, true));
                return node;
            }
            throw new ParseException(I18n.err("ERR_04146", new Object[0]), pos.start);
        }
        throw new ParseException(I18n.err("ERR_04147", new Object[0]), pos.start);
    }

    private static Value<?> parseAssertionValue(String filter, Position pos, boolean preserveEscapedChars) throws ParseException {
        int start = pos.start;
        char c = StringTools.charAt(filter, pos.start);
        byte[] value = new byte[filter.length() - pos.start];
        int current = 0;
        do {
            if (StringTools.isUnicodeSubset(c)) {
                value[current++] = (byte)c;
                ++pos.start;
                continue;
            }
            if (!StringTools.isCharASCII(filter, pos.start, '\\')) break;
            ++pos.start;
            if (StringTools.isHex(filter, pos.start)) {
                ++pos.start;
            } else {
                throw new ParseException(I18n.err("ERR_04149", new Object[0]), pos.start);
            }
            if (StringTools.isHex(filter, pos.start)) {
                value[current++] = StringTools.getHexValue(filter.charAt(pos.start - 1), filter.charAt(pos.start));
                ++pos.start;
                continue;
            }
            throw new ParseException(I18n.err("ERR_04149", new Object[0]), pos.start);
        } while ((c = StringTools.charAt(filter, pos.start)) != '\u0000');
        if (current != 0) {
            byte[] result = new byte[current];
            System.arraycopy(value, 0, result, 0, current);
            return new ClientBinaryValue(result);
        }
        return new ClientBinaryValue();
    }

    private static Value<?> parseAssertionValue(String filter, Position pos) throws ParseException {
        return FilterParser.parseAssertionValue(filter, pos, false);
    }

    private static ExprNode parseSubstring(String attr, Value<?> initial, String filter, Position pos) throws ParseException {
        if (StringTools.isCharASCII(filter, pos.start, '*')) {
            SubstringNode node = new SubstringNode(attr);
            if (initial != null && !initial.isNull()) {
                String initialStr = initial.getString();
                node.setInitial(initialStr);
            }
            ++pos.start;
            while (true) {
                Value<?> assertionValue = FilterParser.parseAssertionValue(filter, pos);
                if (StringTools.isCharASCII(filter, pos.start, ')')) {
                    if (!assertionValue.isNull()) {
                        String finalStr = assertionValue.getString();
                        node.setFinal(finalStr);
                    }
                    return node;
                }
                if (!StringTools.isCharASCII(filter, pos.start, '*')) break;
                if (!assertionValue.isNull()) {
                    String anyStr = assertionValue.getString();
                    node.addAny(anyStr);
                }
                ++pos.start;
            }
            throw new ParseException(I18n.err("ERR_04150", new Object[0]), pos.start);
        }
        throw new ParseException(I18n.err("ERR_04150", new Object[0]), pos.start);
    }

    private static ExprNode parsePresenceEqOrSubstring(String attr, String filter, Position pos) throws ParseException {
        if (StringTools.isCharASCII(filter, pos.start, '*')) {
            ++pos.start;
            if (StringTools.isCharASCII(filter, pos.start, ')')) {
                return new PresenceNode(attr);
            }
            --pos.start;
            return FilterParser.parseSubstring(attr, null, filter, pos);
        }
        if (StringTools.isCharASCII(filter, pos.start, ')')) {
            return new EqualityNode<byte[]>(attr, new ClientBinaryValue());
        }
        Value<?> value = FilterParser.parseAssertionValue(filter, pos);
        if (StringTools.isCharASCII(filter, pos.start, ')')) {
            return new EqualityNode(attr, value);
        }
        return FilterParser.parseSubstring(attr, value, filter, pos);
    }

    private static ExprNode parseItem(String filter, Position pos, char c) throws ParseException {
        SimpleNode node = null;
        String attr = null;
        if (c == '\u0000') {
            throw new ParseException(I18n.err("ERR_04151", new Object[0]), pos.start);
        }
        if (c == ':') {
            return FilterParser.parseExtensible(null, filter, pos);
        }
        attr = AttributeUtils.parseAttribute(filter, pos, true);
        c = StringTools.charAt(filter, pos.start);
        switch (c) {
            case '=': {
                ++pos.start;
                return FilterParser.parsePresenceEqOrSubstring(attr, filter, pos);
            }
            case '~': {
                ++pos.start;
                if (!StringTools.isCharASCII(filter, pos.start, '=')) {
                    throw new ParseException(I18n.err("ERR_04152", new Object[0]), pos.start);
                }
                ++pos.start;
                node = new ApproximateNode(attr, FilterParser.parseAssertionValue(filter, pos));
                return node;
            }
            case '>': {
                ++pos.start;
                if (!StringTools.isCharASCII(filter, pos.start, '=')) {
                    throw new ParseException(I18n.err("ERR_04152", new Object[0]), pos.start);
                }
                ++pos.start;
                node = new GreaterEqNode(attr, FilterParser.parseAssertionValue(filter, pos));
                return node;
            }
            case '<': {
                ++pos.start;
                if (!StringTools.isCharASCII(filter, pos.start, '=')) {
                    throw new ParseException(I18n.err("ERR_04152", new Object[0]), pos.start);
                }
                ++pos.start;
                node = new LessEqNode(attr, FilterParser.parseAssertionValue(filter, pos));
                return node;
            }
            case ':': {
                ++pos.start;
                return FilterParser.parseExtensible(attr, filter, pos);
            }
        }
        throw new ParseException(I18n.err("ERR_04153", new Object[0]), pos.start);
    }

    private static ExprNode parseBranchNode(ExprNode node, String filter, Position pos) throws ParseException {
        BranchNode bNode = (BranchNode)node;
        ExprNode child = FilterParser.parseFilterInternal(filter, pos);
        bNode.addNode(child);
        while ((child = FilterParser.parseFilterInternal(filter, pos)) != null) {
            bNode.addNode(child);
        }
        return node;
    }

    private static ExprNode parseFilterComp(String filter, Position pos) throws ParseException {
        ExprNode node = null;
        if (pos.start == pos.length) {
            throw new ParseException(I18n.err("ERR_04154", new Object[0]), pos.start);
        }
        char c = StringTools.charAt(filter, pos.start);
        switch (c) {
            case '&': {
                ++pos.start;
                node = new AndNode();
                FilterParser.parseBranchNode(node, filter, pos);
                break;
            }
            case '|': {
                ++pos.start;
                node = new OrNode();
                FilterParser.parseBranchNode(node, filter, pos);
                break;
            }
            case '!': {
                ++pos.start;
                node = new NotNode();
                FilterParser.parseBranchNode(node, filter, pos);
                break;
            }
            default: {
                node = FilterParser.parseItem(filter, pos, c);
            }
        }
        return node;
    }

    private static ExprNode parseFilterInternal(String filter, Position pos) throws ParseException {
        if (!StringTools.isCharASCII(filter, pos.start, '(')) {
            if (pos.start == 0 && pos.length != 0) {
                throw new ParseException(I18n.err("ERR_04155", new Object[0]), 0);
            }
            return null;
        }
        ++pos.start;
        ExprNode node = FilterParser.parseFilterComp(filter, pos);
        if (node == null) {
            throw new ParseException(I18n.err("ERR_04156", new Object[0]), pos.start);
        }
        if (!StringTools.isCharASCII(filter, pos.start, ')')) {
            throw new ParseException(I18n.err("ERR_04157", new Object[0]), pos.start);
        }
        ++pos.start;
        return node;
    }

    public static ExprNode parse(String filter) throws ParseException {
        if (StringTools.isEmpty(filter)) {
            throw new ParseException(I18n.err("ERR_04158", new Object[0]), 0);
        }
        Position pos = new Position();
        pos.start = 0;
        pos.end = 0;
        pos.length = filter.length();
        return FilterParser.parseFilterInternal(filter, pos);
    }

    public void setFilterParserMonitor(FilterParserMonitor monitor) {
    }
}

