/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.modifyDn;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.util.StringTools;

public class ModifyDNRequestCodec
extends LdapMessageCodec {
    private DN entry;
    private RDN newRDN;
    private boolean deleteOldRDN;
    private DN newSuperior;
    private int modifyDNRequestLength;

    public MessageTypeEnum getMessageType() {
        return MessageTypeEnum.MODIFYDN_REQUEST;
    }

    public String getMessageTypeName() {
        return "MODIFYDN_REQUEST";
    }

    public DN getEntry() {
        return this.entry;
    }

    public void setEntry(DN entry) {
        this.entry = entry;
    }

    public boolean isDeleteOldRDN() {
        return this.deleteOldRDN;
    }

    public void setDeleteOldRDN(boolean deleteOldRDN) {
        this.deleteOldRDN = deleteOldRDN;
    }

    public RDN getNewRDN() {
        return this.newRDN;
    }

    public void setNewRDN(RDN newRDN) {
        this.newRDN = newRDN;
    }

    public DN getNewSuperior() {
        return this.newSuperior;
    }

    public void setNewSuperior(DN newSuperior) {
        this.newSuperior = newSuperior;
    }

    protected int computeLengthProtocolOp() {
        int newRdnlength = StringTools.getBytesUtf8(this.newRDN.toString()).length;
        this.modifyDNRequestLength = 1 + TLV.getNbBytes(DN.getNbBytes(this.entry)) + DN.getNbBytes(this.entry) + 1 + TLV.getNbBytes(newRdnlength) + newRdnlength + 1 + 1 + 1;
        if (this.newSuperior != null) {
            this.modifyDNRequestLength += 1 + TLV.getNbBytes(DN.getNbBytes(this.newSuperior)) + DN.getNbBytes(this.newSuperior);
        }
        return 1 + TLV.getNbBytes(this.modifyDNRequestLength) + this.modifyDNRequestLength;
    }

    protected void encodeProtocolOp(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)108);
            buffer.put(TLV.getBytes(this.modifyDNRequestLength));
            Value.encode(buffer, DN.getBytes(this.entry));
            Value.encode(buffer, this.newRDN.toString());
            Value.encode(buffer, this.deleteOldRDN);
            if (this.newSuperior != null) {
                buffer.put((byte)-128);
                int newSuperiorLength = DN.getNbBytes(this.newSuperior);
                buffer.put(TLV.getBytes(newSuperiorLength));
                if (newSuperiorLength != 0) {
                    buffer.put(DN.getBytes(this.newSuperior));
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err("ERR_04005", new Object[0]));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    ModifyDN Response\n");
        sb.append("        Entry : '").append(this.entry).append("'\n");
        sb.append("        New RDN : '").append(this.newRDN).append("'\n");
        sb.append("        Delete old RDN : ").append(this.deleteOldRDN).append("\n");
        if (this.newSuperior != null) {
            sb.append("        New superior : '").append(this.newSuperior).append("'\n");
        }
        return sb.toString();
    }
}

