/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.registries.synchronizers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.schema.registries.synchronizers.AttributeTypeSynchronizer;
import org.apache.directory.server.core.schema.registries.synchronizers.ComparatorSynchronizer;
import org.apache.directory.server.core.schema.registries.synchronizers.DitContentRuleSynchronizer;
import org.apache.directory.server.core.schema.registries.synchronizers.DitStructureRuleSynchronizer;
import org.apache.directory.server.core.schema.registries.synchronizers.MatchingRuleSynchronizer;
import org.apache.directory.server.core.schema.registries.synchronizers.MatchingRuleUseSynchronizer;
import org.apache.directory.server.core.schema.registries.synchronizers.NameFormSynchronizer;
import org.apache.directory.server.core.schema.registries.synchronizers.NormalizerSynchronizer;
import org.apache.directory.server.core.schema.registries.synchronizers.ObjectClassSynchronizer;
import org.apache.directory.server.core.schema.registries.synchronizers.RegistrySynchronizer;
import org.apache.directory.server.core.schema.registries.synchronizers.SchemaSynchronizer;
import org.apache.directory.server.core.schema.registries.synchronizers.SyntaxCheckerSynchronizer;
import org.apache.directory.server.core.schema.registries.synchronizers.SyntaxSynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.registries.ObjectClassRegistry;
import org.apache.directory.shared.ldap.schema.registries.Registries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrySynchronizerAdaptor {
    private static final Logger LOG = LoggerFactory.getLogger(RegistrySynchronizerAdaptor.class);
    private static final int COMPARATOR_INDEX = 0;
    private static final int NORMALIZER_INDEX = 1;
    private static final int SYNTAX_CHECKER_INDEX = 2;
    private static final int SYNTAX_INDEX = 3;
    private static final int MATCHING_RULE_INDEX = 4;
    private static final int ATTRIBUTE_TYPE_INDEX = 5;
    private static final int OBJECT_CLASS_INDEX = 6;
    private static final int MATCHING_RULE_USE_INDEX = 7;
    private static final int DIT_STRUCTURE_RULE_INDEX = 8;
    private static final int DIT_CONTENT_RULE_INDEX = 9;
    private static final int NAME_FORM_INDEX = 10;
    private static final Set<String> VALID_OU_VALUES = new HashSet<String>();
    private static final String[] META_OBJECT_CLASSES = new String[]{"metaComparator", "metaNormalizer", "metaSyntaxChecker", "metaSyntax", "metaMatchingRule", "metaAttributeType", "metaObjectClass", "metaMatchingRuleUse", "metaDITStructureRule", "metaDITContentRule", "metaNameForm"};
    private final Registries registries;
    private final AttributeType objectClassAT;
    private final RegistrySynchronizer[] registrySynchronizers = new RegistrySynchronizer[11];
    private final Map<String, RegistrySynchronizer> objectClass2synchronizerMap = new HashMap<String, RegistrySynchronizer>();
    private final SchemaSynchronizer schemaSynchronizer;

    public RegistrySynchronizerAdaptor(SchemaManager schemaManager) throws Exception {
        this.registries = schemaManager.getRegistries();
        this.schemaSynchronizer = new SchemaSynchronizer(schemaManager);
        this.objectClassAT = (AttributeType)this.registries.getAttributeTypeRegistry().lookup("objectClass");
        this.registrySynchronizers[0] = new ComparatorSynchronizer(schemaManager);
        this.registrySynchronizers[1] = new NormalizerSynchronizer(schemaManager);
        this.registrySynchronizers[2] = new SyntaxCheckerSynchronizer(schemaManager);
        this.registrySynchronizers[3] = new SyntaxSynchronizer(schemaManager);
        this.registrySynchronizers[4] = new MatchingRuleSynchronizer(schemaManager);
        this.registrySynchronizers[5] = new AttributeTypeSynchronizer(schemaManager);
        this.registrySynchronizers[6] = new ObjectClassSynchronizer(schemaManager);
        this.registrySynchronizers[7] = new MatchingRuleUseSynchronizer(schemaManager);
        this.registrySynchronizers[8] = new DitStructureRuleSynchronizer(schemaManager);
        this.registrySynchronizers[9] = new DitContentRuleSynchronizer(schemaManager);
        this.registrySynchronizers[10] = new NameFormSynchronizer(schemaManager);
        ObjectClassRegistry ocReg = this.registries.getObjectClassRegistry();
        for (int ii = 0; ii < META_OBJECT_CLASSES.length; ++ii) {
            ObjectClass oc = (ObjectClass)ocReg.lookup(META_OBJECT_CLASSES[ii]);
            this.objectClass2synchronizerMap.put(oc.getOid(), this.registrySynchronizers[ii]);
        }
    }

    public void add(AddOperationContext opContext) throws Exception {
        String msg;
        EntryAttribute oc = opContext.getEntry().get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.registries.getObjectClassRegistry().getOidByName(value.getString());
            if (!this.objectClass2synchronizerMap.containsKey(oid)) continue;
            RegistrySynchronizer synchronizer = this.objectClass2synchronizerMap.get(oid);
            ClonedServerEntry entry = opContext.getEntry();
            synchronizer.add(entry);
            return;
        }
        if (oc.contains("metaSchema")) {
            ClonedServerEntry entry = opContext.getEntry();
            this.schemaSynchronizer.add(entry);
            return;
        }
        if (oc.contains("organizationalUnit")) {
            if (opContext.getDn().size() != 3) {
                msg = I18n.err(I18n.ERR_81, new Object[0]);
                LOG.error(msg);
                throw new LdapInvalidNameException(msg, ResultCodeEnum.NAMING_VIOLATION);
            }
            String ouValue = opContext.getDn().getRdn().getNormValue();
            if (!VALID_OU_VALUES.contains(ouValue = ouValue.trim().toLowerCase())) {
                String msg2 = I18n.err(I18n.ERR_82, VALID_OU_VALUES);
                LOG.error(msg2);
                throw new LdapInvalidNameException(msg2, ResultCodeEnum.NAMING_VIOLATION);
            }
            return;
        }
        msg = I18n.err(I18n.ERR_83, opContext.getDn());
        LOG.error(msg);
        throw new LdapOperationNotSupportedException(msg, ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void delete(DeleteOperationContext opContext, boolean doCascadeDelete) throws Exception {
        ClonedServerEntry entry = opContext.getEntry();
        EntryAttribute oc = entry.get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.registries.getObjectClassRegistry().getOidByName(value.getString());
            if (!this.objectClass2synchronizerMap.containsKey(oid)) continue;
            RegistrySynchronizer synchronizer = this.objectClass2synchronizerMap.get(oid);
            synchronizer.delete(entry, doCascadeDelete);
            return;
        }
        if (oc.contains("metaSchema")) {
            this.schemaSynchronizer.delete(entry, doCascadeDelete);
            return;
        }
        if (oc.contains("organizationalUnit")) {
            if (opContext.getDn().size() != 3) {
                throw new LdapNamingException(I18n.err(I18n.ERR_378, new Object[0]), ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            String ouValue = opContext.getDn().getRdn().getNormValue();
            if (!VALID_OU_VALUES.contains(ouValue = ouValue.trim().toLowerCase())) {
                throw new LdapInvalidNameException(I18n.err(I18n.ERR_379, VALID_OU_VALUES), ResultCodeEnum.NAMING_VIOLATION);
            }
            return;
        }
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public boolean modify(ModifyOperationContext opContext, ServerEntry targetEntry, boolean doCascadeModify) throws Exception {
        ClonedServerEntry entry = opContext.getEntry();
        EntryAttribute oc = entry.get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.registries.getObjectClassRegistry().getOidByName(value.getString());
            if (!this.objectClass2synchronizerMap.containsKey(oid)) continue;
            RegistrySynchronizer synchronizer = this.objectClass2synchronizerMap.get(oid);
            boolean hasModification = synchronizer.modify(opContext, targetEntry, doCascadeModify);
            return hasModification;
        }
        if (oc.contains("metaSchema")) {
            boolean hasModification = this.schemaSynchronizer.modify(opContext, targetEntry, doCascadeModify);
            return hasModification;
        }
        if (oc.contains("schemaModificationAttributes")) {
            return false;
        }
        LOG.error(String.format(I18n.err(I18n.ERR_84, new Object[0]), opContext.getDn(), entry, opContext.getModItems()));
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void rename(RenameOperationContext opContext, boolean doCascadeModify) throws Exception {
        ServerEntry originalEntry = opContext.getEntry().getOriginalEntry();
        EntryAttribute oc = originalEntry.get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.registries.getObjectClassRegistry().getOidByName(value.getString());
            if (!this.objectClass2synchronizerMap.containsKey(oid)) continue;
            RegistrySynchronizer synchronizer = this.objectClass2synchronizerMap.get(oid);
            synchronizer.rename(originalEntry, opContext.getNewRdn(), doCascadeModify);
            return;
        }
        if (oc.contains("metaSchema")) {
            this.schemaSynchronizer.rename(originalEntry, opContext.getNewRdn(), doCascadeModify);
            return;
        }
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void move(MoveOperationContext opContext, ServerEntry entry, boolean cascade) throws Exception {
        EntryAttribute oc = entry.get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.registries.getObjectClassRegistry().getOidByName(value.getString());
            if (!this.objectClass2synchronizerMap.containsKey(oid)) continue;
            RegistrySynchronizer synchronizer = this.objectClass2synchronizerMap.get(oid);
            synchronizer.move(opContext.getDn(), opContext.getParent(), entry, cascade);
            return;
        }
        if (oc.contains("metaSchema")) {
            this.schemaSynchronizer.move(opContext.getDn(), opContext.getParent(), entry, cascade);
            return;
        }
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void moveAndRename(MoveAndRenameOperationContext opContext, ServerEntry entry, boolean cascade) throws Exception {
        EntryAttribute oc = entry.get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.registries.getObjectClassRegistry().getOidByName(value.getString());
            if (!this.objectClass2synchronizerMap.containsKey(oid)) continue;
            RegistrySynchronizer synchronizer = this.objectClass2synchronizerMap.get(oid);
            synchronizer.moveAndRename(opContext.getDn(), opContext.getParent(), opContext.getNewRdn(), opContext.getDelOldDn(), entry, cascade);
            return;
        }
        if (oc.contains("metaSchema")) {
            this.schemaSynchronizer.moveAndRename(opContext.getDn(), opContext.getParent(), opContext.getNewRdn(), opContext.getDelOldDn(), entry, cascade);
            return;
        }
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    static {
        VALID_OU_VALUES.add("normalizers".toLowerCase());
        VALID_OU_VALUES.add("comparators".toLowerCase());
        VALID_OU_VALUES.add("syntaxCheckers".toLowerCase());
        VALID_OU_VALUES.add("syntaxes".toLowerCase());
        VALID_OU_VALUES.add("matchingRules".toLowerCase());
        VALID_OU_VALUES.add("matchingRuleUse".toLowerCase());
        VALID_OU_VALUES.add("attributeTypes".toLowerCase());
        VALID_OU_VALUES.add("objectClasses".toLowerCase());
        VALID_OU_VALUES.add("nameForms".toLowerCase());
        VALID_OU_VALUES.add("ditContentRules".toLowerCase());
        VALID_OU_VALUES.add("ditStructureRules".toLowerCase());
    }
}

