/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.registries.synchronizers;

import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.schema.registries.synchronizers.AbstractRegistrySynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.registries.Schema;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchingRuleSynchronizer
extends AbstractRegistrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(MatchingRuleSynchronizer.class);

    public MatchingRuleSynchronizer(SchemaManager schemaManager) throws Exception {
        super(schemaManager);
    }

    public boolean modify(ModifyOperationContext opContext, ServerEntry targetEntry, boolean cascade) throws Exception {
        DN name = opContext.getDn();
        ClonedServerEntry entry = opContext.getEntry();
        String schemaName = this.getSchemaName(name);
        MatchingRule mr = this.factory.getMatchingRule(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
        String oldOid = this.getOid(entry);
        if (this.isSchemaEnabled(schemaName)) {
            this.schemaManager.unregisterMatchingRule(oldOid);
            this.schemaManager.add(mr);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void add(ServerEntry entry) throws Exception {
        DN dn = entry.getDn();
        DN parentDn = (DN)dn.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkParent(parentDn, this.schemaManager, "MatchingRule");
        this.checkOidIsUnique(entry);
        String schemaName = this.getSchemaName(dn);
        MatchingRule matchingRule = this.factory.getMatchingRule(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isEnabled() && matchingRule.isEnabled()) {
            if (this.schemaManager.add(matchingRule)) {
                LOG.debug("Added {} into the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_360, entry.getDn().getName(), StringTools.listToString(this.schemaManager.getErrors()));
            LOG.info(msg);
            throw new LdapOperationNotSupportedException(msg, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        LOG.debug("The MztchingRule {} cannot be added in the disabled schema {}.", matchingRule, (Object)schemaName);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void delete(ServerEntry entry, boolean cascade) throws Exception {
        DN dn = entry.getDn();
        DN parentDn = (DN)dn.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkParent(parentDn, this.schemaManager, "MatchingRule");
        String schemaName = this.getSchemaName(entry.getDn());
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isDisabled()) {
            LOG.debug("The MatchingRule {} cannot be removed from the disabled schema {}.", (Object)dn.getName(), (Object)schemaName);
            return;
        }
        MatchingRule matchingRule = (MatchingRule)this.checkOidExists(entry);
        if (schema.isEnabled() && matchingRule.isEnabled()) {
            if (this.schemaManager.delete(matchingRule)) {
                LOG.debug("Removed {} from the schema {}", matchingRule, (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_360, entry.getDn().getName(), StringTools.listToString(this.schemaManager.getErrors()));
            LOG.info(msg);
            throw new LdapOperationNotSupportedException(msg, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        LOG.debug("Removed {} from the disabled schema {}", matchingRule, (Object)schemaName);
    }

    public void rename(ServerEntry entry, RDN newRdn, boolean cascade) throws Exception {
        String schemaName = this.getSchemaName(entry.getDn());
        MatchingRule oldMr = this.factory.getMatchingRule(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        ServerEntry targetEntry = (ServerEntry)entry.clone();
        String newOid = newRdn.getNormValue();
        this.checkOidIsUnique(newOid);
        targetEntry.put("m-oid", newOid);
        MatchingRule mr = this.factory.getMatchingRule(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
        if (this.isSchemaEnabled(schemaName)) {
            this.schemaManager.unregisterMatchingRule(oldMr.getOid());
            this.schemaManager.add(mr);
        } else {
            this.unregisterOids(oldMr);
            this.registerOids(mr);
        }
    }

    public void moveAndRename(DN oriChildName, DN newParentName, RDN newRdn, boolean deleteOldRn, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        MatchingRule oldMr = this.factory.getMatchingRule(this.schemaManager, entry, this.schemaManager.getRegistries(), oldSchemaName);
        ServerEntry targetEntry = (ServerEntry)entry.clone();
        String newOid = newRdn.getNormValue();
        this.checkOidIsUnique(newOid);
        targetEntry.put("m-oid", newOid);
        MatchingRule mr = this.factory.getMatchingRule(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterMatchingRule(oldMr.getOid());
        } else {
            this.unregisterOids(oldMr);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(mr);
        } else {
            this.registerOids(mr);
        }
    }

    public void move(DN oriChildName, DN newParentName, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        MatchingRule oldMr = this.factory.getMatchingRule(this.schemaManager, entry, this.schemaManager.getRegistries(), oldSchemaName);
        MatchingRule newMr = this.factory.getMatchingRule(this.schemaManager, entry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterMatchingRule(oldMr.getOid());
        } else {
            this.unregisterOids(oldMr);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(newMr);
        } else {
            this.registerOids(newMr);
        }
    }

    private void checkNewParent(DN newParent) throws NamingException {
        if (newParent.size() != 3) {
            throw new LdapInvalidNameException(I18n.err(I18n.ERR_361, new Object[0]), ResultCodeEnum.NAMING_VIOLATION);
        }
        RDN rdn = newParent.getRdn();
        if (!this.schemaManager.getAttributeTypeRegistry().getOidByName(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidNameException(I18n.err(I18n.ERR_362, new Object[0]), ResultCodeEnum.NAMING_VIOLATION);
        }
        if (!rdn.getNormValue().equalsIgnoreCase("matchingRules")) {
            throw new LdapInvalidNameException(I18n.err(I18n.ERR_363, new Object[0]), ResultCodeEnum.NAMING_VIOLATION);
        }
    }
}

