/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.SearchEngine;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.name.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryNode
implements TreeNode {
    private final BTreePartition partition;
    private final EntryNode parent;
    private final ServerEntry entry;
    private final ArrayList<TreeNode> children;
    private final Long id;

    public EntryNode(Long id, EntryNode parent, BTreePartition partition, ServerEntry entry, Map<Long, EntryNode> map) {
        this(id, parent, partition, entry, map, null, null);
    }

    public EntryNode(Long id, EntryNode parent, BTreePartition db, ServerEntry entry, Map<Long, EntryNode> map, ExprNode exprNode, SearchEngine engine) {
        this.partition = db;
        this.id = id;
        this.entry = entry;
        this.children = new ArrayList();
        this.parent = parent == null ? this : parent;
        try {
            ArrayList recordForwards = new ArrayList();
            IndexCursor<Long, ServerEntry, Long> childList = db.list(id);
            while (childList.next()) {
                IndexEntry old = (IndexEntry)childList.get();
                ForwardIndexEntry forwardIndexEntry = new ForwardIndexEntry();
                forwardIndexEntry.copy(old);
                recordForwards.add(forwardIndexEntry);
            }
            childList.close();
            for (IndexEntry indexEntry : recordForwards) {
                EntryNode child;
                ClonedServerEntry newEntry;
                if (engine != null && exprNode != null) {
                    if (db.getChildCount(indexEntry.getId()) == 0) {
                        Evaluator evaluator = engine.evaluator(exprNode);
                        if (!evaluator.evaluateId(indexEntry.getId())) continue;
                        ClonedServerEntry newEntry2 = db.lookup(indexEntry.getId());
                        EntryNode child2 = new EntryNode((Long)indexEntry.getId(), this, db, newEntry2, map, exprNode, engine);
                        this.children.add(child2);
                        continue;
                    }
                    newEntry = db.lookup(indexEntry.getId());
                    child = new EntryNode((Long)indexEntry.getId(), this, db, newEntry, map, exprNode, engine);
                    this.children.add(child);
                    continue;
                }
                newEntry = db.lookup((Long)indexEntry.getId());
                child = new EntryNode((Long)indexEntry.getId(), this, db, newEntry, map);
                this.children.add(child);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        map.put(id, this);
    }

    public Enumeration<TreeNode> children() {
        return Collections.enumeration(this.children);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode child) {
        return this.children.indexOf(child);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.children.size() <= 0;
    }

    public String getEntryDn() throws Exception {
        return this.partition.getEntryDn(this.id);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        try {
            DN dn = new DN(this.partition.getEntryDn(this.id));
            buf.append("(").append(this.id).append(") ");
            buf.append(dn.getRdn());
        }
        catch (Exception e) {
            buf.append("ERROR: " + e.getLocalizedMessage());
        }
        if (this.children.size() > 0) {
            buf.append(" [").append(this.children.size()).append("]");
        }
        return buf.toString();
    }

    public ServerEntry getLdapEntry() {
        return this.entry;
    }

    public Long getEntryId() {
        return this.id;
    }
}

