/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.message.internal.InternalModifyDnRequest;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;

public class MoveAndRenameOperationContext
extends RenameOperationContext {
    private DN parent;
    private DN newDn;

    public MoveAndRenameOperationContext(CoreSession session) {
        super(session);
    }

    public MoveAndRenameOperationContext(CoreSession session, DN oldDn, DN parent, RDN newRdn, boolean delOldRdn) {
        super(session, oldDn, newRdn, delOldRdn);
        this.parent = parent;
    }

    public MoveAndRenameOperationContext(CoreSession session, InternalModifyDnRequest modifyDnRequest) {
        super(session, modifyDnRequest);
        this.parent = modifyDnRequest.getNewSuperior();
        if (this.parent == null) {
            throw new IllegalStateException(I18n.err(I18n.ERR_325, modifyDnRequest));
        }
        if (this.requestControls.containsKey("2.16.840.1.113730.3.4.2")) {
            this.ignoreReferral();
        } else {
            this.throwReferral();
        }
    }

    public DN getParent() {
        return this.parent;
    }

    public void setParent(DN parent) {
        this.parent = parent;
    }

    public DN getNewDn() throws Exception {
        if (this.newDn == null) {
            this.newDn = new DN(this.getParent().getName());
            this.newDn.add(this.getNewRdn().getUpName());
            this.newDn.normalize(this.session.getDirectoryService().getSchemaManager().getNormalizerMapping());
        }
        return this.newDn;
    }

    public String toString() {
        return "ReplaceContext for old DN '" + this.getDn().getName() + "'" + ", parent '" + this.parent + "'";
    }
}

