/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.SchemaManager;

public class SubstringEvaluator
implements Evaluator {
    private SchemaManager schemaManager;

    public SubstringEvaluator(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public boolean evaluate(ExprNode node, String dn, ServerEntry entry) throws NamingException {
        Pattern regex = null;
        SubstringNode snode = (SubstringNode)node;
        String oid = this.schemaManager.getAttributeTypeRegistry().getOidByName(snode.getAttribute());
        AttributeType type = this.schemaManager.lookupAttributeTypeRegistry(oid);
        MatchingRule matchingRule = type.getSubstring();
        if (matchingRule == null) {
            matchingRule = type.getEquality();
        }
        Normalizer normalizer = matchingRule.getNormalizer();
        EntryAttribute attr = entry.get(snode.getAttribute());
        if (null == attr) {
            return false;
        }
        try {
            regex = snode.getRegex(normalizer);
        }
        catch (PatternSyntaxException pse) {
            NamingException ne = new NamingException(I18n.err(I18n.ERR_248, node));
            ne.setRootCause(pse);
            throw ne;
        }
        for (Value value : attr) {
            String normValue = normalizer.normalize(value.getString());
            if (!regex.matcher(normValue).matches()) continue;
            return true;
        }
        return false;
    }
}

