/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.client.ClientModification;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerModification
implements Modification {
    public static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ServerModification.class);
    private ModificationOperation operation;
    private EntryAttribute attribute;

    public ServerModification() {
    }

    public ServerModification(ModificationOperation operation, EntryAttribute attribute) {
        this.operation = operation;
        this.attribute = attribute;
    }

    public ServerModification(SchemaManager schemaManager, Modification modification) {
        this.operation = modification.getOperation();
        EntryAttribute modAttribute = modification.getAttribute();
        try {
            AttributeType at = null;
            at = modAttribute instanceof ServerAttribute ? ((ServerAttribute)modAttribute).getAttributeType() : schemaManager.lookupAttributeTypeRegistry(modAttribute.getId());
            this.attribute = new DefaultServerAttribute(at, modAttribute);
        }
        catch (NamingException ne) {
            LOG.error(I18n.err(I18n.ERR_111, modAttribute.getId()));
        }
    }

    public ModificationOperation getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = ModificationOperation.getOperation(operation);
    }

    public void setOperation(ModificationOperation operation) {
        this.operation = operation;
    }

    public EntryAttribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(EntryAttribute attribute) {
        this.attribute = (ServerAttribute)attribute;
    }

    public Modification toClientModification() {
        ModificationOperation newOperation = this.operation;
        EntryAttribute newAttribute = ((ServerAttribute)this.attribute).toClientAttribute();
        ClientModification newModification = new ClientModification(newOperation, newAttribute);
        return newModification;
    }

    public int hashCode() {
        int h = 37;
        h += h * 17 + this.operation.getValue();
        h += h * 17 + this.attribute.hashCode();
        return h;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof ServerModification)) {
            return false;
        }
        ServerModification modification = (ServerModification)that;
        if (this.operation != modification.getOperation()) {
            return false;
        }
        if (this.attribute == null) {
            return modification.getAttribute() == null;
        }
        return this.attribute.equals(modification.getAttribute());
    }

    public ServerModification clone() {
        try {
            ServerModification clone = (ServerModification)super.clone();
            clone.attribute = (ServerAttribute)this.attribute.clone();
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        throw new IllegalStateException(I18n.err(I18n.ERR_456, new Object[0]));
    }

    public void readExternal(ObjectInput in) throws IOException {
        throw new IllegalStateException(I18n.err(I18n.ERR_456, new Object[0]));
    }

    public void deserialize(ObjectInput in, SchemaManager schemaManager) throws IOException, ClassNotFoundException, NamingException {
        int op = in.readInt();
        this.operation = ModificationOperation.getOperation(op);
        String oid = in.readUTF();
        AttributeType attributeType = schemaManager.lookupAttributeTypeRegistry(oid);
        this.attribute = new DefaultServerAttribute(attributeType);
        ((DefaultServerAttribute)this.attribute).deserialize(in);
    }

    public void serialize(ObjectOutput out) throws IOException {
        if (this.attribute == null) {
            throw new IOException(I18n.err(I18n.ERR_469, new Object[0]));
        }
        out.writeInt(this.operation.getValue());
        AttributeType at = ((DefaultServerAttribute)this.attribute).getAttributeType();
        out.writeUTF(at.getOid());
        ((DefaultServerAttribute)this.attribute).serialize(out);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Modification: ").append((Object)this.operation).append("\n").append(", attribute : ").append(this.attribute);
        return sb.toString();
    }
}

