/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.intermediate;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.codec.LdapResponseCodec;
import org.apache.directory.shared.ldap.util.StringTools;

public class IntermediateResponseCodec
extends LdapResponseCodec {
    private OID responseName;
    private byte[] responseValue;
    private int intermediateResponseLength;
    private int responseNameLength;

    public int getMessageType() {
        return 20;
    }

    public String getResponseName() {
        return this.responseName == null ? "" : this.responseName.toString();
    }

    public void setResponseName(OID responseName) {
        this.responseName = responseName;
    }

    public byte[] getResponseValue() {
        return this.responseValue;
    }

    public void setResponseValue(byte[] responseValue) {
        this.responseValue = responseValue;
    }

    public int computeLength() {
        this.intermediateResponseLength = 0;
        if (this.responseName != null) {
            this.responseNameLength = this.responseName.toString().length();
            this.intermediateResponseLength += 1 + TLV.getNbBytes(this.responseNameLength) + this.responseNameLength;
        }
        if (this.responseValue != null) {
            this.intermediateResponseLength += 1 + TLV.getNbBytes(this.responseValue.length) + this.responseValue.length;
        }
        return 1 + TLV.getNbBytes(this.intermediateResponseLength) + this.intermediateResponseLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)121);
            buffer.put(TLV.getBytes(this.intermediateResponseLength));
            if (this.responseName != null) {
                buffer.put((byte)-128);
                buffer.put(TLV.getBytes(this.responseNameLength));
                if (this.responseName.getOIDLength() != 0) {
                    buffer.put(StringTools.getBytesUtf8(this.responseName.toString()));
                }
            }
            if (this.responseValue != null) {
                buffer.put((byte)-127);
                buffer.put(TLV.getBytes(this.responseValue.length));
                if (this.responseValue.length != 0) {
                    buffer.put(this.responseValue);
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Intermediate Response\n");
        sb.append(super.toString());
        if (this.responseName != null) {
            sb.append("        Response name :'").append(this.responseName).append("'\n");
        }
        if (this.responseValue != null) {
            sb.append("        ResponseValue :'");
            sb.append(StringTools.dumpBytes(this.responseValue));
            sb.append("'\n");
        }
        return sb.toString();
    }
}

