/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared.store;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.protocol.shared.store.LdifLoadFilter;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifFileLoader {
    private static final Logger log = LoggerFactory.getLogger(LdifFileLoader.class);
    protected CoreSession coreSession;
    protected File ldif;
    protected final List<LdifLoadFilter> filters;
    protected final ClassLoader loader;
    private int count;

    public LdifFileLoader(CoreSession coreSession, String ldif) {
        this(coreSession, new File(ldif), null);
    }

    public LdifFileLoader(CoreSession coreSession, File ldif, List<? extends LdifLoadFilter> filters) {
        this(coreSession, ldif, filters, null);
    }

    public LdifFileLoader(CoreSession coreSession, File ldif, List<? extends LdifLoadFilter> filters, ClassLoader loader) {
        this.coreSession = coreSession;
        this.ldif = ldif;
        this.loader = loader;
        this.filters = filters == null ? Collections.emptyList() : Collections.unmodifiableList(filters);
    }

    private boolean applyFilters(LdapDN dn, Entry entry) {
        boolean accept = true;
        int limit = this.filters.size();
        if (limit == 0) {
            return true;
        }
        for (int ii = 0; ii < limit; ++ii) {
            try {
                accept &= this.filters.get(ii).filter(this.ldif, dn, entry, this.coreSession);
            }
            catch (NamingException e) {
                log.warn("filter " + this.filters.get(ii) + " was bypassed due to failures", e);
            }
            if (accept) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        Object rdn = null;
        InputStream in = null;
        try {
            in = this.getLdifStream();
            for (LdifEntry ldifEntry : new LdifReader(new BufferedReader(new InputStreamReader(in)))) {
                LdapDN dn = ldifEntry.getDn();
                if (ldifEntry.isEntry()) {
                    Entry entry = ldifEntry.getEntry();
                    boolean filterAccepted = this.applyFilters(dn, entry);
                    if (!filterAccepted) continue;
                    try {
                        this.coreSession.lookup(dn);
                        log.info("Found {}, will not create.", (Object)rdn);
                    }
                    catch (Exception e) {
                        try {
                            this.coreSession.add(new DefaultServerEntry(this.coreSession.getDirectoryService().getRegistries(), entry));
                            ++this.count;
                            log.info("Created {}.", (Object)rdn);
                        }
                        catch (NamingException e1) {
                            log.info("Could not create entry " + entry, e1);
                        }
                    }
                    continue;
                }
                List<Modification> items = ldifEntry.getModificationItems();
                try {
                    this.coreSession.modify(dn, items);
                    log.info("Modified: " + dn + " with modificationItems: " + items);
                }
                catch (NamingException e) {
                    log.info("Could not modify: " + dn + " with modificationItems: " + items, e);
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            log.error("LDIF file does not exist.");
        }
        catch (Exception ioe) {
            log.error("Failed to import LDIF into backing store.", ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.error("failed to close stream", e);
                }
            }
        }
        return this.count;
    }

    private InputStream getLdifStream() throws FileNotFoundException {
        if (!this.ldif.exists()) {
            InputStream in;
            if (this.loader != null && (in = this.loader.getResourceAsStream(this.ldif.getName())) != null) {
                return in;
            }
            in = this.getClass().getResourceAsStream(this.ldif.getName());
            if (in != null) {
                return in;
            }
            in = ClassLoader.getSystemResourceAsStream(this.ldif.getName());
            if (in != null) {
                return in;
            }
            throw new FileNotFoundException("LDIF file does not exist.");
        }
        FileInputStream in = new FileInputStream(this.ldif);
        return in;
    }
}

