/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.core.event.DirectoryListener;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.ldap.exception.OperationAbandonedException;
import org.apache.directory.shared.ldap.message.AbandonListener;
import org.apache.directory.shared.ldap.message.InternalAbandonableRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchAbandonListener
implements AbandonListener {
    private static final Logger LOG = LoggerFactory.getLogger(SearchAbandonListener.class);
    private final LdapServer ldapServer;
    private EntryFilteringCursor cursor;
    private DirectoryListener listener;

    public SearchAbandonListener(LdapServer ldapServer, EntryFilteringCursor cursor, DirectoryListener listener) {
        if (ldapServer == null) {
            throw new NullPointerException("ldapServer");
        }
        this.ldapServer = ldapServer;
        this.cursor = cursor;
        this.listener = listener;
    }

    public SearchAbandonListener(LdapServer ldapServer, DirectoryListener listener) {
        this(ldapServer, null, listener);
    }

    public SearchAbandonListener(LdapServer ldapServer, EntryFilteringCursor cursor) {
        this(ldapServer, cursor, null);
    }

    public void requestAbandoned(InternalAbandonableRequest req) {
        if (this.listener != null) {
            this.ldapServer.getDirectoryService().getEventService().removeListener(this.listener);
        }
        try {
            if (this.cursor != null) {
                this.cursor.close(new OperationAbandonedException());
            }
        }
        catch (Exception e) {
            LOG.error("Failed to close the search cursor for message {} on abandon request.", req.getMessageId(), (Object)e);
        }
    }
}

