/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.components;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.KerberosUtils;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPart;
import org.apache.directory.server.kerberos.shared.messages.components.InvalidTicketException;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.PrincipalName;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ticket
extends AbstractAsn1Object {
    private static final Logger LOG = LoggerFactory.getLogger(Ticket.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    public static final int TICKET_VNO = 5;
    private int tktvno;
    private byte[] realmBytes;
    private PrincipalName sName;
    private String realm;
    private EncryptedData encPart;
    private EncTicketPart encTicketPart;
    private transient int tktvnoLength;
    private transient int realmLength;
    private transient int sNameLength;
    private transient int encPartLength;
    private transient int ticketSeqLength;
    private transient int ticketLength;

    public Ticket(KerberosPrincipal serverPrincipal, EncryptedData encPart) throws InvalidTicketException {
        this(5, serverPrincipal, encPart);
        this.setServerPrincipal(serverPrincipal);
    }

    public Ticket() {
    }

    public Ticket(int tktvno, KerberosPrincipal serverPrincipal, EncryptedData encPart) throws InvalidTicketException {
        this.tktvno = tktvno;
        this.encPart = encPart;
        this.setServerPrincipal(serverPrincipal);
    }

    public void setEncTicketPart(EncTicketPart decryptedPart) {
        this.encTicketPart = decryptedPart;
    }

    public int getTktVno() {
        return this.tktvno;
    }

    public void setTktVno(int tktvno) {
        this.tktvno = tktvno;
    }

    public PrincipalName getSName() {
        return this.sName;
    }

    public KerberosPrincipal getServerPrincipal() {
        return KerberosUtils.getKerberosPrincipal(this.sName, this.realm);
    }

    public void setSName(PrincipalName sName) {
        this.sName = sName;
    }

    public void setServerPrincipal(KerberosPrincipal serverPrincipal) throws InvalidTicketException {
        try {
            this.sName = new PrincipalName(serverPrincipal.getName(), serverPrincipal.getNameType());
            this.realm = serverPrincipal.getRealm();
        }
        catch (ParseException pe) {
            LOG.error("Cannot create a ticket for the {} KerberosPrincipal, error : {}", serverPrincipal, (Object)pe.getMessage());
            throw new InvalidTicketException(ErrorType.KRB_ERR_GENERIC, "Cannot create a ticket : " + pe.getMessage());
        }
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public EncryptedData getEncPart() {
        return this.encPart;
    }

    public void setEncPart(EncryptedData encPart) {
        this.encPart = encPart;
    }

    public EncTicketPart getEncTicketPart() {
        return this.encTicketPart;
    }

    public int computeLength() {
        this.tktvnoLength = 1 + TLV.getNbBytes(this.tktvno) + Value.getNbBytes(this.tktvno);
        this.realmBytes = StringTools.getBytesUtf8(this.realm);
        this.realmLength = 1 + TLV.getNbBytes(this.realmBytes.length) + this.realmBytes.length;
        this.sNameLength = this.sName.computeLength();
        this.encPartLength = this.encPart.computeLength();
        this.ticketSeqLength = 1 + TLV.getNbBytes(this.tktvnoLength) + this.tktvnoLength + 1 + TLV.getNbBytes(this.realmLength) + this.realmLength + 1 + TLV.getNbBytes(this.sNameLength) + this.sNameLength + 1 + TLV.getNbBytes(this.encPartLength) + this.encPartLength;
        this.ticketLength = 1 + TLV.getNbBytes(this.ticketSeqLength) + this.ticketSeqLength;
        return 1 + TLV.getNbBytes(this.ticketLength) + this.ticketLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            buffer = ByteBuffer.allocate(this.computeLength());
        }
        try {
            buffer.put((byte)97);
            buffer.put(TLV.getBytes(this.ticketLength));
            buffer.put((byte)48);
            buffer.put(TLV.getBytes(this.ticketSeqLength));
            buffer.put((byte)-96);
            buffer.put(TLV.getBytes(this.tktvnoLength));
            Value.encode(buffer, this.tktvno);
            buffer.put((byte)-95);
            buffer.put(TLV.getBytes(this.realmLength));
            buffer.put((byte)27);
            buffer.put(TLV.getBytes(this.realmBytes.length));
            buffer.put(this.realmBytes);
            buffer.put((byte)-94);
            buffer.put(TLV.getBytes(this.sNameLength));
            this.sName.encode(buffer);
            buffer.put((byte)-93);
            buffer.put(TLV.getBytes(this.encPartLength));
            this.encPart.encode(buffer);
        }
        catch (BufferOverflowException boe) {
            LOG.error("Cannot encode the Ticket object, the PDU size is {} when only {} bytes has been allocated", 1 + TLV.getNbBytes(this.ticketLength) + this.ticketLength, (Object)buffer.capacity());
            throw new EncoderException("The PDU buffer size is too small !");
        }
        if (IS_DEBUG) {
            LOG.debug("Ticket encoding : {}", (Object)StringTools.dumpBytes(buffer.array()));
            LOG.debug("Ticket initial value : {}", (Object)this.toString());
        }
        return buffer;
    }
}

