/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.ldap.Control;
import org.apache.commons.lang.NotImplementedException;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.ReferralHandlingMode;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.AbstractOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindOperationContext
implements OperationContext {
    private byte[] credentials;
    private String saslMechanism;
    private String saslAuthId;
    private static final Control[] EMPTY_CONTROLS = new Control[0];
    private LdapDN dn;
    private Map<String, Control> requestControls = new HashMap<String, Control>(4);
    private Map<String, Control> responseControls = new HashMap<String, Control>(4);
    private boolean collateralOperation;
    private Collection<String> bypassed;
    private CoreSession session;
    private LdapPrincipal authorizedPrincipal;
    private OperationContext next;
    private OperationContext previous;
    private ReferralHandlingMode referralHandlingMode;
    private ClonedServerEntry entry;

    public BindOperationContext(CoreSession session) {
        this.session = session;
    }

    public AuthenticationLevel getAuthenticationLevel() {
        if (this.saslMechanism == null) {
            if (this.dn.isEmpty()) {
                if (StringTools.isEmpty(this.credentials)) {
                    return AuthenticationLevel.NONE;
                }
                return AuthenticationLevel.INVALID;
            }
            if (StringTools.isEmpty(this.credentials)) {
                return AuthenticationLevel.UNAUTHENT;
            }
            return AuthenticationLevel.SIMPLE;
        }
        return AuthenticationLevel.STRONG;
    }

    public String getSaslMechanism() {
        return this.saslMechanism;
    }

    public void setSaslMechanism(String saslMechanism) {
        this.saslMechanism = saslMechanism;
    }

    public byte[] getCredentials() {
        return this.credentials;
    }

    public void setCredentials(byte[] credentials) {
        this.credentials = credentials;
    }

    public String getSaslAuthId() {
        return this.saslAuthId;
    }

    public void setSaslAuthId(String saslAuthId) {
        this.saslAuthId = saslAuthId;
    }

    public boolean isSaslBind() {
        return this.saslMechanism != null;
    }

    @Override
    public String getName() {
        return MessageTypeEnum.BIND_REQUEST.name();
    }

    public String toString() {
        return "BindContext for DN '" + this.getDn().getUpName() + "', credentials <" + (this.credentials != null ? StringTools.dumpBytes(this.credentials) : "") + ">" + (this.saslMechanism != null ? ", saslMechanism : <" + this.saslMechanism + ">" : "") + (this.saslAuthId != null ? ", saslAuthId <" + this.saslAuthId + ">" : "");
    }

    @Override
    public CoreSession getSession() {
        return this.session;
    }

    public void setSession(CoreSession session) {
        this.session = session;
    }

    public boolean isCollateralOperation() {
        return this.collateralOperation;
    }

    public void setCollateralOperation(boolean collateralOperation) {
        this.collateralOperation = collateralOperation;
    }

    @Override
    public LdapDN getDn() {
        return this.dn;
    }

    @Override
    public void setDn(LdapDN dn) {
        this.dn = dn;
    }

    @Override
    public void addRequestControl(Control requestControl) {
        this.requestControls.put(requestControl.getID(), requestControl);
    }

    @Override
    public Control getRequestControl(String numericOid) {
        return this.requestControls.get(numericOid);
    }

    @Override
    public boolean hasRequestControl(String numericOid) {
        return this.requestControls.containsKey(numericOid);
    }

    @Override
    public boolean hasRequestControls() {
        return !this.requestControls.isEmpty();
    }

    @Override
    public void addResponseControl(Control responseControl) {
        this.responseControls.put(responseControl.getID(), responseControl);
    }

    @Override
    public Control getResponseControl(String numericOid) {
        return this.responseControls.get(numericOid);
    }

    @Override
    public boolean hasResponseControl(String numericOid) {
        return this.responseControls.containsKey(numericOid);
    }

    @Override
    public Control[] getResponseControls() {
        if (this.responseControls.isEmpty()) {
            return EMPTY_CONTROLS;
        }
        return this.responseControls.values().toArray(EMPTY_CONTROLS);
    }

    @Override
    public boolean hasResponseControls() {
        return !this.responseControls.isEmpty();
    }

    @Override
    public int getResponseControlCount() {
        return this.responseControls.size();
    }

    @Override
    public void addRequestControls(Control[] requestControls) {
        for (Control c : requestControls) {
            this.requestControls.put(c.getID(), c);
        }
    }

    @Override
    public Collection<String> getByPassed() {
        if (this.bypassed == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.bypassed);
    }

    @Override
    public void setByPassed(Collection<String> byPassed) {
        this.bypassed = byPassed;
    }

    @Override
    public boolean isBypassed(String interceptorName) {
        return this.bypassed != null && this.bypassed.contains(interceptorName);
    }

    @Override
    public boolean hasBypass() {
        return this.bypassed != null && !this.bypassed.isEmpty();
    }

    @Override
    public LookupOperationContext newLookupContext(LdapDN dn) {
        return new LookupOperationContext(this.session, dn);
    }

    @Override
    public ClonedServerEntry lookup(LookupOperationContext opContext) throws Exception {
        return this.session.getDirectoryService().getOperationManager().lookup(opContext);
    }

    @Override
    public ClonedServerEntry lookup(LdapDN dn, Collection<String> byPassed) throws Exception {
        LookupOperationContext opContext = this.newLookupContext(dn);
        opContext.setByPassed(byPassed);
        return this.session.getDirectoryService().getOperationManager().lookup(opContext);
    }

    @Override
    public LdapPrincipal getEffectivePrincipal() {
        if (this.authorizedPrincipal != null) {
            return this.authorizedPrincipal;
        }
        return this.session.getEffectivePrincipal();
    }

    @Override
    public boolean isFirstOperation() {
        return this.previous == null;
    }

    @Override
    public OperationContext getFirstOperation() {
        if (this.previous == null) {
            return this;
        }
        return this.previous.getFirstOperation();
    }

    @Override
    public OperationContext getLastOperation() {
        if (this.next == null) {
            return this;
        }
        return this.next.getLastOperation();
    }

    @Override
    public OperationContext getNextOperation() {
        return this.next;
    }

    @Override
    public OperationContext getPreviousOperation() {
        return this.previous;
    }

    @Override
    public void add(ServerEntry entry, Collection<String> bypass) throws Exception {
        throw new NotImplementedException();
    }

    @Override
    public void delete(LdapDN dn, Collection<String> bypass) throws Exception {
        throw new NotImplementedException();
    }

    @Override
    public void modify(LdapDN dn, List<Modification> mods, Collection<String> bypass) throws Exception {
        throw new NotImplementedException();
    }

    private void setup(AbstractOperationContext opContext) {
        opContext.setPreviousOperation(this);
        this.next = opContext;
        opContext.setByPassed(opContext.getByPassed());
        opContext.setAuthorizedPrincipal(this.authorizedPrincipal);
    }

    @Override
    public boolean hasEntry(LdapDN dn, Collection<String> byPassed) throws Exception {
        EntryOperationContext opContext = new EntryOperationContext(this.session, dn);
        this.setup(opContext);
        opContext.setByPassed(byPassed);
        return this.session.getDirectoryService().getOperationManager().hasEntry(opContext);
    }

    public ReferralHandlingMode getReferralHandlingMode() {
        return this.referralHandlingMode;
    }

    public void setReferralHandlingMode(ReferralHandlingMode referralHandlingMode) {
        this.referralHandlingMode = referralHandlingMode;
    }

    @Override
    public ClonedServerEntry getEntry() {
        return this.entry;
    }

    @Override
    public void setEntry(ClonedServerEntry entry) {
        this.entry = entry;
    }

    @Override
    public void throwReferral() {
        throw new NotImplementedException(" The throwReferral method is not implemented for a Bind operation");
    }

    @Override
    public boolean isReferralThrown() {
        throw new NotImplementedException(" The isReferralThrown method is not implemented for a Bind operation");
    }

    @Override
    public void ignoreReferral() {
        throw new NotImplementedException(" The ignoreReferral method is not implemented for a Bind operation");
    }

    @Override
    public boolean isReferralIgnored() {
        throw new NotImplementedException(" The isReferralIgnored method is not implemented for a Bind operation");
    }
}

