/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Comparator;
import org.apache.directory.server.core.avltree.ArrayTree;
import org.apache.directory.server.core.avltree.DefaultMarshaller;
import org.apache.directory.server.core.avltree.Marshaller;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayMarshaller<E>
implements Marshaller<ArrayTree<E>> {
    private static final Logger LOG = LoggerFactory.getLogger(ArrayMarshaller.class);
    private static final byte[] EMPTY_TREE = new byte[1];
    private Marshaller<E> keyMarshaller;
    private Comparator<E> comparator;

    public ArrayMarshaller(Comparator<E> comparator, Marshaller<E> keyMarshaller) {
        this.comparator = comparator;
        this.keyMarshaller = keyMarshaller;
    }

    public ArrayMarshaller(Comparator<E> comparator) {
        this.comparator = comparator;
        this.keyMarshaller = DefaultMarshaller.INSTANCE;
    }

    @Override
    public byte[] serialize(ArrayTree<E> tree) {
        if (tree == null || tree.size() == 0) {
            return EMPTY_TREE;
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        byte[] data = null;
        try {
            out.writeByte(0);
            out.writeInt(tree.size());
            for (int position = 0; position < tree.size(); ++position) {
                E value = tree.get(position);
                byte[] bytes = this.keyMarshaller.serialize(value);
                out.writeInt(bytes.length);
                if (bytes.length == 0) continue;
                out.write(bytes);
            }
            out.flush();
            data = byteStream.toByteArray();
            try {
                this.deserialize(data);
            }
            catch (NullPointerException npe) {
                System.out.println("Bad serialization, tree : [" + StringTools.dumpBytes(data) + "]");
                throw npe;
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    @Override
    public ArrayTree<E> deserialize(byte[] data) throws IOException {
        LOG.debug("Deserializing the tree, called by {}", (Object)Reflection.getCallerClass((int)2).getSimpleName());
        try {
            if (data == null || data.length == 0) {
                throw new IOException("Null or empty data array is invalid.");
            }
            if (data.length == 1 && data[0] == 0) {
                Object[] array = new Object[]{};
                ArrayTree<Object> tree = new ArrayTree<Object>(this.comparator, array);
                return tree;
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            DataInputStream din = new DataInputStream(bin);
            byte startByte = din.readByte();
            if (startByte != 0) {
                throw new IOException("wrong array serialized data format");
            }
            int size = din.readInt();
            Object[] nodes = new Object[size];
            for (int i = 0; i < size; ++i) {
                int dataSize = din.readInt();
                if (dataSize == 0) continue;
                byte[] bytes = new byte[dataSize];
                din.read(bytes);
                E key = this.keyMarshaller.deserialize(bytes);
                nodes[i] = key;
            }
            ArrayTree<Object> arrayTree = new ArrayTree<Object>(this.comparator, nodes);
            return arrayTree;
        }
        catch (NullPointerException npe) {
            System.out.println("Bad tree : [" + StringTools.dumpBytes(data) + "]");
            throw npe;
        }
    }
}

