/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntax;

import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.schema.syntax.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class OidSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String SC_OID = "1.3.6.1.4.1.1466.115.121.1.38";

    public OidSyntaxChecker() {
        super(SC_OID);
    }

    protected OidSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            return false;
        }
        if (StringTools.isDigit(strValue.charAt(0))) {
            return OID.isOID(strValue);
        }
        if (StringTools.isAlphaASCII(strValue, 0)) {
            for (int index = 0; index < strValue.length(); ++index) {
                if (StringTools.isAlphaDigitMinus(strValue, index)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

