/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import java.util.Comparator;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizingComparator
implements Comparator {
    private static final Logger log = LoggerFactory.getLogger(NormalizingComparator.class);
    private Normalizer normalizer;
    private Comparator<Object> comparator;

    public NormalizingComparator(Normalizer normalizer, Comparator<Object> comparator) {
        this.normalizer = normalizer;
        this.comparator = comparator;
    }

    public int compare(Object o1, Object o2) {
        Object n2;
        Object n1;
        try {
            n1 = this.normalizer.normalize(o1);
        }
        catch (NamingException e) {
            log.warn("Failed to normalize: " + o1, e);
            n1 = o1;
        }
        try {
            n2 = this.normalizer.normalize(o2);
        }
        catch (NamingException e) {
            log.warn("Failed to normalize: " + o2, e);
            n2 = o2;
        }
        return this.comparator.compare(n1, n2);
    }
}

