/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.NoOpNormalizer;
import org.apache.directory.shared.ldap.schema.Normalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstringEvaluator
implements Evaluator<SubstringNode, ServerEntry> {
    private final Store<ServerEntry> db;
    private final Registries registries;
    private final SubstringNode node;
    private final Pattern regex;
    private final AttributeType type;
    private final Normalizer normalizer;
    private final Index<String, ServerEntry> idx;

    public SubstringEvaluator(SubstringNode node, Store<ServerEntry> db, Registries registries) throws Exception {
        this.db = db;
        this.node = node;
        this.registries = registries;
        String oid = registries.getOidRegistry().getOid(node.getAttribute());
        this.type = registries.getAttributeTypeRegistry().lookup(oid);
        MatchingRule rule = this.type.getSubstr();
        if (rule == null) {
            rule = this.type.getEquality();
        }
        this.normalizer = rule != null ? rule.getNormalizer() : new NoOpNormalizer();
        this.regex = node.getRegex(this.normalizer);
        this.idx = db.hasUserIndexOn(node.getAttribute()) ? db.getUserIndex(node.getAttribute()) : null;
    }

    @Override
    public boolean evaluate(IndexEntry<?, ServerEntry> indexEntry) throws Exception {
        if (this.idx == null) {
            return this.evaluateWithoutIndex(indexEntry);
        }
        return this.evaluateWithIndex(indexEntry);
    }

    @Override
    public boolean evaluate(Long id) throws Exception {
        if (this.idx == null) {
            return this.evaluateWithoutIndex(id);
        }
        return this.evaluateWithIndex(id);
    }

    @Override
    public boolean evaluate(ServerEntry entry) throws Exception {
        if (this.idx == null) {
            return this.evaluateWithoutIndex(entry);
        }
        return this.evaluateWithIndex(entry);
    }

    public Pattern getPattern() {
        return this.regex;
    }

    @Override
    public SubstringNode getExpression() {
        return this.node;
    }

    private boolean evaluateWithIndex(IndexEntry<?, ServerEntry> indexEntry) throws Exception {
        IndexCursor<String, ServerEntry> entries = this.idx.reverseCursor(indexEntry.getId());
        while (entries.next()) {
            IndexEntry rec = (IndexEntry)entries.get();
            if (!this.regex.matcher((String)rec.getValue()).matches()) continue;
            entries.close();
            return true;
        }
        return false;
    }

    private boolean evaluateWithIndex(ServerEntry entry) throws Exception {
        throw new UnsupportedOperationException("This is too inefficient without getId() on ServerEntry");
    }

    private boolean evaluateWithIndex(Long id) throws Exception {
        IndexCursor<String, ServerEntry> entries = this.idx.reverseCursor(id);
        while (entries.next()) {
            IndexEntry rec = (IndexEntry)entries.get();
            if (!this.regex.matcher((String)rec.getValue()).matches()) continue;
            entries.close();
            return true;
        }
        return false;
    }

    private boolean evaluateWithoutIndex(Long id) throws Exception {
        return this.evaluateWithoutIndex(this.db.lookup(id));
    }

    private boolean evaluateWithoutIndex(ServerEntry entry) throws Exception {
        ServerAttribute attr = (ServerAttribute)entry.get(this.type);
        if (attr != null) {
            for (Value value : attr) {
                value.normalize(this.normalizer);
                String strValue = (String)value.getNormalizedValue();
                if (!this.regex.matcher(strValue).matches()) continue;
                return true;
            }
        }
        if (this.registries.getAttributeTypeRegistry().hasDescendants(this.node.getAttribute())) {
            Iterator<AttributeType> descendants = this.registries.getAttributeTypeRegistry().descendants(this.node.getAttribute());
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = (ServerAttribute)entry.get(descendant);
                if (null == attr) continue;
                for (Value value : attr) {
                    value.normalize(this.normalizer);
                    String strValue = (String)value.getNormalizedValue();
                    if (!this.regex.matcher(strValue).matches()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean evaluateWithoutIndex(IndexEntry<String, ServerEntry> indexEntry) throws Exception {
        ServerAttribute attr;
        ServerEntry entry = indexEntry.getObject();
        if (null == entry) {
            entry = this.db.lookup(indexEntry.getId());
            indexEntry.setObject(entry);
        }
        if ((attr = (ServerAttribute)entry.get(this.type)) != null) {
            for (Value value : attr) {
                value.normalize(this.normalizer);
                String strValue = (String)value.getNormalizedValue();
                if (!this.regex.matcher(strValue).matches()) continue;
                indexEntry.setValue(strValue);
                return true;
            }
        }
        if (this.registries.getAttributeTypeRegistry().hasDescendants(this.node.getAttribute())) {
            Iterator<AttributeType> descendants = this.registries.getAttributeTypeRegistry().descendants(this.node.getAttribute());
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = (ServerAttribute)entry.get(descendant);
                if (null == attr) continue;
                for (Value value : attr) {
                    value.normalize(this.normalizer);
                    String strValue = (String)value.getNormalizedValue();
                    if (!this.regex.matcher(strValue).matches()) continue;
                    indexEntry.setValue(strValue);
                    return true;
                }
            }
        }
        return false;
    }
}

