/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.ByteArrayComparator;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.NoOpNormalizer;
import org.apache.directory.shared.ldap.schema.Normalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualityEvaluator<T>
implements Evaluator<EqualityNode<T>, ServerEntry> {
    private final EqualityNode<T> node;
    private final Store<ServerEntry> db;
    private final Registries registries;
    private final AttributeType type;
    private final Normalizer normalizer;
    private final Comparator comparator;
    private final Index<T, ServerEntry> idx;

    public EqualityEvaluator(EqualityNode<T> node, Store<ServerEntry> db, Registries registries) throws Exception {
        this.db = db;
        this.node = node;
        this.registries = registries;
        if (db.hasUserIndexOn(node.getAttribute())) {
            this.idx = db.getUserIndex(node.getAttribute());
            this.type = null;
            this.normalizer = null;
            this.comparator = null;
        } else {
            this.idx = null;
            this.type = registries.getAttributeTypeRegistry().lookup(node.getAttribute());
            MatchingRule mr = this.type.getEquality();
            if (mr == null) {
                this.normalizer = NoOpNormalizer.INSTANCE;
                this.comparator = ByteArrayComparator.INSTANCE;
            } else {
                this.normalizer = mr.getNormalizer();
                this.comparator = mr.getComparator();
            }
        }
    }

    @Override
    public EqualityNode<T> getExpression() {
        return this.node;
    }

    @Override
    public boolean evaluate(IndexEntry<?, ServerEntry> indexEntry) throws Exception {
        if (this.idx != null) {
            return this.idx.forward(this.node.getValue().get(), indexEntry.getId());
        }
        ServerEntry entry = indexEntry.getObject();
        if (null == entry) {
            entry = this.db.lookup(indexEntry.getId());
            indexEntry.setObject(entry);
        }
        return this.evaluate(entry);
    }

    @Override
    public boolean evaluate(ServerEntry entry) throws Exception {
        ServerAttribute attr = (ServerAttribute)entry.get(this.type);
        if (attr != null && this.evaluate(attr)) {
            return true;
        }
        if (this.registries.getAttributeTypeRegistry().hasDescendants(this.node.getAttribute())) {
            Iterator<AttributeType> descendants = this.registries.getAttributeTypeRegistry().descendants(this.node.getAttribute());
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = (ServerAttribute)entry.get(descendant);
                if (attr == null || !this.evaluate(attr)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean evaluate(Long id) throws Exception {
        if (this.idx != null) {
            return this.idx.reverse(id);
        }
        return this.evaluate(this.db.lookup(id));
    }

    @Override
    private boolean evaluate(ServerAttribute attribute) throws Exception {
        for (Value value : attribute) {
            value.normalize(this.normalizer);
            if (this.comparator.compare(value.getNormalizedValue(), this.node.getValue().getNormalizedValue()) != 0) continue;
            return true;
        }
        return false;
    }
}

