/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.bootstrap;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ProducerTypeEnum {
    NORMALIZER_PRODUCER(0),
    COMPARATOR_PRODUCER(1),
    SYNTAX_CHECKER_PRODUCER(2),
    SYNTAX_PRODUCER(3),
    MATCHING_RULE_PRODUCER(4),
    ATTRIBUTE_TYPE_PRODUCER(5),
    OBJECT_CLASS_PRODUCER(6),
    MATCHING_RULE_USE_PRODUCER(7),
    DIT_CONTENT_RULE_PRODUCER(8),
    NAME_FORM_PRODUCER(9),
    DIT_STRUCTURE_RULE_PRODUCER(10);

    private int value;

    private ProducerTypeEnum(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ProducerTypeEnum getProducerType(String producerType) {
        return ProducerTypeEnum.valueOf(producerType);
    }

    public static List<ProducerTypeEnum> getList() {
        ArrayList<ProducerTypeEnum> list = new ArrayList<ProducerTypeEnum>();
        list.add(NORMALIZER_PRODUCER);
        list.add(COMPARATOR_PRODUCER);
        list.add(SYNTAX_CHECKER_PRODUCER);
        list.add(SYNTAX_PRODUCER);
        list.add(MATCHING_RULE_PRODUCER);
        list.add(ATTRIBUTE_TYPE_PRODUCER);
        list.add(OBJECT_CLASS_PRODUCER);
        list.add(MATCHING_RULE_USE_PRODUCER);
        list.add(DIT_CONTENT_RULE_PRODUCER);
        list.add(NAME_FORM_PRODUCER);
        list.add(DIT_STRUCTURE_RULE_PRODUCER);
        return list;
    }

    public String getName() {
        switch (this) {
            case NORMALIZER_PRODUCER: {
                return "NormalizerProducer";
            }
            case COMPARATOR_PRODUCER: {
                return "ComparatorProducer";
            }
            case SYNTAX_CHECKER_PRODUCER: {
                return "SyntaxCheckerProducer";
            }
            case SYNTAX_PRODUCER: {
                return "SyntaxProducer";
            }
            case MATCHING_RULE_PRODUCER: {
                return "MatchingRuleProducer";
            }
            case ATTRIBUTE_TYPE_PRODUCER: {
                return "AttributeTypeProducer";
            }
            case OBJECT_CLASS_PRODUCER: {
                return "ObjectClassProducer";
            }
            case MATCHING_RULE_USE_PRODUCER: {
                return "MatchingRuleUseProducer";
            }
            case DIT_CONTENT_RULE_PRODUCER: {
                return "DitContentRuleProducer";
            }
            case NAME_FORM_PRODUCER: {
                return "NameFormProducer";
            }
            case DIT_STRUCTURE_RULE_PRODUCER: {
                return "DitStructureRuleProducer";
            }
        }
        return "";
    }
}

